/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.api.tileentity.IAirListener;
import me.desht.pneumaticcraft.api.tileentity.IManoMeasurable;
import me.desht.pneumaticcraft.common.block.BlockPressureTube;
import me.desht.pneumaticcraft.common.block.tubes.IInfluenceDispersing;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.item.ItemTubeModule;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.RayTraceUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class TileEntityPressureTube
extends TileEntityPneumaticBase
implements IAirListener,
IManoMeasurable,
ICamouflageableTE {
    @DescSynced
    private final boolean[] sidesClosed = new boolean[6];
    private final EnumMap<Direction, TubeModule> modules = new EnumMap(Direction.class);
    private BlockState camoState;
    private AxisAlignedBB renderBoundingBox = null;
    private Direction inLineModuleDir = null;
    private final List<Direction> neighbourDirections = new ArrayList<Direction>();
    private VoxelShape cachedTubeShape = null;
    private int pendingCacheShapeClear = 0;

    public TileEntityPressureTube() {
        this((TileEntityType)ModTileEntities.PRESSURE_TUBE.get(), 5.0f, 7.0f, 1000, 0);
    }

    TileEntityPressureTube(TileEntityType type, float dangerPressurePressureTube, float maxPressurePressureTube, int volumePressureTube, int upgradeSlots) {
        super(type, dangerPressurePressureTube, maxPressurePressureTube, volumePressureTube, upgradeSlots);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        byte closed = tag.func_74771_c("sidesClosed");
        for (int i = 0; i < 6; ++i) {
            this.sidesClosed[i] = (closed & 1 << i) != 0;
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        byte closed = 0;
        for (int i = 0; i < 6; ++i) {
            if (!this.sidesClosed[i]) continue;
            closed = (byte)(closed | 1 << i);
        }
        nbt.func_74774_a("sidesClosed", closed);
        return nbt;
    }

    @Override
    public void writeToPacket(CompoundNBT tag) {
        super.writeToPacket(tag);
        this.writeModulesToNBT(tag);
        ICamouflageableTE.writeCamo(tag, this.camoState);
    }

    public void writeModulesToNBT(CompoundNBT tag) {
        ListNBT moduleList = new ListNBT();
        for (Direction d : DirectionUtil.VALUES) {
            TubeModule tm = this.getModule(d);
            if (tm == null) continue;
            CompoundNBT moduleTag = new CompoundNBT();
            moduleTag.func_74778_a("type", tm.getType().toString());
            tm.writeToNBT(moduleTag);
            moduleList.add((Object)moduleTag);
        }
        tag.func_218657_a("modules", (INBT)moduleList);
    }

    @Override
    public void readFromPacket(CompoundNBT tag) {
        super.readFromPacket(tag);
        this.clearCachedShape();
        EnumSet<Direction> dirs = EnumSet.allOf(Direction.class);
        ListNBT moduleList = tag.func_150295_c("modules", 10);
        for (int i = 0; i < moduleList.size(); ++i) {
            CompoundNBT moduleTag = moduleList.func_150305_b(i);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(moduleTag.func_74779_i("type")));
            if (item instanceof ItemTubeModule) {
                TubeModule module = ((ItemTubeModule)item).createModule();
                module.readFromNBT(moduleTag);
                TubeModule oldModule = this.getModule(module.getDirection());
                if (oldModule != null && !oldModule.getType().equals((Object)module.getType())) {
                    oldModule.onRemoved();
                }
                this.setModule(module.getDirection(), module);
                dirs.remove(module.getDirection());
                continue;
            }
            Log.error("unknown tube module type: " + moduleTag.func_74779_i("type"), new Object[0]);
        }
        for (Direction d : dirs) {
            TubeModule module = this.getModule(d);
            if (module == null) continue;
            this.setModule(d, null);
        }
        this.updateRenderBoundingBox();
        if (this.func_145830_o() && this.func_145831_w().field_72995_K) {
            this.rerenderTileEntity();
        }
        this.camoState = ICamouflageableTE.readCamo(tag);
    }

    public void updateRenderBoundingBox() {
        this.renderBoundingBox = new AxisAlignedBB(this.func_174877_v());
        for (Direction dir : DirectionUtil.VALUES) {
            if (!this.modules.containsKey(dir) || this.modules.get(dir).getRenderBoundingBox() == null) continue;
            this.renderBoundingBox = this.renderBoundingBox.func_111270_a(this.modules.get(dir).getRenderBoundingBox());
        }
    }

    @Override
    public void func_73660_a() {
        boolean hasModules = false;
        boolean hasClosedSide = false;
        if (this.pendingCacheShapeClear > 0 && --this.pendingCacheShapeClear == 0) {
            this.cachedTubeShape = null;
        }
        if (!this.func_145831_w().field_72995_K) {
            this.airHandler.setSideLeaking(null);
        }
        for (Direction dir : DirectionUtil.VALUES) {
            TubeModule tm = this.getModule(dir);
            if (tm != null) {
                hasModules = true;
                tm.shouldDrop = true;
                tm.update();
            }
            if (!this.isSideClosed(dir)) continue;
            hasClosedSide = true;
        }
        if (!(this.func_145831_w().field_72995_K || hasModules || hasClosedSide || this.neighbourDirections.size() != 1)) {
            Direction d = this.neighbourDirections.get(0).func_176734_d();
            this.airHandler.setSideLeaking((Direction)(this.canConnectPneumatic(d) ? d : null));
        }
        super.func_73660_a();
    }

    @Override
    protected void onFirstServerTick() {
        super.onFirstServerTick();
        this.neighbourDirections.clear();
        this.airHandler.getConnectedAirHandlers(this).forEach(connection -> this.neighbourDirections.add(connection.getDirection()));
    }

    @Override
    public void onAirDispersion(IAirHandlerMachine handler, @Nullable Direction side, int airDispersed) {
        TubeModule tm;
        if (side != null && (tm = this.getModule(side)) instanceof IInfluenceDispersing) {
            ((IInfluenceDispersing)((Object)tm)).onAirDispersion(airDispersed);
        }
    }

    @Override
    public int getMaxDispersion(IAirHandlerMachine handler, @Nullable Direction side) {
        TubeModule tm;
        if (side != null && (tm = this.getModule(side)) instanceof IInfluenceDispersing) {
            return ((IInfluenceDispersing)((Object)tm)).getMaxDispersion();
        }
        return Integer.MAX_VALUE;
    }

    public TubeModule getModule(Direction side) {
        return this.modules.get(side);
    }

    public boolean isSideClosed(Direction side) {
        return this.sidesClosed[side.func_176745_a()];
    }

    public void setSideClosed(Direction side, boolean closed) {
        this.sidesClosed[side.func_176745_a()] = closed;
    }

    public Stream<TubeModule> tubeModules() {
        return this.modules.values().stream().filter(Objects::nonNull);
    }

    public boolean mayPlaceModule(TubeModule module, Direction side) {
        return this.inLineModuleDir == null && this.getModule(side) == null && !this.isSideClosed(side) && (!module.isInline() || this.getConnectedNeighbor(side) == null);
    }

    public void setModule(Direction side, TubeModule module) {
        if (module != null) {
            module.setDirection(side);
            module.setTube(this);
            if (module.isInline()) {
                this.inLineModuleDir = side;
            }
        } else {
            if (this.inLineModuleDir == side) {
                this.inLineModuleDir = null;
            }
            if (this.modules.containsKey(side)) {
                this.modules.get(side).onRemoved();
            }
        }
        this.clearCachedShape();
        if (module != null) {
            this.modules.put(side, module);
        } else {
            this.modules.remove(side);
        }
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            this.func_145831_w().func_180501_a(this.func_174877_v(), BlockPressureTube.recalculateState((IWorld)this.field_145850_b, this.field_174879_c, this.func_195044_w()), 3);
            this.sendDescriptionPacket();
            this.func_70296_d();
        }
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return !(this.inLineModuleDir != null && this.inLineModuleDir.func_176740_k() != side.func_176740_k() || this.isSideClosed(side) || this.getModule(side) != null && !this.getModule(side).isInline());
    }

    @Override
    public void onNeighborTileUpdate(BlockPos tilePos) {
        super.onNeighborTileUpdate(tilePos);
        this.tubeModules().filter(module -> this.func_174877_v().func_177972_a(module.getDirection()).equals((Object)tilePos)).forEach(TubeModule::onNeighborTileUpdate);
    }

    @Override
    public void onNeighborBlockUpdate(BlockPos fromPos) {
        super.onNeighborBlockUpdate(fromPos);
        this.tubeModules().forEach(TubeModule::onNeighborBlockUpdate);
        this.neighbourDirections.clear();
        this.airHandler.getConnectedAirHandlers(this).forEach(connection -> this.neighbourDirections.add(connection.getDirection()));
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    public TileEntity getConnectedNeighbor(Direction dir) {
        TileEntity te;
        TubeModule tm = this.getModule(dir);
        if (!this.isSideClosed(dir) && (tm == null || tm.isInline() && dir.func_176740_k() == tm.getDirection().func_176740_k()) && (te = this.getCachedNeighbor(dir)) != null && te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, dir.func_176734_d()).isPresent()) {
            return te;
        }
        return null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.renderBoundingBox != null ? this.renderBoundingBox : new AxisAlignedBB(this.func_174877_v());
    }

    @Override
    public void printManometerMessage(PlayerEntity player, List<ITextComponent> text) {
        TubeModule tm;
        RayTraceResult mop = RayTraceUtils.getEntityLookedObject((LivingEntity)player, PneumaticCraftUtils.getPlayerReachDistance(player));
        if (mop.hitInfo instanceof Direction && (tm = this.getModule((Direction)mop.hitInfo)) != null) {
            tm.addInfo(text);
        }
    }

    @Override
    public BlockState getCamouflage() {
        return this.camoState;
    }

    @Override
    public void setCamouflage(BlockState state) {
        this.camoState = state;
        ICamouflageableTE.syncToClient(this);
    }

    public VoxelShape getCachedTubeShape(VoxelShape blockShape) {
        if (this.cachedTubeShape == null) {
            this.cachedTubeShape = blockShape;
            this.tubeModules().forEach(module -> {
                this.cachedTubeShape = VoxelShapes.func_197872_a((VoxelShape)this.cachedTubeShape, (VoxelShape)module.getShape());
            });
        }
        return this.cachedTubeShape;
    }

    public void clearCachedShape() {
        this.pendingCacheShapeClear = 2;
    }
}

