/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerEtchingTank;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.ItemEmptyPCB;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.tileentity.ISerializableTanks;
import me.desht.pneumaticcraft.common.tileentity.SmartSyncTank;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import me.desht.pneumaticcraft.common.tileentity.TileEntityUVLightBox;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityEtchingTank
extends TileEntityTickableBase
implements INamedContainerProvider,
ISerializableTanks,
IHeatExchangingTE {
    public static final int ETCHING_SLOTS = 25;
    private final EtchingTankHandler itemHandler = new EtchingTankHandler();
    private final LazyOptional<IItemHandler> itemCap = LazyOptional.of(() -> this.itemHandler);
    private final OutputItemHandler outputHandler = new OutputItemHandler();
    private final FailedItemHandler failedHandler = new FailedItemHandler();
    private final WrappedInvHandler sideHandler = new WrappedInvHandler((IItemHandler)this.outputHandler);
    private final LazyOptional<IItemHandler> sideCap = LazyOptional.of(() -> this.sideHandler);
    private final WrappedInvHandler endHandler = new WrappedInvHandler((IItemHandler)this.failedHandler);
    private final LazyOptional<IItemHandler> endCap = LazyOptional.of(() -> this.endHandler);
    @DescSynced
    @GuiSynced
    private final EtchingFluidTank acidTank = new EtchingFluidTank();
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(() -> this.acidTank);
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private final LazyOptional<IHeatExchangerLogic> heatCap = LazyOptional.of(() -> this.heatExchanger);

    public TileEntityEtchingTank() {
        super((TileEntityType)ModTileEntities.ETCHING_TANK.get());
        this.heatExchanger.setThermalResistance(10.0);
        this.heatExchanger.setThermalCapacity(5.0);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.acidTank.tick();
        if (!this.field_145850_b.field_72995_K && !this.acidTank.getFluid().isEmpty()) {
            int tickInterval = this.getTickInterval();
            if (this.field_145850_b.func_82737_E() % (long)tickInterval == 0L) {
                boolean didWork = false;
                for (int i = 0; i < 25; ++i) {
                    ItemStack stack = this.itemHandler.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    int etchProgress = ItemEmptyPCB.getEtchProgress(stack);
                    if (etchProgress < 100) {
                        ItemEmptyPCB.setEtchProgress(stack, etchProgress + 1);
                        didWork = true;
                        continue;
                    }
                    if (this.isOutputFull() || this.isFailedOutputFull()) continue;
                    int uvProgress = TileEntityUVLightBox.getExposureProgress(stack);
                    boolean success = this.field_145850_b.field_73012_v.nextInt(100) <= uvProgress;
                    this.tryMoveFinishedItem(i, success);
                }
                if (didWork && tickInterval < 30) {
                    if (this.field_145850_b.field_73012_v.nextInt(100) < 30 - tickInterval) {
                        this.acidTank.drain(1, IFluidHandler.FluidAction.EXECUTE);
                    }
                    this.heatExchanger.addHeat(-(30 - tickInterval));
                }
            }
        }
    }

    public int getTickInterval() {
        int delta = MathHelper.func_76125_a((int)(this.heatExchanger.getTemperatureAsInt() - 323), (int)0, (int)480);
        return 30 - (delta + 1) / 20;
    }

    private void tryMoveFinishedItem(int slot, boolean success) {
        ItemStack excess;
        ItemStack stack = this.itemHandler.extractItem(slot, 1, true);
        if (!stack.func_190926_b() && (excess = success ? this.outputHandler.insertItem(0, new ItemStack((IItemProvider)ModItems.UNASSEMBLED_PCB.get()), false) : this.failedHandler.insertItem(0, new ItemStack((IItemProvider)ModItems.FAILED_PCB.get()), false)).func_190926_b()) {
            this.itemHandler.extractItem(slot, 1, false);
        }
    }

    public boolean isOutputFull() {
        ItemStack stack = this.outputHandler.getStackInSlot(0);
        return stack.func_190916_E() >= stack.func_77976_d();
    }

    public boolean isFailedOutputFull() {
        ItemStack stack = this.failedHandler.getStackInSlot(0);
        return stack.func_190916_E() >= stack.func_77976_d();
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.itemHandler;
    }

    @Override
    @Nonnull
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.itemCap;
    }

    public OutputItemHandler getOutputHandler() {
        return this.outputHandler;
    }

    public FailedItemHandler getFailedHandler() {
        return this.failedHandler;
    }

    public IFluidTank getAcidTank() {
        return this.acidTank;
    }

    @Override
    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        return this.heatCap;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.itemCap);
            }
            if (side.func_176740_k() == Direction.Axis.Y) {
                return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.endCap);
            }
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.sideCap);
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.orEmpty(cap, this.fluidCap);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void getContentsToDrop(NonNullList<ItemStack> drops) {
        super.getContentsToDrop(drops);
        PneumaticCraftUtils.collectNonEmptyItems((IItemHandler)this.outputHandler, drops);
        PneumaticCraftUtils.collectNonEmptyItems((IItemHandler)this.failedHandler, drops);
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInv, PlayerEntity player) {
        return new ContainerEtchingTank(windowId, playerInv, this.func_174877_v());
    }

    @Override
    @Nonnull
    public Map<String, PNCFluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"Tank", (Object)this.acidTank);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("Inventory", (INBT)this.itemHandler.serializeNBT());
        tag.func_218657_a("Output", (INBT)this.outputHandler.serializeNBT());
        tag.func_218657_a("Failed", (INBT)this.failedHandler.serializeNBT());
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.itemHandler.deserializeNBT(tag.func_74775_l("Inventory"));
        this.outputHandler.deserializeNBT(tag.func_74775_l("Output"));
        this.failedHandler.deserializeNBT(tag.func_74775_l("Failed"));
    }

    @Override
    public IHeatExchangerLogic getHeatExchanger(Direction dir) {
        return this.heatExchanger;
    }

    private class EtchingFluidTank
    extends SmartSyncTank {
        EtchingFluidTank() {
            super(TileEntityEtchingTank.this, 4000);
        }

        @Override
        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid().func_207185_a(PneumaticCraftTags.Fluids.ETCHING_ACID);
        }
    }

    private class WrappedInvHandler
    implements IItemHandler {
        private final IItemHandler output;

        WrappedInvHandler(IItemHandler output) {
            this.output = output;
        }

        public int getSlots() {
            return 26;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return slot == 0 ? this.output.getStackInSlot(0) : TileEntityEtchingTank.this.itemHandler.getStackInSlot(slot - 1);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return slot == 0 ? stack : TileEntityEtchingTank.this.itemHandler.insertItem(slot - 1, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return slot == 0 ? this.output.extractItem(0, amount, simulate) : ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return slot == 0 ? this.output.getSlotLimit(0) : TileEntityEtchingTank.this.itemHandler.getSlotLimit(slot - 1);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot == 0 ? this.output.isItemValid(0, stack) : TileEntityEtchingTank.this.itemHandler.isItemValid(slot - 1, stack);
        }
    }

    private class FailedItemHandler
    extends BaseItemStackHandler {
        FailedItemHandler() {
            super(TileEntityEtchingTank.this, 1);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_77973_b() == ModItems.FAILED_PCB.get();
        }
    }

    private class OutputItemHandler
    extends BaseItemStackHandler {
        OutputItemHandler() {
            super(TileEntityEtchingTank.this, 1);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_77973_b() == ModItems.UNASSEMBLED_PCB.get();
        }
    }

    private class EtchingTankHandler
    extends BaseItemStackHandler {
        EtchingTankHandler() {
            super(TileEntityEtchingTank.this, 25);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_77973_b() == ModItems.EMPTY_PCB.get() && TileEntityUVLightBox.getExposureProgress(stack) > 0;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    }
}

