/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.Arrays;
import java.util.BitSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.BlockAphorismTile;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import net.minecraft.block.BlockState;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityAphorismTile
extends TileEntityBase {
    public static final String NBT_BORDER_COLOR = "borderColor";
    public static final String NBT_BACKGROUND_COLOR = "backgroundColor";
    private static final String NBT_TEXT_ROTATION = "textRot";
    public static final String NBT_TEXT_LINES = "lines";
    public static final String NBT_MARGIN = "margin";
    private static final String NBT_INVISIBLE = "invisible";
    private static final Pattern ITEM_PAT = Pattern.compile("^\\{item:(\\w+:[a-z0-9_.]+)}$");
    private String[] textLines = new String[]{""};
    private ItemStack[] icons = new ItemStack[]{ItemStack.field_190927_a};
    private BitSet rsLines = new BitSet(1);
    public int textRotation;
    private int borderColor = DyeColor.BLUE.func_196059_a();
    private int backgroundColor = DyeColor.WHITE.func_196059_a();
    private int maxLineWidth = -1;
    private byte marginSize;
    private boolean invisible;
    public int currentRedstonePower = 0;
    private long lastPoll = 0L;
    public int cursorX = -1;
    public int cursorY = -1;

    public TileEntityAphorismTile() {
        super((TileEntityType)ModTileEntities.APHORISM_TILE.get());
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public boolean shouldPreserveStateOnBreak() {
        return true;
    }

    @Override
    public void serializeExtraItemData(CompoundNBT blockEntityTag, boolean preserveState) {
        this.writeToPacket(blockEntityTag);
    }

    @Override
    public void writeToPacket(CompoundNBT tag) {
        super.writeToPacket(tag);
        CompoundNBT subTag = new CompoundNBT();
        subTag.func_218657_a(NBT_TEXT_LINES, (INBT)Arrays.stream(this.textLines).map(StringNBT::func_229705_a_).collect(Collectors.toCollection(ListNBT::new)));
        subTag.func_74768_a(NBT_TEXT_ROTATION, this.textRotation);
        subTag.func_74768_a(NBT_BORDER_COLOR, this.borderColor);
        subTag.func_74768_a(NBT_BACKGROUND_COLOR, this.backgroundColor);
        subTag.func_74774_a(NBT_MARGIN, this.marginSize);
        subTag.func_74757_a(NBT_INVISIBLE, this.invisible);
        tag.func_218657_a("ExtraData", (INBT)subTag);
    }

    @Override
    public void readFromPacket(CompoundNBT tag) {
        super.readFromPacket(tag);
        if (tag.func_74764_b("ExtraData")) {
            CompoundNBT subTag = tag.func_74775_l("ExtraData");
            ListNBT l = subTag.func_150295_c(NBT_TEXT_LINES, 8);
            if (l.isEmpty()) {
                this.textLines = new String[]{""};
            } else {
                this.textLines = new String[l.size()];
                IntStream.range(0, this.textLines.length).forEach(i -> {
                    this.textLines[i] = l.func_150307_f(i);
                });
            }
            this.updateLineMetadata();
            this.textRotation = subTag.func_74762_e(NBT_TEXT_ROTATION);
            if (subTag.func_74764_b(NBT_BORDER_COLOR)) {
                this.borderColor = subTag.func_74762_e(NBT_BORDER_COLOR);
                this.backgroundColor = subTag.func_74762_e(NBT_BACKGROUND_COLOR);
            } else {
                this.borderColor = DyeColor.BLUE.func_196059_a();
                this.backgroundColor = DyeColor.WHITE.func_196059_a();
            }
            this.setMarginSize(subTag.func_74771_c(NBT_MARGIN));
            this.setInvisible(subTag.func_74767_n(NBT_INVISIBLE));
            if (this.field_145850_b != null) {
                this.rerenderTileEntity();
            }
        }
    }

    public String[] getTextLines() {
        return this.textLines;
    }

    public void setTextLines(String[] textLines) {
        this.setTextLines(textLines, true);
    }

    public void setTextLines(String[] textLines, boolean notifyClient) {
        this.textLines = textLines;
        this.maxLineWidth = -1;
        this.icons = new ItemStack[textLines.length];
        if (this.field_145850_b.field_72995_K) {
            this.updateLineMetadata();
        } else if (notifyClient) {
            this.sendDescriptionPacket();
        }
    }

    private void updateLineMetadata() {
        this.icons = new ItemStack[this.textLines.length];
        this.rsLines = new BitSet(this.textLines.length);
        for (int i = 0; i < this.textLines.length; ++i) {
            Matcher m = ITEM_PAT.matcher(this.textLines[i]);
            if (m.matches()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(m.group(1)));
                this.icons[i] = new ItemStack((IItemProvider)item);
                continue;
            }
            this.icons[i] = ItemStack.field_190927_a;
            if (!this.textLines[i].contains("{redstone}")) continue;
            this.rsLines.set(i);
        }
    }

    public ItemStack getIconAt(int line) {
        return line >= 0 && line < this.icons.length ? this.icons[line] : ItemStack.field_190927_a;
    }

    public boolean isRedstoneLine(int line) {
        return line >= 0 && line < this.rsLines.size() && this.rsLines.get(line);
    }

    public void setBorderColor(int color) {
        this.borderColor = color;
        if (!this.field_145850_b.field_72995_K) {
            this.sendDescriptionPacket();
        }
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int color) {
        this.backgroundColor = color;
        if (!this.field_145850_b.field_72995_K) {
            this.sendDescriptionPacket();
        }
    }

    public byte getMarginSize() {
        return this.marginSize;
    }

    public void setMarginSize(byte marginSize) {
        this.marginSize = (byte)MathHelper.func_76125_a((int)marginSize, (int)0, (int)9);
        this.needMaxLineWidthRecalc();
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public void setInvisible(boolean invisible) {
        BlockState state;
        this.invisible = invisible;
        if (this.field_145850_b != null && (state = this.func_195044_w()).func_177230_c() instanceof BlockAphorismTile) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockAphorismTile.INVISIBLE, (Comparable)Boolean.valueOf(invisible)));
        }
    }

    public int getMaxLineWidth(boolean editing) {
        if (this.maxLineWidth < 0) {
            for (int i = 0; i < this.textLines.length; ++i) {
                int stringWidth;
                String line = this.textLines[i];
                if (!editing && this.isRedstoneLine(i)) {
                    line = line.replaceAll(Pattern.quote("{redstone}"), Integer.toString(this.currentRedstonePower));
                }
                int n = stringWidth = !editing && !this.getIconAt(i).func_190926_b() ? 6 : ClientUtils.getStringWidth(line);
                if (stringWidth <= this.maxLineWidth) continue;
                this.maxLineWidth = stringWidth;
            }
            float mul = 1.0f + (float)(this.marginSize + 1) * 0.075f;
            this.maxLineWidth = (int)((float)this.maxLineWidth * mul);
        }
        return this.maxLineWidth;
    }

    public void needMaxLineWidthRecalc() {
        this.maxLineWidth = -1;
    }

    public int pollRedstone() {
        if (this.field_145850_b.func_82737_E() - this.lastPoll >= 2L) {
            Direction d = this.getRotation();
            int p = this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(d), d);
            if (p != this.currentRedstonePower) {
                this.needMaxLineWidthRecalc();
            }
            this.currentRedstonePower = p;
            this.lastPoll = this.field_145850_b.func_82737_E();
        }
        return this.currentRedstonePower;
    }

    public Pair<Integer, Integer> getCursorPos() {
        int cy = this.cursorY >= 0 && this.cursorY < this.textLines.length ? this.cursorY : this.textLines.length - 1;
        int cx = this.cursorX >= 0 && this.cursorX <= this.textLines[cy].length() ? this.cursorX : this.textLines[cy].length();
        return Pair.of((Object)cx, (Object)cy);
    }

    public void setCursorPos(int cursorX, int cursorY) {
        this.cursorX = cursorX;
        this.cursorY = cursorY;
    }
}

