/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.XPFluidManager;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerAerialInterface;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.thirdparty.curios.Curios;
import me.desht.pneumaticcraft.common.thirdparty.curios.CuriosUtils;
import me.desht.pneumaticcraft.common.tileentity.IComparatorSupport;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.ISideConfigurable;
import me.desht.pneumaticcraft.common.tileentity.PneumaticEnergyStorage;
import me.desht.pneumaticcraft.common.tileentity.RedstoneController;
import me.desht.pneumaticcraft.common.tileentity.SideConfigurator;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.EnchantmentUtils;
import me.desht.pneumaticcraft.common.util.GlobalTileEntityCacheManager;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.PlayerArmorInvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.items.wrapper.PlayerOffhandInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;

public class TileEntityAerialInterface
extends TileEntityPneumaticBase
implements IMinWorkingPressure,
IRedstoneControl<TileEntityAerialInterface>,
IComparatorSupport,
ISideConfigurable,
INamedContainerProvider {
    private static final UUID NO_PLAYER = new UUID(0L, 0L);
    private static final int ENERGY_CAPACITY = 100000;
    private static final int RF_PER_TICK = 1000;
    private static final int PLAYER_AIR_MULTIPLIER = 5;
    private static final List<RedstoneController.RedstoneMode<TileEntityAerialInterface>> REDSTONE_MODES = ImmutableList.of(new RedstoneController.EmittingRedstoneMode<TileEntityAerialInterface>("standard.never", new ItemStack((IItemProvider)Items.field_151016_H), te -> false), new RedstoneController.EmittingRedstoneMode<TileEntityAerialInterface>("aerialInterface.playerConnected", new ItemStack((IItemProvider)ModBlocks.AERIAL_INTERFACE.get()), te -> te.isConnectedToPlayer));
    @DescSynced
    private String playerName = "";
    private UUID playerUUID = NO_PLAYER;
    private Fluid curXpFluid = Fluids.field_204541_a;
    private int curXpRatio = 0;
    @GuiSynced
    public int curXPFluidIndex = -1;
    @GuiSynced
    public FeedMode feedMode = FeedMode.FRUGAL;
    private boolean oldRedstoneStatus;
    private boolean needUpdateNeighbours;
    @GuiSynced
    public boolean isConnectedToPlayer = false;
    @GuiSynced
    public boolean dispenserUpgradeInserted;
    @GuiSynced
    private final RedstoneController<TileEntityAerialInterface> rsController = new RedstoneController<TileEntityAerialInterface>(this, REDSTONE_MODES);
    private final SideConfigurator<IItemHandler> itemHandlerSideConfigurator;
    private final PlayerExperienceHandler playerExperienceHandler = new PlayerExperienceHandler();
    private final LazyOptional<IFluidHandler> playerExpCap = LazyOptional.of(() -> this.playerExperienceHandler);
    private final PlayerFoodHandler playerFoodHandler = new PlayerFoodHandler();
    private final LazyOptional<IItemHandler> playerFoodCap = LazyOptional.of(() -> this.playerFoodHandler);
    private final PneumaticEnergyStorage energyStorage = new PneumaticEnergyStorage(100000);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energyStorage);
    private WeakReference<PlayerEntity> playerRef = new WeakReference<Object>(null);
    private final List<Integer> chargeableSlots = new ArrayList<Integer>();
    private final List<PlayerInvHandler> invHandlers = new ArrayList<PlayerInvHandler>();
    public GameProfile gameProfileClient;

    public TileEntityAerialInterface() {
        super((TileEntityType)ModTileEntities.AERIAL_INTERFACE.get(), 20.0f, 25.0f, 4000, 4);
        PlayerMainInvHandler playerMainInvHandler = new PlayerMainInvHandler();
        PlayerArmorInvHandler playerArmorInvHandler = new PlayerArmorInvHandler();
        PlayerOffhandInvHandler playerOffhandInvHandler = new PlayerOffhandInvHandler();
        PlayerEnderInvHandler playerEnderInvHandler = new PlayerEnderInvHandler();
        this.itemHandlerSideConfigurator = new SideConfigurator("items", this);
        this.itemHandlerSideConfigurator.registerHandler("mainInv", new ItemStack((IItemProvider)Blocks.field_150486_ae), (Capability<IItemHandler>)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (NonNullSupplier<IItemHandler>)((NonNullSupplier)() -> playerMainInvHandler), SideConfigurator.RelativeFace.FRONT, SideConfigurator.RelativeFace.BACK, SideConfigurator.RelativeFace.LEFT, SideConfigurator.RelativeFace.RIGHT);
        this.itemHandlerSideConfigurator.registerHandler("armorInv", new ItemStack((IItemProvider)ModItems.PNEUMATIC_CHESTPLATE.get()), (Capability<IItemHandler>)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (NonNullSupplier<IItemHandler>)((NonNullSupplier)() -> playerArmorInvHandler), SideConfigurator.RelativeFace.TOP, SideConfigurator.RelativeFace.BOTTOM);
        this.itemHandlerSideConfigurator.registerHandler("offhandInv", new ItemStack((IItemProvider)Items.field_185159_cQ), (Capability<IItemHandler>)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (NonNullSupplier<IItemHandler>)((NonNullSupplier)() -> playerOffhandInvHandler), new SideConfigurator.RelativeFace[0]);
        this.itemHandlerSideConfigurator.registerHandler("enderInv", new ItemStack((IItemProvider)Blocks.field_150477_bB), (Capability<IItemHandler>)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (NonNullSupplier<IItemHandler>)((NonNullSupplier)() -> playerEnderInvHandler), new SideConfigurator.RelativeFace[0]);
        this.invHandlers.add(playerMainInvHandler);
        this.invHandlers.add(playerArmorInvHandler);
        this.invHandlers.add(playerOffhandInvHandler);
        this.invHandlers.add(playerEnderInvHandler);
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void func_145829_t() {
        super.func_145829_t();
        GlobalTileEntityCacheManager.getInstance().aerialInterfaces.add(this);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        GlobalTileEntityCacheManager.getInstance().aerialInterfaces.remove(this);
        this.itemHandlerSideConfigurator.invalidateCaps();
        this.playerExpCap.invalidate();
        this.playerFoodCap.invalidate();
        this.energyCap.invalidate();
    }

    public void setPlayer(PlayerEntity player) {
        if (player == this.playerRef.get()) {
            return;
        }
        this.invHandlers.forEach(PlayerInvHandler::invalidate);
        this.playerRef = new WeakReference<PlayerEntity>(player);
        boolean wasConnected = this.isConnectedToPlayer;
        if (player == null) {
            this.isConnectedToPlayer = false;
            this.playerName = "";
        } else {
            this.isConnectedToPlayer = true;
            this.playerName = player.func_146103_bH().getName();
            this.scanForChargeableItems(player);
        }
        if (wasConnected != this.isConnectedToPlayer) {
            this.needUpdateNeighbours = true;
            this.func_70296_d();
        }
    }

    public void setPlayerId(UUID uuid) {
        this.playerUUID = uuid;
    }

    @Override
    public void onDescUpdate() {
        super.onDescUpdate();
        this.gameProfileClient = this.playerName.isEmpty() ? null : SkullTileEntity.func_174884_b((GameProfile)new GameProfile(null, this.playerName));
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        boolean wasInserted = this.dispenserUpgradeInserted;
        boolean bl = this.dispenserUpgradeInserted = this.getUpgrades(EnumUpgrade.DISPENSER) > 0;
        if (wasInserted != this.dispenserUpgradeInserted) {
            this.needUpdateNeighbours = true;
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            if (this.needUpdateNeighbours) {
                this.needUpdateNeighbours = false;
                this.updateNeighbours();
            }
            if (this.func_145831_w() instanceof ServerWorld && (this.func_145831_w().func_82737_E() & 0xFL) == 0L) {
                this.setPlayer((PlayerEntity)((ServerWorld)this.func_145831_w()).func_73046_m().func_184103_al().func_177451_a(this.playerUUID));
            }
            this.getPlayer().ifPresent(player -> {
                if (this.hasEnoughPressure()) {
                    this.addAir(-1);
                    if ((this.func_145831_w().func_82737_E() & 0x3FL) == 0L) {
                        this.scanForChargeableItems((PlayerEntity)player);
                    }
                    this.supplyEnergyToPlayer((PlayerEntity)player);
                    this.supplyAirToPlayer((PlayerEntity)player);
                }
            });
            if (this.oldRedstoneStatus != this.rsController.shouldEmit()) {
                this.oldRedstoneStatus = this.rsController.shouldEmit();
                this.needUpdateNeighbours = true;
            }
        }
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayerEntity player) {
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        if (tag.equals("xpType")) {
            ++this.curXPFluidIndex;
            List<Fluid> available = XPFluidManager.getInstance().getAvailableLiquidXPs();
            if (this.curXPFluidIndex >= available.size()) {
                this.curXPFluidIndex = -1;
            }
            this.curXpFluid = this.curXPFluidIndex >= 0 ? available.get(this.curXPFluidIndex) : Fluids.field_204541_a;
            this.curXpRatio = XPFluidManager.getInstance().getXPRatio(this.curXpFluid);
        } else if (tag.startsWith("SideConf") && this.itemHandlerSideConfigurator.handleButtonPress(tag)) {
            this.needUpdateNeighbours = true;
        } else {
            try {
                this.feedMode = FeedMode.valueOf(tag);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.func_70296_d();
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    private Optional<PlayerEntity> getPlayer() {
        PlayerEntity player = (PlayerEntity)this.playerRef.get();
        return player != null && player.func_70089_S() ? Optional.of(player) : Optional.empty();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.dispenserUpgradeInserted) {
                return this.playerFoodCap.cast();
            }
            return this.itemHandlerSideConfigurator.getHandler(side).cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.dispenserUpgradeInserted && this.curXpFluid != Fluids.field_204541_a) {
            return this.playerExpCap.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.playerUUID = UUID.fromString(tag.func_74779_i("playerUUID"));
        this.feedMode = FeedMode.valueOf(tag.func_74779_i("feedMode"));
        this.curXpFluid = tag.func_74764_b("curXpFluid") ? (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(tag.func_74779_i("curXpFluid"))) : Fluids.field_204541_a;
        this.curXpRatio = XPFluidManager.getInstance().getXPRatio(this.curXpFluid);
        this.energyStorage.readFromNBT(tag);
        this.curXPFluidIndex = this.curXpFluid == Fluids.field_204541_a ? -1 : XPFluidManager.getInstance().getAvailableLiquidXPs().indexOf(this.curXpFluid);
        this.dispenserUpgradeInserted = this.getUpgrades(EnumUpgrade.DISPENSER) > 0;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74778_a("playerUUID", this.playerUUID.toString());
        tag.func_74778_a("feedMode", this.feedMode.toString());
        tag.func_74778_a("curXpFluid", this.curXpFluid.getRegistryName().toString());
        this.energyStorage.writeToNBT(tag);
        return tag;
    }

    @Override
    public float getMinWorkingPressure() {
        return 10.0f;
    }

    @Override
    public int getComparatorValue() {
        return this.rsController.shouldEmit() ? 15 : 0;
    }

    private void scanForChargeableItems(PlayerEntity player) {
        if (this.energyStorage.getEnergyStored() == 0) {
            return;
        }
        this.chargeableSlots.clear();
        PlayerInventory inv = player.field_71071_by;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (!inv.func_70301_a(i).getCapability(CapabilityEnergy.ENERGY).isPresent()) continue;
            this.chargeableSlots.add(i);
        }
    }

    private void supplyEnergyToPlayer(PlayerEntity player) {
        if (this.energyStorage.getEnergyStored() > 0) {
            int slot;
            ItemStack stack;
            int energyLeft;
            PlayerInventory inv = player.field_71071_by;
            Iterator<Integer> iterator = this.chargeableSlots.iterator();
            while (iterator.hasNext() && (energyLeft = (stack = inv.func_70301_a(slot = iterator.next().intValue())).getCapability(CapabilityEnergy.ENERGY).map(receivingStorage -> {
                int stored = this.energyStorage.getEnergyStored();
                if (stored > 0) {
                    this.energyStorage.extractEnergy(receivingStorage.receiveEnergy(Math.min(stored, 1000), false), false);
                }
                return this.energyStorage.getEnergyStored();
            }).orElse(this.energyStorage.getEnergyStored()).intValue()) != 0) {
            }
            if (Curios.available && this.energyStorage.getEnergyStored() > 0) {
                CuriosUtils.chargeItems(player, this.energyStorage, 1000);
            }
        }
    }

    private void supplyAirToPlayer(PlayerEntity player) {
        if (player.func_70086_ai() <= 170) {
            int playerAir = 300 - player.func_70086_ai();
            player.func_70050_g(300);
            this.addAir(-playerAir * 5);
            NetworkHandler.sendToPlayer(new PacketPlaySound((SoundEvent)ModSounds.SCUBA.get(), SoundCategory.PLAYERS, player.func_233580_cy_(), 1.0f, 0.9f, false), (ServerPlayerEntity)player);
        }
    }

    @Override
    public List<SideConfigurator<?>> getSideConfigurators() {
        return Collections.singletonList(this.itemHandlerSideConfigurator);
    }

    @Override
    public Direction byIndex() {
        return this.getRotation();
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerAerialInterface(windowId, playerInventory, this.func_174877_v());
    }

    @Override
    public RedstoneController<TileEntityAerialInterface> getRedstoneController() {
        return this.rsController;
    }

    private boolean hasEnoughPressure() {
        return this.getPressure() >= this.getMinWorkingPressure();
    }

    public static enum FeedMode implements ITranslatableEnum
    {
        FRUGAL("frugal", Items.field_151083_be),
        GREEDY("greedy", Items.field_151034_e),
        SMART("smart", Items.field_151153_ao);

        private final String key;
        private final ItemStack stack;

        private FeedMode(String key, Item item) {
            this.key = key;
            this.stack = new ItemStack((IItemProvider)item);
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.tab.info.aerialInterface.feedMode." + this.key;
        }

        public String getDescTranslationKey() {
            return this.getTranslationKey() + ".desc";
        }

        public ItemStack getIconStack() {
            return this.stack;
        }
    }

    private class PlayerExperienceHandler
    implements IFluidHandler {
        private PlayerExperienceHandler() {
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            if (TileEntityAerialInterface.this.curXpFluid != Fluids.field_204541_a) {
                return TileEntityAerialInterface.this.getPlayer().map(p -> new FluidStack(TileEntityAerialInterface.this.curXpFluid, EnchantmentUtils.getPlayerXP(p) * TileEntityAerialInterface.this.curXpRatio)).orElse(FluidStack.EMPTY);
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return TileEntityAerialInterface.this.curXpFluid != Fluids.field_204541_a && stack.getFluid() == TileEntityAerialInterface.this.curXpFluid;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            return TileEntityAerialInterface.this.getPlayer().map(player -> {
                if (TileEntityAerialInterface.this.curXpRatio != 0 && this.canFill(resource.getFluid())) {
                    int pointsAdded = resource.getAmount() / TileEntityAerialInterface.this.curXpRatio;
                    if (doFill.execute()) {
                        player.func_195068_e(pointsAdded);
                    }
                    return pointsAdded * TileEntityAerialInterface.this.curXpRatio;
                }
                return 0;
            }).orElse(0);
        }

        private boolean canFill(Fluid fluid) {
            return TileEntityAerialInterface.this.dispenserUpgradeInserted && fluid != Fluids.field_204541_a && fluid == TileEntityAerialInterface.this.curXpFluid && TileEntityAerialInterface.this.curXpRatio != 0 && TileEntityAerialInterface.this.hasEnoughPressure();
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            return TileEntityAerialInterface.this.getPlayer().map(player -> {
                if (TileEntityAerialInterface.this.curXpRatio != 0 && TileEntityAerialInterface.this.dispenserUpgradeInserted && TileEntityAerialInterface.this.hasEnoughPressure()) {
                    int pointsDrained = Math.min(EnchantmentUtils.getPlayerXP(player), resource.getAmount() / TileEntityAerialInterface.this.curXpRatio);
                    if (doDrain.execute()) {
                        EnchantmentUtils.addPlayerXP(player, -pointsDrained);
                    }
                    return new FluidStack(resource.getFluid(), pointsDrained * TileEntityAerialInterface.this.curXpRatio);
                }
                return FluidStack.EMPTY;
            }).orElse(FluidStack.EMPTY);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            if (TileEntityAerialInterface.this.curXpFluid == Fluids.field_204541_a) {
                return FluidStack.EMPTY;
            }
            return this.drain(new FluidStack(TileEntityAerialInterface.this.curXpFluid, maxDrain), doDrain);
        }
    }

    private class PlayerFoodHandler
    implements IItemHandler {
        private PlayerFoodHandler() {
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!TileEntityAerialInterface.this.hasEnoughPressure()) {
                return stack;
            }
            return TileEntityAerialInterface.this.getPlayer().map(player -> {
                if (this.getFoodValue(stack) <= 0 || !this.okToFeed(stack, (PlayerEntity)player)) {
                    return stack;
                }
                if (simulate) {
                    return ItemStack.field_190927_a;
                }
                int startValue = stack.func_190916_E();
                ItemStack remainingItem = stack;
                ItemStack copy = stack.func_77946_l();
                while (stack.func_190916_E() > 0) {
                    remainingItem = stack.func_77950_b(player.field_70170_p, (LivingEntity)player);
                    if (!((remainingItem = ForgeEventFactory.onItemUseFinish((LivingEntity)player, (ItemStack)stack, (int)0, (ItemStack)remainingItem)).func_190916_E() <= 0 || remainingItem == stack && remainingItem.func_190916_E() == startValue || player.field_71071_by.func_70441_a(remainingItem) || remainingItem.func_190916_E() <= 0)) {
                        player.func_71019_a(remainingItem, false);
                    }
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("pneumaticcraft.gui.aerial_interface.fedItem", new Object[]{copy.func_200301_q()}), true);
                    if (stack.func_190916_E() != startValue) continue;
                }
                return remainingItem.func_190916_E() > 0 ? remainingItem : ItemStack.field_190927_a;
            }).orElse(stack);
        }

        private boolean okToFeed(@Nonnull ItemStack stack, PlayerEntity player) {
            int foodValue = this.getFoodValue(stack);
            int curFoodLevel = player.func_71024_bL().func_75116_a();
            FeedMode effectiveFeedMode = TileEntityAerialInterface.this.feedMode == FeedMode.SMART ? (player.func_110143_aJ() < player.func_110138_aP() ? FeedMode.GREEDY : FeedMode.FRUGAL) : TileEntityAerialInterface.this.feedMode;
            switch (effectiveFeedMode) {
                case FRUGAL: {
                    return 20 - curFoodLevel >= foodValue * stack.func_190916_E();
                }
                case GREEDY: {
                    return 20 - curFoodLevel >= foodValue * (stack.func_190916_E() - 1) + 1;
                }
            }
            return false;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return this.getFoodValue(stack) > 0;
        }

        private int getFoodValue(ItemStack stack) {
            return stack.func_77973_b().func_219971_r() ? stack.func_77973_b().func_219967_s().func_221466_a() : 0;
        }
    }

    private class PlayerEnderInvHandler
    extends PlayerInvHandler {
        private PlayerEnderInvHandler() {
        }

        @Override
        protected IItemHandler getInvWrapper(PlayerEntity player) {
            if (this.cached == null) {
                this.cached = new InvWrapper((IInventory)player.func_71005_bN());
            }
            return this.cached;
        }
    }

    private class PlayerOffhandInvHandler
    extends PlayerInvHandler {
        private PlayerOffhandInvHandler() {
        }

        @Override
        protected IItemHandler getInvWrapper(PlayerEntity player) {
            return this.getCachedHandler(player, PlayerOffhandInvWrapper::new);
        }
    }

    private class PlayerArmorInvHandler
    extends PlayerInvHandler {
        private PlayerArmorInvHandler() {
        }

        @Override
        protected IItemHandler getInvWrapper(PlayerEntity player) {
            return this.getCachedHandler(player, PlayerArmorInvWrapper::new);
        }

        @Override
        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack stack = this.getStackInSlot(slot);
            return EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_190941_k, (ItemStack)stack) > 0 ? ItemStack.field_190927_a : super.extractItem(slot, amount, simulate);
        }
    }

    private class PlayerMainInvHandler
    extends PlayerInvHandler {
        private PlayerMainInvHandler() {
        }

        @Override
        protected IItemHandler getInvWrapper(PlayerEntity player) {
            return this.getCachedHandler(player, PlayerMainInvWrapper::new);
        }
    }

    private abstract class PlayerInvHandler
    implements IItemHandler {
        IItemHandler cached = null;

        private PlayerInvHandler() {
        }

        void invalidate() {
            this.cached = null;
        }

        IItemHandler getCachedHandler(PlayerEntity p, Function<PlayerInventory, IItemHandler> f) {
            if (this.cached == null) {
                this.cached = f.apply(p.field_71071_by);
            }
            return this.cached;
        }

        protected abstract IItemHandler getInvWrapper(@Nonnull PlayerEntity var1);

        public int getSlots() {
            return TileEntityAerialInterface.this.getPlayer().filter(p -> TileEntityAerialInterface.this.hasEnoughPressure()).map(p -> this.getInvWrapper((PlayerEntity)p).getSlots()).orElse(0);
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return TileEntityAerialInterface.this.getPlayer().filter(p -> TileEntityAerialInterface.this.hasEnoughPressure()).map(p -> this.getInvWrapper((PlayerEntity)p).getStackInSlot(slot)).orElse(ItemStack.field_190927_a);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return TileEntityAerialInterface.this.getPlayer().filter(p -> TileEntityAerialInterface.this.hasEnoughPressure()).map(p -> this.getInvWrapper((PlayerEntity)p).insertItem(slot, stack, simulate)).orElse(stack);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return TileEntityAerialInterface.this.getPlayer().filter(p -> TileEntityAerialInterface.this.hasEnoughPressure()).map(p -> this.getInvWrapper((PlayerEntity)p).extractItem(slot, amount, simulate)).orElse(ItemStack.field_190927_a);
        }

        public int getSlotLimit(int slot) {
            return TileEntityAerialInterface.this.getPlayer().filter(p -> TileEntityAerialInterface.this.hasEnoughPressure()).map(p -> this.getInvWrapper((PlayerEntity)p).getSlotLimit(slot)).orElse(1);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return TileEntityAerialInterface.this.hasEnoughPressure();
        }
    }
}

