/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.render.area.AreaRenderManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class RangeManager {
    private final TileEntity te;
    private final int renderColour;
    private int range = 0;
    private boolean showRange = false;
    private AxisAlignedBB extents;
    private Supplier<AxisAlignedBB> extentsGenerator;
    private Set<BlockPos> frame;

    public RangeManager(TileEntity te, int renderColour) {
        this.te = te;
        this.renderColour = renderColour;
        this.extentsGenerator = () -> new AxisAlignedBB(te.func_174877_v(), te.func_174877_v()).func_186662_g((double)this.range);
        this.setRange(1);
    }

    public RangeManager withCustomExtents(Supplier<AxisAlignedBB> generator) {
        this.extentsGenerator = generator;
        return this;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int newRange) {
        if (newRange != this.range) {
            this.range = newRange;
            this.extents = this.extentsGenerator.get();
            Set<Object> set = this.frame = this.te.func_145831_w() != null && this.te.func_145831_w().func_201670_d() ? RangeManager.getFrame(this.extents) : Collections.emptySet();
            if (this.shouldShowRange() && this.te.func_145831_w() != null && this.te.func_145831_w().func_201670_d()) {
                this.toggleShowRange();
                this.toggleShowRange();
            }
        }
    }

    public void toggleShowRange() {
        boolean bl = this.showRange = !this.showRange;
        if (this.te.func_145831_w() != null && this.te.func_145831_w().func_201670_d()) {
            if (this.showRange) {
                AreaRenderManager.getInstance().showArea(this.frame, this.renderColour, this.te, false);
            } else {
                AreaRenderManager.getInstance().removeHandlers(this.te);
            }
        }
    }

    public boolean shouldShowRange() {
        return this.showRange;
    }

    public AxisAlignedBB getExtents() {
        return this.extents;
    }

    public static Set<BlockPos> getFrame(AxisAlignedBB extents) {
        HashSet<BlockPos> res = new HashSet<BlockPos>();
        int minX = (int)extents.field_72340_a;
        int minY = (int)extents.field_72338_b;
        int minZ = (int)extents.field_72339_c;
        int maxX = (int)extents.field_72336_d;
        int maxY = (int)extents.field_72337_e;
        int maxZ = (int)extents.field_72334_f;
        for (int x = minX; x <= maxX; ++x) {
            for (int y = Math.max(0, minY); y <= maxY && y < 256; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (x != minX && x != maxX && y != minY && y != maxY && z != minZ && z != maxZ) continue;
                    res.add(new BlockPos(x, y, z));
                }
            }
        }
        return res;
    }
}

