/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.theoneprobe;

import java.util.ArrayList;
import java.util.function.Function;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.misc.IPneumaticCraftProbeable;
import me.desht.pneumaticcraft.api.semiblock.IDirectionalSemiblock;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.thirdparty.theoneprobe.ElementPressure;
import me.desht.pneumaticcraft.common.thirdparty.theoneprobe.TOPInfoProvider;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TOPInit
implements Function<ITheOneProbe, Void> {
    private static final TextFormatting COLOR = TextFormatting.GRAY;
    static int elementPressure;

    @Override
    public Void apply(ITheOneProbe theOneProbe) {
        Log.info("Enabled support for The One Probe", new Object[0]);
        elementPressure = theOneProbe.registerElementFactory(ElementPressure::new);
        theOneProbe.registerProvider(new IProbeInfoProvider(){

            public String getID() {
                return "pneumaticcraft:default";
            }

            public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
                if (blockState.func_177230_c() instanceof IPneumaticCraftProbeable || blockState.func_235714_a_(PneumaticCraftTags.Blocks.PROBE_TARGET)) {
                    TOPInfoProvider.handleBlock(mode, probeInfo, player, world, blockState, data);
                }
                SemiblockTracker.getInstance().getAllSemiblocks(world, data.getPos(), data.getSideHit()).filter(sb -> !(sb instanceof IDirectionalSemiblock) || ((IDirectionalSemiblock)((Object)sb)).getSide() == data.getSideHit()).forEach(sb -> TOPInfoProvider.handleSemiblock(player, mode, probeInfo, sb));
            }
        });
        theOneProbe.registerEntityProvider(new IProbeInfoEntityProvider(){

            public String getID() {
                return "pneumaticcraft:entity";
            }

            public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, Entity entity, IProbeHitEntityData data) {
                if (entity instanceof ISemiBlock) {
                    ArrayList<ITextComponent> tip = new ArrayList<ITextComponent>();
                    CompoundNBT tag = ((ISemiBlock)entity).serializeNBT(new CompoundNBT());
                    ((ISemiBlock)entity).addTooltip(tip, player, tag, player.func_225608_bj_());
                    tip.forEach(arg_0 -> ((IProbeInfo)probeInfo).text(arg_0));
                    BlockPos pos = ((ISemiBlock)entity).getBlockPos();
                    BlockState state = world.func_180495_p(pos);
                    if (!state.isAir((IBlockReader)world, pos)) {
                        IProbeInfo h2 = probeInfo.horizontal();
                        h2.item(new ItemStack((IItemProvider)state.func_177230_c()));
                        IProbeInfo v = h2.vertical();
                        TranslationTextComponent text = new TranslationTextComponent(state.func_177230_c().func_149739_a());
                        v.text((ITextComponent)text.func_230532_e_().func_240699_a_(TextFormatting.YELLOW));
                        v.text((ITextComponent)new StringTextComponent(TextFormatting.BLUE.toString() + TextFormatting.ITALIC + ModNameCache.getModName(state.func_177230_c())));
                    }
                }
                entity.getCapability(PNCCapabilities.AIR_HANDLER_CAPABILITY).ifPresent(h -> {
                    String p = PneumaticCraftUtils.roundNumberTo(h.getPressure(), 1);
                    probeInfo.text((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.pressure", p).func_240699_a_(COLOR));
                });
                entity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(h -> TOPInfoProvider.handleFluidTanks(mode, probeInfo, h));
            }
        });
        return null;
    }
}

