/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.patchouli;

import me.desht.pneumaticcraft.api.crafting.recipe.AssemblyRecipe;
import me.desht.pneumaticcraft.common.item.ItemAssemblyProgram;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.thirdparty.patchouli.Patchouli;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ProcessorAssemblySystem
implements IComponentProcessor {
    private AssemblyRecipe recipe = null;

    public void setup(IVariableProvider iVariableProvider) {
        ResourceLocation recipeId = new ResourceLocation(iVariableProvider.get("recipe").asString());
        this.recipe = PneumaticCraftRecipeType.ASSEMBLY_DRILL_LASER.getRecipe((World)Minecraft.func_71410_x().field_71441_e, recipeId);
        if (this.recipe == null) {
            this.recipe = PneumaticCraftRecipeType.ASSEMBLY_DRILL.getRecipe((World)Minecraft.func_71410_x().field_71441_e, recipeId);
            if (this.recipe == null) {
                this.recipe = PneumaticCraftRecipeType.ASSEMBLY_LASER.getRecipe((World)Minecraft.func_71410_x().field_71441_e, recipeId);
            }
        }
    }

    public IVariable process(String key) {
        if (this.recipe == null) {
            return null;
        }
        ItemStack programStack = new ItemStack((IItemProvider)ItemAssemblyProgram.fromProgramType(this.recipe.getProgramType()));
        switch (key) {
            case "input": {
                return Patchouli.Util.getStacks(this.recipe.getInput());
            }
            case "output": {
                return IVariable.from((Object)this.recipe.getOutput());
            }
            case "program": {
                return IVariable.from((Object)programStack);
            }
            case "name": {
                return IVariable.wrap((String)this.recipe.getOutput().func_200301_q().getString());
            }
            case "desc": {
                return IVariable.wrap((String)PneumaticCraftUtils.xlate("pneumaticcraft.patchouli.processor.assembly.desc", this.recipe.getOutput().func_200301_q(), programStack.func_200301_q()).getString());
            }
        }
        return null;
    }
}

