/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.patchouli;

import java.util.Arrays;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.common.block.BlockPressureChamberInterface;
import me.desht.pneumaticcraft.common.block.BlockPressureChamberValve;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.thirdparty.IDocsProvider;
import me.desht.pneumaticcraft.common.thirdparty.IThirdParty;
import me.desht.pneumaticcraft.common.thirdparty.ThirdPartyManager;
import me.desht.pneumaticcraft.common.thirdparty.patchouli.FluidStackVariableSerializer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.config.ModConfig;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableSerializer;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.api.VariableHelper;

public class Patchouli
implements IThirdParty,
IDocsProvider {
    private static final ResourceLocation PNC_BOOK = PneumaticRegistry.RL("book");
    private static Screen prevGui;

    @Override
    public void clientInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        PatchouliAPI.IPatchouliAPI papi = PatchouliAPI.get();
        this.setConfigFlags(papi);
        IStateMatcher edge = papi.predicateMatcher((Block)ModBlocks.PRESSURE_CHAMBER_WALL.get(), this::validEdge);
        IStateMatcher wall = papi.predicateMatcher((Block)ModBlocks.PRESSURE_CHAMBER_WALL.get(), this::validFace);
        IStateMatcher glass = papi.predicateMatcher((Block)ModBlocks.PRESSURE_CHAMBER_GLASS.get(), this::validFace);
        IStateMatcher valve = papi.predicateMatcher((BlockState)((BlockPressureChamberValve)ModBlocks.PRESSURE_CHAMBER_VALVE.get()).func_176223_P().func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.NORTH), this::validFace);
        IStateMatcher valveUp = papi.predicateMatcher((BlockState)((BlockPressureChamberValve)ModBlocks.PRESSURE_CHAMBER_VALVE.get()).func_176223_P().func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.UP), this::validFace);
        IStateMatcher intI = papi.predicateMatcher((BlockState)((BlockPressureChamberInterface)ModBlocks.PRESSURE_CHAMBER_INTERFACE.get()).func_176223_P().func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.EAST), this::validFace);
        IStateMatcher intO = papi.predicateMatcher((BlockState)((BlockPressureChamberInterface)ModBlocks.PRESSURE_CHAMBER_INTERFACE.get()).func_176223_P().func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.WEST), this::validFace);
        IMultiblock pc3 = papi.makeMultiblock((String[][])new String[][]{{"WWW", "WWW", "WWW"}, {"WIW", "VAF", "WIW"}, {"WWW", "W0W", "WWW"}}, new Object[]{Character.valueOf('W'), edge, Character.valueOf('F'), glass, Character.valueOf('0'), wall, Character.valueOf('V'), valve, Character.valueOf('I'), intI, Character.valueOf('O'), intO, Character.valueOf('A'), papi.airMatcher()}).setSymmetrical(true);
        papi.registerMultiblock(PneumaticRegistry.RL("pressure_chamber_3"), pc3);
        IMultiblock pc4 = papi.makeMultiblock((String[][])new String[][]{{"WWWW", "WWWW", "WWWW", "WWWW"}, {"WFFW", "VAAF", "FAAF", "WFFW"}, {"WFFW", "VAAF", "FAAF", "WIOW"}, {"WWWW", "W0WW", "WWWW", "WWWW"}}, new Object[]{Character.valueOf('W'), edge, Character.valueOf('F'), glass, Character.valueOf('0'), wall, Character.valueOf('V'), valve, Character.valueOf('I'), intI, Character.valueOf('O'), intO, Character.valueOf('A'), papi.airMatcher()}).setSymmetrical(false);
        papi.registerMultiblock(PneumaticRegistry.RL("pressure_chamber_4"), pc4);
        IMultiblock pc5 = papi.makeMultiblock((String[][])new String[][]{{"WWWWW", "WWVWW", "WVWVW", "WWVWW", "WWWWW"}, {"WFFFW", "FAAAF", "FAAAF", "FAAAF", "WOFIW"}, {"WFFFW", "FAAAF", "FAAAF", "FAAAF", "WFFFW"}, {"WFFFW", "FAAAF", "FAAAF", "FAAAF", "WOFIW"}, {"WWWWW", "WWWWW", "WW0WW", "WWWWW", "WWWWW"}}, new Object[]{Character.valueOf('W'), edge, Character.valueOf('F'), glass, Character.valueOf('0'), wall, Character.valueOf('V'), valveUp, Character.valueOf('I'), intI, Character.valueOf('O'), intO, Character.valueOf('A'), papi.airMatcher()}).setSymmetrical(true);
        papi.registerMultiblock(PneumaticRegistry.RL("pressure_chamber_5"), pc5);
        VariableHelper.instance().registerSerializer((IVariableSerializer)new FluidStackVariableSerializer(), FluidStack.class);
    }

    private boolean validEdge(BlockState state) {
        return state.func_177230_c() == ModBlocks.PRESSURE_CHAMBER_WALL.get() || state.func_177230_c() == ModBlocks.PRESSURE_CHAMBER_GLASS.get();
    }

    private boolean validFace(BlockState state) {
        return state.func_177230_c() == ModBlocks.PRESSURE_CHAMBER_WALL.get() || state.func_177230_c() == ModBlocks.PRESSURE_CHAMBER_GLASS.get() || state.func_177230_c() == ModBlocks.PRESSURE_CHAMBER_INTERFACE.get() || state.func_177230_c() == ModBlocks.PRESSURE_CHAMBER_VALVE.get();
    }

    private void setConfigFlags(PatchouliAPI.IPatchouliAPI papi) {
        papi.setConfigFlag("pneumaticcraft:inWorldPlasticSolidification", ((Boolean)ConfigHelper.common().recipes.inWorldPlasticSolidification.get()).booleanValue());
        papi.setConfigFlag("pneumaticcraft:inWorldYeastCrafting", ((Boolean)ConfigHelper.common().recipes.inWorldYeastCrafting.get()).booleanValue());
        papi.setConfigFlag("pneumaticcraft:liquidHopperDispenser", ((Boolean)ConfigHelper.common().machines.liquidHopperDispenser.get()).booleanValue());
        papi.setConfigFlag("pneumaticcraft:omniHopperDispenser", ((Boolean)ConfigHelper.common().machines.omniHopperDispenser.get()).booleanValue());
        papi.setConfigFlag("pneumaticcraft:electricCompressorEnabled", false);
        papi.setConfigFlag("pneumaticcraft:pneumaticGeneratorEnabled", false);
    }

    @SubscribeEvent
    public void onConfigChange(ModConfig.Reloading event) {
        if (event.getConfig().getModId().equals("pneumaticcraft")) {
            this.setConfigFlags(PatchouliAPI.get());
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (prevGui != null) {
            event.setGui(prevGui);
            prevGui = null;
        }
    }

    @Override
    public void showWidgetDocs(String path) {
        Screen prev = Minecraft.func_71410_x().field_71462_r;
        PatchouliAPI.get().openBookEntry(PNC_BOOK, PneumaticRegistry.RL("programming/" + path), 1);
        if (PNC_BOOK.equals((Object)PatchouliAPI.get().getOpenBookGui())) {
            prevGui = prev;
        }
    }

    @Override
    public boolean isInstalled() {
        return true;
    }

    @Override
    public ThirdPartyManager.ModType modType() {
        return ThirdPartyManager.ModType.DOCUMENTATION;
    }

    static class Util {
        Util() {
        }

        static IVariable getStacks(Ingredient ingr) {
            return IVariable.wrapList((Iterable)Arrays.stream(ingr.func_193365_a()).map(IVariable::from).collect(Collectors.toList()));
        }

        public static IVariable getFluidStacks(FluidIngredient ingr) {
            return IVariable.wrapList((Iterable)ingr.getFluidStacks().stream().map(IVariable::from).collect(Collectors.toList()));
        }
    }
}

