/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.mekanism;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.thirdparty.mekanism.MekanismIntegration;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import mekanism.api.radiation.capability.IRadiationShielding;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class MekRadShieldProvider
implements ICapabilityProvider {
    private final IRadiationShielding impl;
    private final LazyOptional<IRadiationShielding> lazy;

    public MekRadShieldProvider(ItemStack stack, EquipmentSlotType slot) {
        this.impl = new PneumaticArmorRadiationShield(stack, slot);
        this.lazy = LazyOptional.of(() -> this.impl);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return MekanismIntegration.CAPABILITY_RADIATION_SHIELDING.orEmpty(cap, this.lazy);
    }

    public static class PneumaticArmorRadiationShield
    implements IRadiationShielding {
        private final ItemStack stack;
        private final EquipmentSlotType slot;

        public PneumaticArmorRadiationShield(ItemStack stack, EquipmentSlotType slot) {
            this.stack = stack;
            this.slot = slot;
        }

        public double getRadiationShielding() {
            boolean upgrade;
            boolean bl = upgrade = UpgradableItemUtils.getUpgrades(this.stack, EnumUpgrade.RADIATION_SHIELDING) > 0;
            if (!upgrade) {
                return 0.0;
            }
            switch (this.slot) {
                case HEAD: {
                    return 0.25;
                }
                case CHEST: {
                    return 0.4;
                }
                case LEGS: {
                    return 0.2;
                }
                case FEET: {
                    return 0.15;
                }
            }
            return 0.0;
        }
    }
}

