/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.gui.GuiAmadronAddTrade;
import me.desht.pneumaticcraft.client.gui.GuiAssemblyController;
import me.desht.pneumaticcraft.client.gui.GuiFluidMixer;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.GuiPressureChamber;
import me.desht.pneumaticcraft.client.gui.GuiRefineryController;
import me.desht.pneumaticcraft.client.gui.GuiThermopneumaticProcessingPlant;
import me.desht.pneumaticcraft.client.gui.programmer.GuiProgWidgetItemFilter;
import me.desht.pneumaticcraft.client.gui.semiblock.GuiLogisticsBase;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.ICustomTooltipName;
import me.desht.pneumaticcraft.common.item.ItemPressurizable;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.thirdparty.jei.CustomRecipeClickArea;
import me.desht.pneumaticcraft.common.thirdparty.jei.GuiTabHandler;
import me.desht.pneumaticcraft.common.thirdparty.jei.Helpers;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIAmadronTradeCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIAssemblyControllerCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIBlockHeatPropertiesCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIEtchingTankCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIExplosionCraftingCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIFluidMixerCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIHeatFrameCoolingCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIMemoryEssenceCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIPlasticSolidifyingCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIPressureChamberRecipeCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIRefineryCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEISpawnerExtractionCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIThermopneumaticProcessingPlantCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIUVLightBoxCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIYeastCraftingCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.ModCategoryUid;
import me.desht.pneumaticcraft.common.thirdparty.jei.ghost.AmadronAddTradeGhost;
import me.desht.pneumaticcraft.common.thirdparty.jei.ghost.LogisticsFilterGhost;
import me.desht.pneumaticcraft.common.thirdparty.jei.ghost.ProgWidgetItemFilterGhost;
import me.desht.pneumaticcraft.common.tileentity.TileEntityUVLightBox;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;
import org.apache.commons.lang3.StringUtils;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    static IJeiHelpers jeiHelpers;
    static IRecipeManager recipeManager;
    static IRecipesGui recipesGui;

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        for (RegistryObject item : ModItems.ITEMS.getEntries()) {
            if (!(item.get() instanceof ItemPressurizable)) continue;
            registration.registerSubtypeInterpreter((Item)item.get(), (s, ctx) -> s.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(h2 -> String.valueOf(h2.getPressure())).orElse(""));
        }
        registration.registerSubtypeInterpreter((Item)ModItems.EMPTY_PCB.get(), (s, ctx) -> String.valueOf(TileEntityUVLightBox.getExposureProgress(s)));
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        jeiHelpers = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{new JEIPressureChamberRecipeCategory(), new JEIAssemblyControllerCategory(), new JEIThermopneumaticProcessingPlantCategory(), new JEIRefineryCategory(), new JEIFluidMixerCategory(), new JEIUVLightBoxCategory(), new JEIAmadronTradeCategory(), new JEIHeatFrameCoolingCategory(), new JEIEtchingTankCategory(), new JEISpawnerExtractionCategory(), new JEIBlockHeatPropertiesCategory(), new JEIMemoryEssenceCategory()});
        if (((Boolean)ConfigHelper.common().recipes.explosionCrafting.get()).booleanValue()) {
            registry.addRecipeCategories(new IRecipeCategory[]{new JEIExplosionCraftingCategory()});
        }
        if (((Boolean)ConfigHelper.common().recipes.inWorldPlasticSolidification.get()).booleanValue()) {
            registry.addRecipeCategories(new IRecipeCategory[]{new JEIPlasticSolidifyingCategory()});
        }
        if (((Boolean)ConfigHelper.common().recipes.inWorldYeastCrafting.get()).booleanValue()) {
            registry.addRecipeCategories(new IRecipeCategory[]{new JEIYeastCraftingCategory()});
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.addRecipeType(registration, PneumaticCraftRecipeType.PRESSURE_CHAMBER, ModCategoryUid.PRESSURE_CHAMBER);
        this.addRecipeType(registration, PneumaticCraftRecipeType.HEAT_FRAME_COOLING, ModCategoryUid.HEAT_FRAME_COOLING);
        this.addRecipeType(registration, PneumaticCraftRecipeType.REFINERY, ModCategoryUid.REFINERY);
        this.addRecipeType(registration, PneumaticCraftRecipeType.THERMO_PLANT, ModCategoryUid.THERMO_PLANT);
        this.addRecipeType(registration, PneumaticCraftRecipeType.ASSEMBLY_LASER, ModCategoryUid.ASSEMBLY_CONTROLLER);
        this.addRecipeType(registration, PneumaticCraftRecipeType.ASSEMBLY_DRILL, ModCategoryUid.ASSEMBLY_CONTROLLER);
        this.addRecipeType(registration, PneumaticCraftRecipeType.ASSEMBLY_DRILL_LASER, ModCategoryUid.ASSEMBLY_CONTROLLER);
        this.addRecipeType(registration, PneumaticCraftRecipeType.AMADRON_OFFERS, ModCategoryUid.AMADRON_TRADE);
        this.addRecipeType(registration, PneumaticCraftRecipeType.FLUID_MIXER, ModCategoryUid.FLUID_MIXER);
        if (((Boolean)ConfigHelper.common().recipes.explosionCrafting.get()).booleanValue()) {
            this.addRecipeType(registration, PneumaticCraftRecipeType.EXPLOSION_CRAFTING, ModCategoryUid.EXPLOSION_CRAFTING);
        }
        registration.addRecipes(JEIUVLightBoxCategory.getAllRecipes(), ModCategoryUid.UV_LIGHT_BOX);
        registration.addRecipes(JEIEtchingTankCategory.getAllRecipes(), ModCategoryUid.ETCHING_TANK);
        registration.addRecipes(JEISpawnerExtractionCategory.getAllRecipes(), ModCategoryUid.SPAWNER_EXTRACTION);
        registration.addRecipes(JEIMemoryEssenceCategory.getAllRecipes(), ModCategoryUid.MEMORY_ESSENCE);
        if (((Boolean)ConfigHelper.common().recipes.inWorldPlasticSolidification.get()).booleanValue()) {
            registration.addRecipes(JEIPlasticSolidifyingCategory.getAllRecipes(), ModCategoryUid.PLASTIC_SOLIDIFYING);
        }
        if (((Boolean)ConfigHelper.common().recipes.inWorldYeastCrafting.get()).booleanValue()) {
            registration.addRecipes(JEIYeastCraftingCategory.getAllRecipes(), ModCategoryUid.YEAST_CRAFTING);
        }
        registration.addRecipes(JEIBlockHeatPropertiesCategory.getAllRecipes(), ModCategoryUid.HEAT_PROPERTIES);
        for (RegistryObject item : ModItems.ITEMS.getEntries()) {
            this.addStackInfo(registration, new ItemStack((IItemProvider)item.get()));
        }
    }

    private void addRecipeType(IRecipeRegistration registration, PneumaticCraftRecipeType<?> type, ResourceLocation id) {
        registration.addRecipes(type.getRecipes((World)Minecraft.func_71410_x().field_71441_e).values(), id);
    }

    private void addStackInfo(IRecipeRegistration registry, ItemStack stack) {
        String k = ICustomTooltipName.getTranslationKey(stack, false);
        if (I18n.func_188566_a((String)k)) {
            for (String s : StringUtils.splitByWholeSeparator((String)I18n.func_135052_a((String)k, (Object[])new Object[0]), (String)"${br}")) {
                registry.addIngredientInfo((Object)stack, VanillaTypes.ITEM, new ITextComponent[]{new StringTextComponent(s)});
            }
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.AMADRON_TABLET.get()), new ResourceLocation[]{ModCategoryUid.AMADRON_TRADE});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.ASSEMBLY_CONTROLLER.get()), new ResourceLocation[]{ModCategoryUid.ASSEMBLY_CONTROLLER});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.PRESSURE_CHAMBER_WALL.get()), new ResourceLocation[]{ModCategoryUid.PRESSURE_CHAMBER});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.PRESSURE_CHAMBER_VALVE.get()), new ResourceLocation[]{ModCategoryUid.PRESSURE_CHAMBER});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.PRESSURE_CHAMBER_INTERFACE.get()), new ResourceLocation[]{ModCategoryUid.PRESSURE_CHAMBER});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.PRESSURE_CHAMBER_GLASS.get()), new ResourceLocation[]{ModCategoryUid.PRESSURE_CHAMBER});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.REFINERY.get()), new ResourceLocation[]{ModCategoryUid.REFINERY});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.REFINERY_OUTPUT.get()), new ResourceLocation[]{ModCategoryUid.REFINERY});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.THERMOPNEUMATIC_PROCESSING_PLANT.get()), new ResourceLocation[]{ModCategoryUid.THERMO_PLANT});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.UV_LIGHT_BOX.get()), new ResourceLocation[]{ModCategoryUid.UV_LIGHT_BOX});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.HEAT_FRAME.get()), new ResourceLocation[]{ModCategoryUid.HEAT_FRAME_COOLING});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.ETCHING_TANK.get()), new ResourceLocation[]{ModCategoryUid.ETCHING_TANK});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.FLUID_MIXER.get()), new ResourceLocation[]{ModCategoryUid.FLUID_MIXER});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.SPAWNER_EXTRACTOR.get()), new ResourceLocation[]{ModCategoryUid.SPAWNER_EXTRACTION});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.HEAT_PIPE.get()), new ResourceLocation[]{ModCategoryUid.HEAT_PROPERTIES});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.MEMORY_ESSENCE_BUCKET.get()), new ResourceLocation[]{ModCategoryUid.MEMORY_ESSENCE});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(GuiAssemblyController.class, 110, 10, 50, 50, new ResourceLocation[]{ModCategoryUid.ASSEMBLY_CONTROLLER});
        registration.addRecipeClickArea(GuiPressureChamber.class, 100, 7, 60, 60, new ResourceLocation[]{ModCategoryUid.PRESSURE_CHAMBER});
        CustomRecipeClickArea.add(registration, GuiRefineryController.class, 47, 33, 27, 47, ModCategoryUid.REFINERY);
        CustomRecipeClickArea.add(registration, GuiThermopneumaticProcessingPlant.class, 30, 36, 48, 30, ModCategoryUid.THERMO_PLANT);
        CustomRecipeClickArea.add(registration, GuiFluidMixer.class, 50, 40, 47, 24, ModCategoryUid.FLUID_MIXER);
        registration.addGenericGuiContainerHandler(GuiPneumaticContainerBase.class, (IGuiContainerHandler)new GuiTabHandler());
        registration.addGuiScreenHandler(GuiProgWidgetItemFilter.class, Helpers::getGuiProperties);
        registration.addGhostIngredientHandler(GuiAmadronAddTrade.class, (IGhostIngredientHandler)new AmadronAddTradeGhost());
        registration.addGhostIngredientHandler(GuiLogisticsBase.class, new LogisticsFilterGhost());
        registration.addGhostIngredientHandler(GuiProgWidgetItemFilter.class, (IGhostIngredientHandler)new ProgWidgetItemFilterGhost());
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        recipeManager = jeiRuntime.getRecipeManager();
        recipesGui = jeiRuntime.getRecipesGui();
    }

    public ResourceLocation getPluginUid() {
        return PneumaticRegistry.RL("default");
    }
}

