/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.crafting.recipe.HeatPropertiesRecipe;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.heat.BlockHeatProperties;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.thirdparty.jei.AbstractPNCCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIPlugin;
import me.desht.pneumaticcraft.common.thirdparty.jei.ModCategoryUid;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class JEIBlockHeatPropertiesCategory
extends AbstractPNCCategory<HeatPropertiesRecipe> {
    private final IDrawable hotArea = JEIBlockHeatPropertiesCategory.guiHelper().createDrawable(Textures.GUI_JEI_HEAT_PROPERTIES, 150, 0, 31, 18);
    private final IDrawable coldArea = JEIBlockHeatPropertiesCategory.guiHelper().createDrawable(Textures.GUI_JEI_HEAT_PROPERTIES, 150, 18, 31, 18);
    private final IDrawable air = JEIBlockHeatPropertiesCategory.guiHelper().createDrawable(Textures.GUI_JEI_HEAT_PROPERTIES, 150, 36, 16, 16);
    private static final Rectangle2d INPUT_AREA = new Rectangle2d(65, 44, 18, 18);
    private static final Rectangle2d COLD_AREA = new Rectangle2d(5, 44, 18, 18);
    private static final Rectangle2d HOT_AREA = new Rectangle2d(125, 44, 18, 18);
    private static final Rectangle2d[] OUTPUT_AREAS = new Rectangle2d[]{COLD_AREA, HOT_AREA};

    public JEIBlockHeatPropertiesCategory() {
        super(ModCategoryUid.HEAT_PROPERTIES, HeatPropertiesRecipe.class, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.jei.title.heatProperties", new Object[0]), (IDrawable)JEIBlockHeatPropertiesCategory.guiHelper().createDrawable(Textures.GUI_JEI_HEAT_PROPERTIES, 0, 0, 146, 73), (IDrawable)JEIBlockHeatPropertiesCategory.guiHelper().drawableBuilder(Textures.JEI_THERMOMETER, 0, 0, 16, 16).setTextureSize(16, 16).build());
    }

    public static Collection<HeatPropertiesRecipe> getAllRecipes() {
        return (Collection)BlockHeatProperties.getInstance().getAllEntries((World)Minecraft.func_71410_x().field_71441_e).stream().filter(r -> r.getBlock() instanceof FlowingFluidBlock || !new ItemStack((IItemProvider)r.getBlock()).func_190926_b()).sorted(Comparator.comparingInt(HeatPropertiesRecipe::getTemperature).thenComparing(o -> o.getInputDisplayName().getString())).collect(ImmutableList.toImmutableList());
    }

    public void setIngredients(HeatPropertiesRecipe recipe, IIngredients ingredients) {
        this.setInputIngredient(recipe.getBlock(), ingredients);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        this.collectOutputs(recipe.getTransformCold(), items, fluids);
        this.collectOutputs(recipe.getTransformHot(), items, fluids);
        ingredients.setOutputLists(VanillaTypes.ITEM, items.stream().map(Collections::singletonList).collect(Collectors.toList()));
        ingredients.setOutputLists(VanillaTypes.FLUID, fluids.stream().map(Collections::singletonList).collect(Collectors.toList()));
    }

    private void collectOutputs(BlockState state, List<ItemStack> items, List<FluidStack> fluids) {
        if (state != null) {
            if (state.func_177230_c() instanceof FlowingFluidBlock) {
                int level;
                int n = level = state.func_235901_b_((Property)FlowingFluidBlock.field_176367_b) ? (Integer)state.func_177229_b((Property)FlowingFluidBlock.field_176367_b) : 15;
                if (level == 0) {
                    level = 15;
                }
                FluidStack stack = new FluidStack((Fluid)((FlowingFluidBlock)state.func_177230_c()).getFluid(), 1000 * level / 15);
                fluids.add(stack);
                items.add(new ItemStack((IItemProvider)Blocks.field_180401_cv));
            } else {
                ItemStack stack = new ItemStack((IItemProvider)state.func_177230_c());
                items.add(stack.func_190926_b() ? new ItemStack((IItemProvider)Blocks.field_180401_cv) : stack);
                fluids.add(FluidStack.EMPTY);
            }
        } else {
            items.add(new ItemStack((IItemProvider)Blocks.field_180401_cv));
            fluids.add(FluidStack.EMPTY);
        }
    }

    private void setInputIngredient(Block block, IIngredients ingredients) {
        if (block instanceof FlowingFluidBlock) {
            FluidStack stack = new FluidStack((Fluid)((FlowingFluidBlock)block).getFluid(), 1000);
            ingredients.setInput(VanillaTypes.FLUID, (Object)stack);
        } else {
            ingredients.setInput(VanillaTypes.ITEM, (Object)new ItemStack((IItemProvider)block));
        }
    }

    public void setRecipe(IRecipeLayout layout, HeatPropertiesRecipe recipe, IIngredients ingredients) {
        List in = ingredients.getInputs(VanillaTypes.FLUID);
        if (!in.isEmpty()) {
            layout.getFluidStacks().init(0, true, INPUT_AREA.func_199318_a() + 2, INPUT_AREA.func_199319_b() - 1);
            layout.getFluidStacks().set(0, (List)in.get(0));
        }
        List out = ingredients.getOutputs(VanillaTypes.FLUID);
        for (int idx = 0; idx < out.size(); ++idx) {
            if (((List)out.get(idx)).isEmpty() || ((FluidStack)((List)out.get(idx)).get(0)).isEmpty()) continue;
            layout.getFluidStacks().init(idx, false, OUTPUT_AREAS[idx].func_199318_a() + 2, OUTPUT_AREAS[idx].func_199319_b() - 1);
            layout.getFluidStacks().set(idx, (FluidStack)((List)out.get(idx)).get(0));
        }
    }

    public void draw(HeatPropertiesRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.getClass();
        int h = 9;
        ITextComponent desc = recipe.getDescriptionKey().isEmpty() ? StringTextComponent.field_240750_d_ : new StringTextComponent(" (" + I18n.func_135052_a((String)recipe.getDescriptionKey(), (Object[])new Object[0]) + ")");
        fontRenderer.func_243248_b(matrixStack, (ITextComponent)recipe.getInputDisplayName().func_230532_e_().func_230529_a_(desc), 0.0f, 0.0f, 0x4040A0);
        IFormattableTextComponent temp = PneumaticCraftUtils.xlate("pneumaticcraft.waila.temperature", new Object[0]).func_230529_a_((ITextComponent)new StringTextComponent(recipe.getTemperature() - 273 + "\u00b0C"));
        fontRenderer.func_243248_b(matrixStack, (ITextComponent)temp, 0.0f, (float)(h * 2), 0x404040);
        String res = NumberFormat.getNumberInstance(Locale.getDefault()).format(recipe.getThermalResistance());
        fontRenderer.func_238421_b_(matrixStack, I18n.func_135052_a((String)"pneumaticcraft.gui.jei.thermalResistance", (Object[])new Object[0]) + res, 0.0f, (float)(h * 3), 0x404040);
        boolean showCapacity = false;
        if (recipe.getTransformCold() != null) {
            this.coldArea.draw(matrixStack, INPUT_AREA.func_199318_a() - this.coldArea.getWidth() - 5, 42);
            showCapacity = true;
        }
        if (recipe.getTransformHot() != null) {
            this.hotArea.draw(matrixStack, HOT_AREA.func_199318_a() - this.hotArea.getWidth() - 5, 42);
            showCapacity = true;
        }
        this.renderBlock(recipe.getBlockState(), matrixStack, INPUT_AREA.func_199318_a() + 9, INPUT_AREA.func_199319_b() + 1);
        this.renderBlock(recipe.getTransformCold(), matrixStack, COLD_AREA.func_199318_a() + 9, COLD_AREA.func_199319_b() + 1);
        this.renderBlock(recipe.getTransformHot(), matrixStack, HOT_AREA.func_199318_a() + 9, HOT_AREA.func_199319_b() + 1);
        if (showCapacity) {
            fontRenderer.func_243248_b(matrixStack, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.jei.heatCapacity", NumberFormat.getNumberInstance(Locale.getDefault()).format(recipe.getHeatCapacity())), 0.0f, (float)(this.getBackground().getHeight() - h), 0x404040);
        }
    }

    public boolean handleClick(HeatPropertiesRecipe recipe, double mouseX, double mouseY, int mouseButton) {
        IFocus<?> focus = null;
        if (INPUT_AREA.func_199315_b((int)mouseX, (int)mouseY)) {
            focus = this.makeFocus(recipe.getBlock(), mouseButton == 0 ? IFocus.Mode.OUTPUT : IFocus.Mode.INPUT);
        } else if (recipe.getTransformCold() != null && COLD_AREA.func_199315_b((int)mouseX, (int)mouseY)) {
            focus = this.makeFocus(recipe.getTransformCold().func_177230_c(), mouseButton == 0 ? IFocus.Mode.OUTPUT : IFocus.Mode.INPUT);
        } else if (recipe.getTransformHot() != null && HOT_AREA.func_199315_b((int)mouseX, (int)mouseY)) {
            focus = this.makeFocus(recipe.getTransformHot().func_177230_c(), mouseButton == 0 ? IFocus.Mode.OUTPUT : IFocus.Mode.INPUT);
        }
        if (focus != null) {
            JEIPlugin.recipesGui.show(focus);
            return true;
        }
        return false;
    }

    public List<ITextComponent> getTooltipStrings(HeatPropertiesRecipe recipe, double mouseX, double mouseY) {
        ArrayList<ITextComponent> l = new ArrayList<ITextComponent>();
        if (INPUT_AREA.func_199315_b((int)mouseX, (int)mouseY)) {
            this.addTooltip(recipe.getBlock(), l);
        } else if (recipe.getTransformCold() != null && COLD_AREA.func_199315_b((int)mouseX, (int)mouseY)) {
            this.addTooltip(recipe.getTransformCold().func_177230_c(), l);
        } else if (recipe.getTransformHot() != null && HOT_AREA.func_199315_b((int)mouseX, (int)mouseY)) {
            this.addTooltip(recipe.getTransformHot().func_177230_c(), l);
        } else if (mouseY > 20.0 && mouseY < 30.0) {
            l.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.jei.tooltip.thermalResistance", new Object[0]));
        } else if (recipe.getHeatCapacity() != 0 && mouseY > 62.0) {
            l.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.jei.tooltip.heatCapacity", new Object[0]));
        }
        return l;
    }

    private IFocus<?> makeFocus(Block block, IFocus.Mode mode) {
        return block == Blocks.field_150350_a || block instanceof FlowingFluidBlock ? null : JEIPlugin.recipeManager.createFocus(mode, (Object)new ItemStack((IItemProvider)block));
    }

    private void addTooltip(Block block, List<ITextComponent> list) {
        ItemStack stack = new ItemStack((IItemProvider)block);
        list.add(stack.func_200301_q());
        stack.func_77973_b().func_77624_a(stack, ClientUtils.getClientWorld(), list, (ITooltipFlag)(ClientUtils.hasShiftDown() ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
            list.add((ITextComponent)new StringTextComponent(stack.func_77973_b().getRegistryName().toString()).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        list.add((ITextComponent)new StringTextComponent(ModNameCache.getModName(stack.func_77973_b())).func_240701_a_(new TextFormatting[]{TextFormatting.BLUE, TextFormatting.ITALIC}));
    }

    private void renderBlock(BlockState state, MatrixStack matrixStack, int x, int y) {
        if (state != null) {
            if (state.func_177230_c() == Blocks.field_150350_a) {
                this.air.draw(matrixStack, x - 8, y - 2);
            } else {
                float rot = Minecraft.func_71410_x().field_71441_e.func_82737_E() % 360L;
                GuiUtils.renderBlockInGui(matrixStack, state, x, y, 100.0f, rot, 15.0f);
            }
        }
    }
}

