/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.computer_common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.common.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.core.ModEntities;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketShowArea;
import me.desht.pneumaticcraft.common.network.PacketSpawnRing;
import me.desht.pneumaticcraft.common.progwidgets.IBlockOrdered;
import me.desht.pneumaticcraft.common.progwidgets.IBlockRightClicker;
import me.desht.pneumaticcraft.common.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.BlockDroneInterface;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.ComputerEventManager;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.DroneAICC;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethod;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethodRegistry;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.ProgWidgetCC;
import me.desht.pneumaticcraft.common.tileentity.ILuaMethodProvider;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.Validate;

public class TileEntityDroneInterface
extends TileEntity
implements ITickableTileEntity,
ILuaMethodProvider {
    private final LuaMethodRegistry luaMethodRegistry = new LuaMethodRegistry(this);
    private EntityDrone drone;
    public float rotationYaw;
    public float rotationPitch = (float)Math.toRadians(-42.0);
    private final ConcurrentLinkedQueue<Integer> ringSendQueue = new ConcurrentLinkedQueue();
    private int ringSendCooldown;
    private IProgWidget curAction;
    private int droneId;

    public TileEntityDroneInterface() {
        super((TileEntityType)ModTileEntities.DRONE_INTERFACE.get());
    }

    public void func_73660_a() {
        if (this.drone != null && !this.drone.func_70089_S()) {
            this.setDrone(null);
        }
        if (this.drone != null) {
            if (!this.func_145831_w().field_72995_K) {
                if (this.ringSendCooldown > 0) {
                    --this.ringSendCooldown;
                }
                if (!this.ringSendQueue.isEmpty() && this.ringSendCooldown <= 0) {
                    this.ringSendCooldown = this.ringSendQueue.size() > 10 ? 1 : 5;
                    NetworkHandler.sendToAllTracking((Object)new PacketSpawnRing((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, (Entity)this.drone, this.ringSendQueue.poll()), this);
                }
                if (!((Boolean)this.func_195044_w().func_177229_b((Property)BlockDroneInterface.CONNECTED)).booleanValue()) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockDroneInterface.CONNECTED, (Comparable)Boolean.valueOf(true)));
                }
            } else {
                double dx = this.drone.func_226277_ct_() - ((double)this.func_174877_v().func_177958_n() + 0.5);
                double dy = this.drone.func_226278_cu_() - ((double)this.func_174877_v().func_177956_o() + 0.5);
                double dz = this.drone.func_226281_cx_() - ((double)this.func_174877_v().func_177952_p() + 0.5);
                float f3 = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
                this.rotationYaw = (float)(-Math.atan2(dx, dz));
                this.rotationPitch = (float)(-Math.atan2(dy, f3));
            }
        } else if (!this.func_145831_w().field_72995_K && ((Boolean)this.func_195044_w().func_177229_b((Property)BlockDroneInterface.CONNECTED)).booleanValue()) {
            NetworkHandler.sendToAllTracking((Object)new PacketShowArea(this.func_174877_v(), new BlockPos[0]), this);
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockDroneInterface.CONNECTED, (Comparable)Boolean.valueOf(false)));
        }
        if (this.func_145831_w().field_72995_K) {
            Entity e = this.func_145831_w().func_73045_a(this.droneId);
            this.drone = e instanceof EntityDrone ? (EntityDrone)e : null;
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        tag.func_74768_a("drone", this.drone != null ? this.drone.func_145782_y() : -1);
        return tag;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.droneId = tag.func_74762_e("drone");
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.droneId = pkt.func_148857_g().func_74762_e("drone");
    }

    private EntityDrone validateAndGetDrone() {
        if (this.drone == null) {
            throw new IllegalStateException("There's no connected Drone!");
        }
        return this.drone;
    }

    @Override
    public void addLuaMethods(LuaMethodRegistry registry) {
        registry.registerLuaMethod(new LuaMethod("isConnectedToDrone"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{TileEntityDroneInterface.this.drone != null};
            }
        });
        registry.registerLuaMethod(new LuaMethod("getDronePressure"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{(double)((IAirHandler)TileEntityDroneInterface.this.validateAndGetDrone().getCapability(PNCCapabilities.AIR_HANDLER_CAPABILITY).orElseThrow(RuntimeException::new)).getPressure()};
            }
        });
        registry.registerLuaMethod(new LuaMethod("exitPiece"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                TileEntityDroneInterface.this.validateAndGetDrone();
                TileEntityDroneInterface.this.setDrone(null);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("getAllActions"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                ArrayList<String> actions = new ArrayList<String>();
                EntityDrone drone = (EntityDrone)((EntityType)ModEntities.DRONE.get()).func_200721_a(TileEntityDroneInterface.this.func_145831_w());
                for (ProgWidgetType type : ModProgWidgets.PROG_WIDGETS.get().getValues()) {
                    IProgWidget widget = IProgWidget.create(type);
                    if (!widget.canBeRunByComputers(drone, TileEntityDroneInterface.this.getWidget())) continue;
                    actions.add(type.getRegistryName().toString());
                }
                return new Object[]{this.getStringTable(actions)};
            }
        });
        registry.registerLuaMethod(new LuaMethod("getDronePosition"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                EntityDrone d = TileEntityDroneInterface.this.validateAndGetDrone();
                return new Double[]{d.func_226277_ct_(), d.func_226278_cu_(), d.func_226281_cx_()};
            }
        });
        registry.registerLuaMethod(new LuaMethod("setBlockOrder"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "'closest'/'highToLow'/'lowToHigh'");
                String arg = (String)args[0];
                for (IBlockOrdered.Ordering order : IBlockOrdered.Ordering.values()) {
                    if (!order.toString().equalsIgnoreCase(arg)) continue;
                    TileEntityDroneInterface.this.getWidget().setOrder(order);
                    return null;
                }
                throw new IllegalArgumentException("No valid order. Valid arguments:  'closest', 'highToLow' or 'lowToHigh'!");
            }
        });
        registry.registerLuaMethod(new LuaMethod("getAreaTypes"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return TileEntityDroneInterface.this.getWidget().getAreaTypes();
            }
        });
        registry.registerLuaMethod(new LuaMethod("addArea"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, new int[]{3, 7}, "(x,y,z) or (x1,y1,z1,x2,y2,z2,areaType)");
                if (args.length == 3) {
                    TileEntityDroneInterface.this.getWidget().addArea(((Double)args[0]).intValue(), ((Double)args[1]).intValue(), ((Double)args[2]).intValue());
                } else {
                    TileEntityDroneInterface.this.getWidget().addArea(((Double)args[0]).intValue(), ((Double)args[1]).intValue(), ((Double)args[2]).intValue(), ((Double)args[3]).intValue(), ((Double)args[4]).intValue(), ((Double)args[5]).intValue(), (String)args[6]);
                }
                TileEntityDroneInterface.this.messageToDrone((ProgWidgetType)ModProgWidgets.AREA.get());
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("removeArea"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, new int[]{3, 7}, "(x,y,z) or (x1,y1,z1,x2,y2,z2,areaType)");
                if (args.length == 3) {
                    TileEntityDroneInterface.this.getWidget().removeArea(((Double)args[0]).intValue(), ((Double)args[1]).intValue(), ((Double)args[2]).intValue());
                } else if (args.length == 7) {
                    TileEntityDroneInterface.this.getWidget().removeArea(((Double)args[0]).intValue(), ((Double)args[1]).intValue(), ((Double)args[2]).intValue(), ((Double)args[3]).intValue(), ((Double)args[4]).intValue(), ((Double)args[5]).intValue(), (String)args[6]);
                }
                TileEntityDroneInterface.this.messageToDrone((ProgWidgetType)ModProgWidgets.AREA.get());
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("clearArea"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                TileEntityDroneInterface.this.getWidget().clearArea();
                TileEntityDroneInterface.this.messageToDrone((ProgWidgetType)ModProgWidgets.AREA.get());
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("showArea"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                HashSet<BlockPos> area = new HashSet<BlockPos>();
                TileEntityDroneInterface.this.getWidget().getArea(area);
                NetworkHandler.sendToAllTracking((Object)new PacketShowArea(TileEntityDroneInterface.this.func_174877_v(), area), TileEntityDroneInterface.this);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("hideArea"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                NetworkHandler.sendToAllTracking((Object)new PacketShowArea(TileEntityDroneInterface.this.func_174877_v(), new BlockPos[0]), TileEntityDroneInterface.this);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("addWhitelistItemFilter"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 3, "<string> item/block name, <bool> Use NBT, <bool> Use Mod Similarity");
                TileEntityDroneInterface.this.getWidget().addWhitelistItemFilter((String)args[0], (Boolean)args[1], (Boolean)args[2]);
                TileEntityDroneInterface.this.messageToDrone((ProgWidgetType)ModProgWidgets.ITEM_FILTER.get());
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("addBlacklistItemFilter"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 3, "<string> item/block name, <bool> Use NBT, <bool> Use Mod Similarity");
                TileEntityDroneInterface.this.getWidget().addBlacklistItemFilter((String)args[0], (Boolean)args[1], (Boolean)args[2]);
                TileEntityDroneInterface.this.messageToDrone((ProgWidgetType)ModProgWidgets.ITEM_FILTER.get());
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("clearWhitelistItemFilter"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                TileEntityDroneInterface.this.getWidget().clearItemWhitelist();
                TileEntityDroneInterface.this.messageToDrone((ProgWidgetType)ModProgWidgets.ITEM_FILTER.get());
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("clearBlacklistItemFilter"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                TileEntityDroneInterface.this.getWidget().clearItemBlacklist();
                TileEntityDroneInterface.this.messageToDrone((ProgWidgetType)ModProgWidgets.ITEM_FILTER.get());
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("addWhitelistText"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> text");
                TileEntityDroneInterface.this.getWidget().addWhitelistText((String)args[0]);
                TileEntityDroneInterface.this.messageToDrone((ProgWidgetType)ModProgWidgets.TEXT.get());
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("addBlacklistText"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> text");
                TileEntityDroneInterface.this.getWidget().addBlacklistText((String)args[0]);
                TileEntityDroneInterface.this.messageToDrone((ProgWidgetType)ModProgWidgets.TEXT.get());
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("clearWhitelistText"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                TileEntityDroneInterface.this.getWidget().clearWhitelistText();
                TileEntityDroneInterface.this.messageToDrone((ProgWidgetType)ModProgWidgets.TEXT.get());
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("clearBlacklistText"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                TileEntityDroneInterface.this.getWidget().clearBlacklistText();
                TileEntityDroneInterface.this.messageToDrone((ProgWidgetType)ModProgWidgets.TEXT.get());
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setSide"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 2, "down/up/north/south/west/east, <boolean> valid");
                Direction dir = this.getDirForString((String)args[0]);
                boolean[] sides = TileEntityDroneInterface.this.getWidget().getSides();
                sides[dir.ordinal()] = (Boolean)args[1];
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setSides"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 6, "6 x boolean (order: DUNSWE)");
                boolean[] sides = new boolean[6];
                for (int i = 0; i < 6; ++i) {
                    sides[i] = (Boolean)args[i];
                }
                TileEntityDroneInterface.this.getWidget().setSides(sides);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setEmittingRedstone"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<int> signal_strength");
                TileEntityDroneInterface.this.getWidget().setEmittingRedstone(((Double)args[0]).intValue());
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setRenameString"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> new_name");
                TileEntityDroneInterface.this.getWidget().setNewName((String)args[0]);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("addWhitelistLiquidFilter"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> fluid_name");
                TileEntityDroneInterface.this.getWidget().addWhitelistLiquidFilter((String)args[0]);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("addBlacklistLiquidFilter"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> fluid_name");
                TileEntityDroneInterface.this.getWidget().addBlacklistLiquidFilter((String)args[0]);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("clearWhitelistLiquidFilter"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                TileEntityDroneInterface.this.getWidget().clearLiquidWhitelist();
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("clearBlacklistLiquidFilter"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                TileEntityDroneInterface.this.getWidget().clearLiquidBlacklist();
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setDropStraight"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<boolean> drop_straight");
                TileEntityDroneInterface.this.getWidget().setDropStraight((Boolean)args[0]);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setUseCount"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<boolean> should_use_count");
                TileEntityDroneInterface.this.getWidget().setUseCount((Boolean)args[0]);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setCount"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<int> use_count");
                TileEntityDroneInterface.this.getWidget().setCount(((Double)args[0]).intValue());
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setIsAndFunction"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<boolean> is_and_function");
                TileEntityDroneInterface.this.getWidget().setAndFunction((Boolean)args[0]);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setOperator"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> '>=', '=' or = '>='");
                TileEntityDroneInterface.this.getWidget().setOperator((String)args[0]);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("evaluateCondition"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                if (TileEntityDroneInterface.this.curAction instanceof ICondition) {
                    boolean bool = ((ICondition)((Object)TileEntityDroneInterface.this.curAction)).evaluate(TileEntityDroneInterface.this.drone, TileEntityDroneInterface.this.getWidget());
                    return new Object[]{bool};
                }
                throw new IllegalArgumentException("Current action is not a condition! Action: " + (TileEntityDroneInterface.this.curAction != null ? ((Object)TileEntityDroneInterface.this.curAction.getType()).toString() : "*none*"));
            }
        });
        registry.registerLuaMethod(new LuaMethod("setUseMaxActions"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<boolean> should_use_max_actions");
                TileEntityDroneInterface.this.getWidget().setUseMaxActions((Boolean)args[0]);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setMaxActions"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<int> max_actions");
                TileEntityDroneInterface.this.getWidget().setMaxActions(((Double)args[0]).intValue());
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setSneaking"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<boolean> is_sneaking");
                TileEntityDroneInterface.this.getWidget().setSneaking((Boolean)args[0]);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setCanSteal"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<boolean> can_steal");
                TileEntityDroneInterface.this.getWidget().setCanSteal((Boolean)args[0]);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setRightClickType"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> 'click_item' or 'click_block'");
                String val = ((String)args[0]).toUpperCase(Locale.ROOT);
                TileEntityDroneInterface.this.getWidget().setClickType(IBlockRightClicker.RightClickType.valueOf(val));
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setPlaceFluidBlocks"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<boolean> should_place_fluid_blocks");
                TileEntityDroneInterface.this.getWidget().setPlaceFluidBlocks((Boolean)args[0]);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setAction"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> action_name");
                String widgetName = (String)args[0];
                ResourceLocation id = widgetName.contains(":") ? new ResourceLocation(widgetName) : PneumaticRegistry.RL(widgetName);
                ProgWidgetType type = (ProgWidgetType)ModProgWidgets.PROG_WIDGETS.get().getValue(id);
                Validate.notNull((Object)((Object)type), (String)("No action with the name '" + widgetName + "'!"), (Object[])new Object[0]);
                IProgWidget widget = IProgWidget.create(type);
                Validate.isTrue((boolean)widget.isAvailable(), (String)("Widget '" + widget.getTypeID() + "' is not available in this instance!"), (Object[])new Object[0]);
                Goal ai = widget.getWidgetAI(TileEntityDroneInterface.this.drone, TileEntityDroneInterface.this.getWidget());
                Validate.isTrue((ai != null && widget.canBeRunByComputers(TileEntityDroneInterface.this.drone, TileEntityDroneInterface.this.getWidget()) ? 1 : 0) != 0, (String)("Parsed action '" + widgetName + "' is not a runnable action!"), (Object[])new Object[0]);
                TileEntityDroneInterface.this.getAI().setAction(widget, ai);
                TileEntityDroneInterface.this.getTargetAI().setAction(widget, widget.getWidgetTargetAI(TileEntityDroneInterface.this.drone, TileEntityDroneInterface.this.getWidget()));
                TileEntityDroneInterface.this.messageToDrone(widget.getColor().getColorValue());
                TileEntityDroneInterface.this.curAction = widget;
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("getAction"){

            @Override
            public Object[] call(Object[] args) {
                Object[] objectArray;
                this.requireNoArgs(args);
                if (TileEntityDroneInterface.this.curAction != null) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = TileEntityDroneInterface.this.curAction.getType().getRegistryName().toString();
                } else {
                    objectArray = null;
                }
                return objectArray;
            }
        });
        registry.registerLuaMethod(new LuaMethod("abortAction"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                TileEntityDroneInterface.this.getAI().abortAction();
                TileEntityDroneInterface.this.getTargetAI().abortAction();
                TileEntityDroneInterface.this.messageToDrone(-1);
                TileEntityDroneInterface.this.curAction = null;
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("isActionDone"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{TileEntityDroneInterface.this.getAI().isActionDone()};
            }
        });
        registry.registerLuaMethod(new LuaMethod("forgetTarget"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                TileEntityDroneInterface.this.validateAndGetDrone().func_70624_b(null);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("getUpgrades"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> upgrade_name");
                EnumUpgrade upgrade = EnumUpgrade.valueOf(((String)args[0]).toUpperCase(Locale.ROOT));
                return new Object[]{(double)TileEntityDroneInterface.this.validateAndGetDrone().getUpgrades(upgrade)};
            }
        });
        registry.registerLuaMethod(new LuaMethod("setCraftingGrid"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 9, "9 x item_name");
                String[] grid = new String[9];
                for (int i = 0; i < 9; ++i) {
                    grid[i] = (String)args[i];
                }
                TileEntityDroneInterface.this.getWidget().setCraftingGrid(grid);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setVariable"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, new int[]{2, 4}, "<string> var_name, true/false OR <string> var_name, <int> x, <int> y, <int> z");
                EntityDrone d = TileEntityDroneInterface.this.validateAndGetDrone();
                String varName = (String)args[0];
                int x = args[1] instanceof Double ? ((Double)args[1]).intValue() : ((Boolean)args[1] != false ? 1 : 0);
                int y = 0;
                int z = 0;
                if (args.length == 4) {
                    y = ((Double)args[2]).intValue();
                    z = ((Double)args[3]).intValue();
                }
                d.setVariable(varName, new BlockPos(x, y, z));
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("getVariable"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> var_name");
                BlockPos var = TileEntityDroneInterface.this.validateAndGetDrone().getVariable((String)args[0]);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return new Object[]{var.func_177958_n(), var.func_177956_o(), var.func_177952_p()};
            }
        });
        registry.registerLuaMethod(new LuaMethod("setSignText"){

            @Override
            public Object[] call(Object[] args) {
                ((TileEntityDroneInterface)TileEntityDroneInterface.this).getWidget().signText = new String[args.length];
                for (int i = 0; i < args.length; ++i) {
                    ((TileEntityDroneInterface)TileEntityDroneInterface.this).getWidget().signText[i] = (String)args[i];
                }
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setRequiresTool"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<boolean> require_tool");
                TileEntityDroneInterface.this.getWidget().setRequiresTool((Boolean)args[0]);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("getDroneName"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{TileEntityDroneInterface.this.validateAndGetDrone().func_200200_C_().getString()};
            }
        });
        registry.registerLuaMethod(new LuaMethod("getOwnerName"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{TileEntityDroneInterface.this.validateAndGetDrone().getOwnerName().getString()};
            }
        });
        registry.registerLuaMethod(new LuaMethod("getOwnerID"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{TileEntityDroneInterface.this.validateAndGetDrone().getOwnerUUID().toString()};
            }
        });
    }

    @Override
    public LuaMethodRegistry getLuaMethodRegistry() {
        return this.luaMethodRegistry;
    }

    @Override
    public String getPeripheralType() {
        return "droneInterface";
    }

    public void setDrone(EntityDrone drone) {
        this.drone = drone;
        ComputerEventManager.getInstance().sendEvents(this, drone != null ? "droneConnected" : "droneDisconnected", new Object[0]);
        BlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public EntityDrone getDrone() {
        return this.drone;
    }

    private ProgWidgetCC getWidget() {
        return this.getAI().getWidget();
    }

    private DroneAICC getAI() {
        if (this.drone != null) {
            for (DroneAIManager.EntityAITaskEntry task : this.drone.getRunningTasks()) {
                if (!(task.goal instanceof DroneAICC)) continue;
                return (DroneAICC)task.goal;
            }
        }
        this.setDrone(null);
        throw new IllegalStateException("There's no connected Drone!");
    }

    private DroneAICC getTargetAI() {
        if (this.drone != null && this.drone.getRunningTargetAI() instanceof DroneAICC) {
            return (DroneAICC)this.drone.getRunningTargetAI();
        }
        this.setDrone(null);
        throw new IllegalStateException("There's no connected Drone!");
    }

    private <P extends ProgWidget> void messageToDrone(ProgWidgetType<P> type) {
        this.messageToDrone(((ProgWidget)type.create()).getColor().getColorValue());
    }

    private void messageToDrone(int color) {
        this.ringSendQueue.offer(color);
    }
}

