/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.wrench.IWrenchRegistry;
import me.desht.pneumaticcraft.common.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.item.ItemPneumaticWrench;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;

public enum ModdedWrenchUtils implements IWrenchRegistry
{
    INSTANCE;

    private final Set<ResourceLocation> wrenches = new HashSet<ResourceLocation>();
    private static final BiFunction<ItemUseContext, BlockState, ActionResultType> NO_OP_PRE;
    private static final BiConsumer<ItemUseContext, BlockState> NO_OP_POST;
    private final Map<String, BiFunction<ItemUseContext, BlockState, ActionResultType>> modBehavioursPre = new Object2ObjectOpenHashMap();
    private final Map<String, BiConsumer<ItemUseContext, BlockState>> modBehavioursPost = new Object2ObjectOpenHashMap();

    public static ModdedWrenchUtils getInstance() {
        return INSTANCE;
    }

    void registerThirdPartyWrenches() {
        this.registerWrench("thermalfoundation:wrench");
        this.registerWrench("rftools:smartwrench");
        this.registerWrench("immersiveengineering:hammer");
        this.registerWrench("appliedenergistics2:certus_quartz_wrench");
        this.registerWrench("appliedenergistics2:nether_quartz_wrench");
        this.registerWrench("enderio:item_yeta_wrench");
        this.registerWrench("buildcraftcore:wrench");
        this.registerWrench("teslacorelib:wrench");
        this.registerWrench("ic2:wrench");
        this.registerWrench("chiselsandbits:wrench_wood");
        this.registerWrench("mekanism:configurator");
    }

    private void registerWrench(String wrenchId) {
        this.wrenches.add(new ResourceLocation(wrenchId));
    }

    @Override
    public boolean isModdedWrench(@Nonnull ItemStack stack) {
        return !(stack.func_77973_b() instanceof ItemPneumaticWrench) && (stack.func_77973_b().func_206844_a(PneumaticCraftTags.Items.WRENCHES) || this.wrenches.contains(stack.func_77973_b().getRegistryName()));
    }

    @Override
    public boolean isWrench(@Nonnull ItemStack stack) {
        return stack.func_77973_b() instanceof ItemPneumaticWrench || this.isModdedWrench(stack);
    }

    @Override
    public void registerWrench(Item wrench) {
        this.wrenches.add(wrench.getRegistryName());
    }

    @Override
    public void addModdedWrenchBehaviour(String modid, BiFunction<ItemUseContext, BlockState, ActionResultType> behaviourPre, BiConsumer<ItemUseContext, BlockState> behaviourPost) {
        this.modBehavioursPre.put(modid, behaviourPre);
        this.modBehavioursPost.put(modid, behaviourPost);
    }

    public ActionResultType onWrenchedPre(ItemUseContext ctx, BlockState state) {
        return this.modBehavioursPre.getOrDefault(state.func_177230_c().getRegistryName().func_110624_b(), NO_OP_PRE).apply(ctx, state);
    }

    public void onWrenchedPost(ItemUseContext ctx, BlockState state) {
        this.modBehavioursPost.getOrDefault(state.func_177230_c().getRegistryName().func_110624_b(), NO_OP_POST).accept(ctx, state);
    }

    static {
        NO_OP_PRE = (ctx, state) -> ActionResultType.PASS;
        NO_OP_POST = (ctx, state) -> {};
    }
}

