/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets.area;

import java.util.List;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaType;
import me.desht.pneumaticcraft.common.util.LegacyAreaWidgetConverter;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;

public class AreaTypeGrid
extends AreaType {
    public static final String ID = "grid";
    private int interval;

    public AreaTypeGrid() {
        super(ID);
    }

    public String toString() {
        return this.getName() + "/" + this.interval;
    }

    @Override
    public void addArea(Consumer<BlockPos> areaAdder, BlockPos p1, BlockPos p2, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (p1.equals((Object)p2) || this.interval <= 0) {
            areaAdder.accept(p1);
        } else {
            int x = p1.func_177958_n();
            while (p1.func_177958_n() < p2.func_177958_n() ? x <= p2.func_177958_n() : x >= p2.func_177958_n()) {
                int y = p1.func_177956_o();
                while (p1.func_177956_o() < p2.func_177956_o() ? y <= p2.func_177956_o() : y >= p2.func_177956_o()) {
                    int z = p1.func_177952_p();
                    while (p1.func_177952_p() < p2.func_177952_p() ? z <= p2.func_177952_p() : z >= p2.func_177952_p()) {
                        areaAdder.accept(new BlockPos(x, y, z));
                        z += (p1.func_177952_p() < p2.func_177952_p() ? 1 : -1) * this.interval;
                    }
                    y += (p1.func_177956_o() < p2.func_177956_o() ? 1 : -1) * this.interval;
                }
                x += (p1.func_177958_n() < p2.func_177958_n() ? 1 : -1) * this.interval;
            }
        }
    }

    @Override
    public void addUIWidgets(List<AreaType.AreaTypeWidget> widgets) {
        super.addUIWidgets(widgets);
        widgets.add(new AreaType.AreaTypeWidgetInteger("pneumaticcraft.gui.progWidget.area.type.grid.interval", () -> this.interval, interval -> {
            this.interval = interval;
        }));
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("interval", this.interval);
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.interval = tag.func_74762_e("interval");
    }

    @Override
    public void writeToPacket(PacketBuffer buffer) {
        super.writeToPacket(buffer);
        buffer.func_150787_b(this.interval);
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        super.readFromPacket(buf);
        this.interval = buf.func_150792_a();
    }

    @Override
    public void convertFromLegacy(LegacyAreaWidgetConverter.EnumOldAreaType oldAreaType, int typeInfo) {
        this.interval = typeInfo;
    }
}

