/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.AxisOptions;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.IVariableSetWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetCoordinate;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ProgWidgetCoordinateOperator
extends ProgWidget
implements IVariableSetWidget {
    private EnumOperator operator = EnumOperator.PLUS_MINUS;
    private String variable = "";
    private DroneAIManager aiManager;
    private final AxisOptions axisOptions = new AxisOptions(true, true, true);

    public ProgWidgetCoordinateOperator() {
        super((ProgWidgetType)ModProgWidgets.COORDINATE_OPERATOR.get());
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return null;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of((Object)ModProgWidgets.COORDINATE.get());
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.GRAY;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.ADVANCED;
    }

    @Override
    public void addErrors(List<ITextComponent> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.variable.equals("")) {
            curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.general.error.emptyVariable", new Object[0]));
        }
        if (!(this.axisOptions.shouldCheck(Direction.Axis.X) || this.axisOptions.shouldCheck(Direction.Axis.Y) || this.axisOptions.shouldCheck(Direction.Axis.Z))) {
            curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.conditionCoordinate.error.noAxisSelected", new Object[0]));
        }
        if (this.operator == EnumOperator.MAX_MIN) {
            if (this.getConnectedParameters()[0] == null && this.getConnectedParameters()[this.getParameters().size()] == null) {
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.coordinateOperator.noParameter", new Object[0]));
            }
        } else if (this.operator == EnumOperator.MULIPLY_DIVIDE) {
            IProgWidget w = this.getConnectedParameters()[1];
            while (w instanceof ProgWidgetCoordinate) {
                if (!((ProgWidgetCoordinate)w).isUsingVariable()) {
                    BlockPos pos = ((ProgWidgetCoordinate)w).getCoordinate();
                    if (this.axisOptions.shouldCheck(Direction.Axis.X) && pos.func_177958_n() == 0 || this.axisOptions.shouldCheck(Direction.Axis.Y) && pos.func_177956_o() == 0 || this.axisOptions.shouldCheck(Direction.Axis.Z) && pos.func_177952_p() == 0) {
                        curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.coordinateOperator.divideByZero", new Object[0]));
                        break;
                    }
                }
                w = w.getConnectedParameters()[0];
            }
        }
    }

    @Override
    public IProgWidget getOutputWidget(IDroneBase drone, List<IProgWidget> allWidgets) {
        if (!this.variable.equals("")) {
            BlockPos curPos = ProgWidgetCoordinateOperator.calculateCoordinate(this, 0, this.operator, this.axisOptions);
            this.aiManager.setCoordinate(this.variable, curPos);
        }
        return super.getOutputWidget(drone, allWidgets);
    }

    public static BlockPos calculateCoordinate(IProgWidget widget, int argIndex, EnumOperator operator, AxisOptions axisOptions) {
        return ProgWidgetCoordinateOperator.doCalc((ProgWidgetCoordinate)widget.getConnectedParameters()[argIndex], (ProgWidgetCoordinate)widget.getConnectedParameters()[argIndex + widget.getParameters().size()], operator, axisOptions);
    }

    public static BlockPos calculateCoordinate(IProgWidget widget, int argIndex, EnumOperator operator) {
        return ProgWidgetCoordinateOperator.calculateCoordinate(widget, argIndex, operator, AxisOptions.TRUE);
    }

    private static BlockPos doCalc(ProgWidgetCoordinate whiteList, ProgWidgetCoordinate blackList, EnumOperator op, AxisOptions axisOptions) {
        BlockPos curPos = op.initialValue(whiteList, blackList);
        if (whiteList != null) {
            whiteList = (ProgWidgetCoordinate)whiteList.getConnectedParameters()[0];
            while (whiteList != null) {
                curPos = ProgWidgetCoordinateOperator.getNextPos(curPos, whiteList.getCoordinate(), op, true, axisOptions);
                whiteList = (ProgWidgetCoordinate)whiteList.getConnectedParameters()[0];
            }
        } else if (blackList != null) {
            blackList = (ProgWidgetCoordinate)blackList.getConnectedParameters()[0];
        }
        while (blackList != null) {
            curPos = ProgWidgetCoordinateOperator.getNextPos(curPos, blackList.getCoordinate(), op, false, axisOptions);
            blackList = (ProgWidgetCoordinate)blackList.getConnectedParameters()[0];
        }
        return curPos;
    }

    private static BlockPos getNextPos(BlockPos curPos, BlockPos rawPos, EnumOperator op, boolean isWhiteList, AxisOptions axisOptions) {
        BlockPos pos = new BlockPos(axisOptions.shouldCheck(Direction.Axis.X) ? rawPos.func_177958_n() : op.defaultValue(isWhiteList), axisOptions.shouldCheck(Direction.Axis.Y) ? rawPos.func_177956_o() : op.defaultValue(isWhiteList), axisOptions.shouldCheck(Direction.Axis.Z) ? rawPos.func_177952_p() : op.defaultValue(isWhiteList));
        return op.apply(curPos, pos, isWhiteList);
    }

    @Override
    public ResourceLocation getTexture() {
        return this.operator.texture;
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        if (!this.variable.isEmpty()) {
            tag.func_74778_a("variable", this.variable);
        }
        tag.func_74774_a("operator", (byte)this.operator.ordinal());
        this.axisOptions.writeToNBT(tag);
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.variable = tag.func_74779_i("variable");
        this.operator = EnumOperator.values()[tag.func_74771_c("operator")];
        this.axisOptions.readFromNBT(tag, true);
    }

    @Override
    public void writeToPacket(PacketBuffer buf) {
        super.writeToPacket(buf);
        buf.func_180714_a(this.variable);
        buf.writeByte(this.operator.ordinal());
        this.axisOptions.writeToBuffer(buf);
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        super.readFromPacket(buf);
        this.variable = buf.func_150789_c(64);
        this.operator = EnumOperator.values()[buf.readByte()];
        this.axisOptions.readFromBuffer(buf);
    }

    public EnumOperator getOperator() {
        return this.operator;
    }

    public void setOperator(EnumOperator operator) {
        this.operator = operator;
    }

    @Override
    public String getVariable() {
        return this.variable;
    }

    @Override
    public void setVariable(String variable) {
        this.variable = variable;
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
    }

    public AxisOptions getAxisOptions() {
        return this.axisOptions;
    }

    @Override
    public void getTooltip(List<ITextComponent> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemAssign.settingVariable", this.variable));
        curTooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.coordinateOperator.operator", new Object[0]).func_240702_b_(" ").func_230529_a_((ITextComponent)PneumaticCraftUtils.xlate(this.operator.getTranslationKey(), new Object[0])));
        this.getAxesString().ifPresent(t -> curTooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.coordinateOperator.axes", new Object[0]).func_240702_b_(" ").func_230529_a_(t)));
    }

    @Override
    public List<ITextComponent> getExtraStringInfo() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object[])new ITextComponent[]{this.varAsTextComponent(this.variable), PneumaticCraftUtils.xlate(this.operator.getTranslationKey(), new Object[0])});
        this.getAxesString().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    private Optional<ITextComponent> getAxesString() {
        List l = Arrays.stream(Direction.Axis.values()).filter(this.axisOptions::shouldCheck).map(axis -> axis.func_176719_a().toUpperCase()).collect(Collectors.toList());
        return !l.isEmpty() && l.size() < 3 ? Optional.of(new StringTextComponent(String.join((CharSequence)"/", l))) : Optional.empty();
    }

    @Override
    public void addVariables(Set<String> variables) {
        variables.add(this.variable);
    }

    public static enum EnumOperator implements ITranslatableEnum
    {
        PLUS_MINUS("plus_minus", 0, 0),
        MULIPLY_DIVIDE("multiply_divide", 1, 1),
        MAX_MIN("max_min", Integer.MIN_VALUE, Integer.MAX_VALUE);

        public final ResourceLocation texture;
        private final String name;
        private final int defWhite;
        private final int defBlack;

        private EnumOperator(String name, int defWhite, int defBlack) {
            this.name = name;
            this.texture = Textures.progWidgetTexture("coordinate_operation_" + name + ".png");
            this.defWhite = defWhite;
            this.defBlack = defBlack;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.progWidget.coordinateOperator." + this.name;
        }

        public int defaultValue(boolean isWhiteList) {
            return isWhiteList ? this.defWhite : this.defBlack;
        }

        public BlockPos initialValue(ProgWidgetCoordinate whiteList, ProgWidgetCoordinate blackList) {
            switch (this) {
                case PLUS_MINUS: {
                    return whiteList != null ? whiteList.getCoordinate() : (blackList != null ? BlockPos.field_177992_a.func_177973_b((Vector3i)blackList.getCoordinate()) : BlockPos.field_177992_a);
                }
                case MULIPLY_DIVIDE: {
                    return whiteList != null ? whiteList.getCoordinate() : BlockPos.field_177992_a;
                }
                case MAX_MIN: {
                    return whiteList != null ? whiteList.getCoordinate() : (blackList != null ? blackList.getCoordinate() : BlockPos.field_177992_a);
                }
            }
            throw new IllegalArgumentException("bad value for op?");
        }

        public BlockPos apply(BlockPos p1, BlockPos p2, boolean isWhiteList) {
            switch (this) {
                case PLUS_MINUS: {
                    return isWhiteList ? new BlockPos(p1.func_177958_n() + p2.func_177958_n(), p1.func_177956_o() + p2.func_177956_o(), p1.func_177952_p() + p2.func_177952_p()) : new BlockPos(p1.func_177958_n() - p2.func_177958_n(), p1.func_177956_o() - p2.func_177956_o(), p1.func_177952_p() - p2.func_177952_p());
                }
                case MULIPLY_DIVIDE: {
                    if (!(isWhiteList || p2.func_177958_n() != 0 && p2.func_177956_o() != 0 && p2.func_177952_p() != 0)) {
                        return p1;
                    }
                    return isWhiteList ? new BlockPos(p1.func_177958_n() * p2.func_177958_n(), p1.func_177956_o() * p2.func_177956_o(), p1.func_177952_p() * p2.func_177952_p()) : new BlockPos(p1.func_177958_n() / p2.func_177958_n(), p1.func_177956_o() / p2.func_177956_o(), p1.func_177952_p() / p2.func_177952_p());
                }
                case MAX_MIN: {
                    return isWhiteList ? new BlockPos(Math.max(p1.func_177958_n(), p2.func_177958_n()), Math.max(p1.func_177956_o(), p2.func_177956_o()), Math.max(p1.func_177952_p(), p2.func_177952_p())) : new BlockPos(Math.min(p1.func_177958_n(), p2.func_177958_n()), Math.min(p1.func_177956_o(), p2.func_177956_o()), Math.min(p1.func_177952_p(), p2.func_177952_p()));
                }
            }
            return p1;
        }
    }
}

