/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.inventory.ContainerPneumaticBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class PacketUtil {
    public static void writeGlobalPos(PacketBuffer buf, GlobalPos gPos) {
        buf.func_192572_a(gPos.func_239646_a_().func_240901_a_());
        buf.func_179255_a(gPos.func_218180_b());
    }

    public static GlobalPos readGlobalPos(PacketBuffer buf) {
        RegistryKey worldKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)buf.func_192575_l());
        BlockPos pos = buf.func_179259_c();
        return GlobalPos.func_239648_a_((RegistryKey)worldKey, (BlockPos)pos);
    }

    @Nonnull
    public static <T extends TileEntity> Optional<T> getTE(PlayerEntity player, BlockPos pos, Class<T> cls) {
        Object te;
        if (player == null) {
            World w = ClientUtils.getClientWorld();
            if (w != null) {
                return PneumaticCraftUtils.getTileEntityAt((IBlockReader)w, pos, cls);
            }
        } else if (player.field_71070_bA instanceof ContainerPneumaticBase && (te = ((ContainerPneumaticBase)player.field_71070_bA).te) != null && cls.isAssignableFrom(te.getClass()) && (pos == null || te.func_174877_v().equals((Object)pos))) {
            return Optional.of(te);
        }
        return Optional.empty();
    }

    @Nonnull
    public static <T extends TileEntity> Optional<T> getTE(PlayerEntity player, Class<T> cls) {
        if (player.field_70170_p.field_72995_K) {
            throw new RuntimeException("don't call this method client side!");
        }
        return PacketUtil.getTE(player, null, cls);
    }

    public static void writeNullableBlockState(PacketBuffer buf, @Nullable BlockState state) {
        if (state == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.func_150786_a(NBTUtil.func_190009_a((BlockState)state));
        }
    }

    @Nullable
    public static BlockState readNullableBlockState(PacketBuffer buf) {
        if (buf.readBoolean()) {
            CompoundNBT tag = buf.func_150793_b();
            return NBTUtil.func_190008_d((CompoundNBT)Objects.requireNonNull(tag));
        }
        return null;
    }
}

