/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketToggleArmorFeatureBulk {
    private final List<FeatureSetting> features;

    public PacketToggleArmorFeatureBulk(List<FeatureSetting> features) {
        this.features = features;
    }

    PacketToggleArmorFeatureBulk(PacketBuffer buffer) {
        this.features = new ArrayList<FeatureSetting>();
        int len = buffer.func_150792_a();
        for (int i = 0; i < len; ++i) {
            this.features.add(new FeatureSetting(buffer));
        }
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_150787_b(this.features.size());
        this.features.forEach(f -> f.toBytes(buf));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer((PlayerEntity)player);
                this.features.forEach(arg_0 -> PacketToggleArmorFeatureBulk.lambda$null$1((PlayerEntity)player, handler, arg_0));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$null$1(PlayerEntity player, CommonArmorHandler handler, FeatureSetting f) {
        if (f.featureIndex >= 0 && f.featureIndex < ArmorUpgradeRegistry.getInstance().getHandlersForSlot(f.slot).size() && ItemPneumaticArmor.isPneumaticArmorPiece(player, f.slot)) {
            handler.setUpgradeEnabled(f.slot, f.featureIndex, f.state);
        }
    }

    public static class FeatureSetting {
        private final EquipmentSlotType slot;
        private final byte featureIndex;
        private final boolean state;

        FeatureSetting(PacketBuffer buffer) {
            this(EquipmentSlotType.values()[buffer.readByte()], buffer.readByte(), buffer.readBoolean());
        }

        public FeatureSetting(EquipmentSlotType slot, byte featureIndex, boolean state) {
            this.slot = slot;
            this.featureIndex = featureIndex;
            this.state = state;
        }

        void toBytes(PacketBuffer buffer) {
            buffer.writeByte(this.slot.ordinal());
            buffer.writeByte((int)this.featureIndex);
            buffer.writeBoolean(this.state);
        }
    }
}

