/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketToggleArmorFeature {
    private final byte featureIndex;
    private final boolean state;
    private final EquipmentSlotType slot;

    public PacketToggleArmorFeature(EquipmentSlotType slot, byte featureIndex, boolean state) {
        this.featureIndex = featureIndex;
        this.state = state;
        this.slot = slot;
    }

    PacketToggleArmorFeature(PacketBuffer buffer) {
        this.featureIndex = buffer.readByte();
        this.state = buffer.readBoolean();
        this.slot = EquipmentSlotType.values()[buffer.readByte()];
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeByte((int)this.featureIndex);
        buf.writeBoolean(this.state);
        buf.writeByte(this.slot.ordinal());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && this.featureIndex >= 0 && this.featureIndex < ArmorUpgradeRegistry.getInstance().getHandlersForSlot(this.slot).size() && (ItemPneumaticArmor.isPneumaticArmorPiece((PlayerEntity)player, this.slot) || this.slot == EquipmentSlotType.HEAD && this.featureIndex == 0)) {
                CommonArmorHandler.getHandlerForPlayer((PlayerEntity)player).setUpgradeEnabled(this.slot, this.featureIndex, this.state);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

