/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.tubes.ModuleRedstone;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureTube;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSyncRedstoneModuleToClient
extends LocationIntPacket {
    private final ModuleRedstone.EnumRedstoneDirection dir;
    private final int outputLevel;
    private final int inputLevel;
    private final int channel;
    private final byte side;

    public PacketSyncRedstoneModuleToClient(ModuleRedstone module) {
        super(module.getTube().func_174877_v());
        this.dir = module.getRedstoneDirection();
        this.outputLevel = module.getRedstoneLevel();
        this.inputLevel = module.getInputLevel();
        this.channel = module.getColorChannel();
        this.side = (byte)module.getDirection().func_176745_a();
    }

    PacketSyncRedstoneModuleToClient(PacketBuffer buffer) {
        super(buffer);
        this.dir = ModuleRedstone.EnumRedstoneDirection.values()[buffer.readByte()];
        this.side = buffer.readByte();
        this.outputLevel = buffer.readByte();
        this.inputLevel = buffer.readByte();
        this.channel = buffer.readByte();
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        super.toBytes(buf);
        buf.writeByte(this.dir.ordinal());
        buf.writeByte((int)this.side);
        buf.writeByte(this.outputLevel);
        buf.writeByte(this.inputLevel);
        buf.writeByte(this.channel);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> PneumaticCraftUtils.getTileEntityAt((IBlockReader)ClientUtils.getClientWorld(), this.pos, TileEntityPressureTube.class).ifPresent(te -> {
            TubeModule module = te.getModule(Direction.func_82600_a((int)this.side));
            if (module instanceof ModuleRedstone) {
                ModuleRedstone mr = (ModuleRedstone)module;
                mr.setColorChannel(this.channel);
                mr.setRedstoneDirection(this.dir);
                mr.setOutputLevel(this.outputLevel);
                mr.setInputLevel(this.inputLevel);
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

