/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.Objects;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.LocationDoublePacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PacketPlaySound
extends LocationDoublePacket {
    private final SoundEvent soundEvent;
    private final SoundCategory category;
    private final float volume;
    private final float pitch;
    private final boolean distanceDelay;

    public PacketPlaySound(SoundEvent soundEvent, SoundCategory category, double x, double y, double z, float volume, float pitch, boolean distanceDelay) {
        super(x, y, z);
        this.soundEvent = soundEvent;
        this.category = category;
        this.volume = volume;
        this.pitch = pitch;
        this.distanceDelay = distanceDelay;
    }

    public PacketPlaySound(SoundEvent soundEvent, SoundCategory category, BlockPos pos, float volume, float pitch, boolean distanceDelay) {
        this(soundEvent, category, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), volume, pitch, distanceDelay);
    }

    public PacketPlaySound(PacketBuffer buffer) {
        super(buffer);
        this.soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(buffer.func_192575_l());
        this.category = SoundCategory.values()[buffer.readInt()];
        this.volume = buffer.readFloat();
        this.pitch = buffer.readFloat();
        this.distanceDelay = buffer.readBoolean();
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        super.toBytes(buffer);
        buffer.func_192572_a(Objects.requireNonNull(this.soundEvent.getRegistryName()));
        buffer.writeInt(this.category.ordinal());
        buffer.writeFloat(this.volume);
        buffer.writeFloat(this.pitch);
        buffer.writeBoolean(this.distanceDelay);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientUtils.getClientWorld().func_184134_a(this.x, this.y, this.z, this.soundEvent, this.category, this.volume, this.pitch, this.distanceDelay));
        ctx.get().setPacketHandled(true);
    }
}

