/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import com.mojang.datafixers.util.Either;
import java.util.function.Function;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketPlayMovingSound {
    private final MovingSounds.Sound sound;
    private final SoundSource source;

    public PacketPlayMovingSound(MovingSounds.Sound sound, SoundSource source) {
        this.sound = sound;
        this.source = source;
    }

    public PacketPlayMovingSound(PacketBuffer buffer) {
        this.sound = (MovingSounds.Sound)buffer.func_179257_a(MovingSounds.Sound.class);
        this.source = SoundSource.fromBytes(buffer);
    }

    public void toBytes(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.sound);
        this.source.toBytes(buffer);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (this.source != null) {
                this.source.handle(this.sound);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static class SoundSource {
        private final Either<Entity, BlockPos> entityOrPos;

        private SoundSource(Either<Entity, BlockPos> entityOrPos) {
            this.entityOrPos = entityOrPos;
        }

        public static SoundSource of(Entity e) {
            return new SoundSource((Either<Entity, BlockPos>)Either.left((Object)e));
        }

        public static SoundSource of(int id) {
            Entity e = ClientUtils.getClientWorld().func_73045_a(id);
            return e == null ? null : SoundSource.of(e);
        }

        public static SoundSource of(BlockPos pos) {
            return new SoundSource((Either<Entity, BlockPos>)Either.right((Object)pos));
        }

        public static SoundSource of(TileEntity te) {
            return new SoundSource((Either<Entity, BlockPos>)Either.right((Object)te.func_174877_v()));
        }

        public static SoundSource fromBytes(PacketBuffer buf) {
            SourceType type = (SourceType)buf.func_179257_a(SourceType.class);
            return type.getSource(buf);
        }

        void toBytes(PacketBuffer buf) {
            this.entityOrPos.ifLeft(id -> {
                buf.func_179249_a((Enum)SourceType.ENTITY);
                buf.writeInt(id.func_145782_y());
            }).ifRight(pos -> {
                buf.func_179249_a((Enum)SourceType.STATIC_POS);
                buf.func_179255_a(pos);
            });
        }

        public void handle(MovingSounds.Sound sound) {
            this.entityOrPos.ifLeft(e -> MovingSounds.playMovingSound(sound, e, new Object[0])).ifRight(pos -> MovingSounds.playMovingSound(sound, pos, new Object[0]));
        }

        public Either<Entity, BlockPos> asEntityOrPos() {
            return this.entityOrPos;
        }
    }

    private static enum SourceType {
        ENTITY(buf -> SoundSource.of(buf.readInt())),
        STATIC_POS(buf -> SoundSource.of(buf.func_179259_c()));

        private final Function<PacketBuffer, SoundSource> creator;

        private SourceType(Function<PacketBuffer, SoundSource> creator) {
            this.creator = creator;
        }

        public SoundSource getSource(PacketBuffer buf) {
            return this.creator.apply(buf);
        }
    }
}

