/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.ItemGPSAreaTool;
import me.desht.pneumaticcraft.common.item.ItemGPSTool;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketChangeGPSToolCoordinate
extends LocationIntPacket {
    private final Hand hand;
    private final String variable;
    private final int index;

    public PacketChangeGPSToolCoordinate(BlockPos pos, Hand hand, String variable, int index) {
        super(pos);
        this.hand = hand;
        this.variable = variable;
        this.index = index;
    }

    public PacketChangeGPSToolCoordinate(PacketBuffer buf) {
        super(buf);
        this.variable = buf.func_150789_c(Short.MAX_VALUE);
        this.index = buf.readByte();
        this.hand = buf.readBoolean() ? Hand.MAIN_HAND : Hand.OFF_HAND;
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        super.toBytes(buf);
        buf.func_180714_a(this.variable);
        buf.writeByte(this.index);
        buf.writeBoolean(this.hand == Hand.MAIN_HAND);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            ItemStack playerStack = player.func_184586_b(this.hand);
            if (playerStack.func_77973_b() == ModItems.GPS_TOOL.get()) {
                ItemGPSTool.setVariable(playerStack, this.variable);
                if (this.pos.func_177956_o() >= 0) {
                    ItemGPSTool.setGPSLocation(playerStack, this.pos);
                }
            } else if (playerStack.func_77973_b() == ModItems.GPS_AREA_TOOL.get()) {
                ItemGPSAreaTool.setVariable(playerStack, this.variable, this.index);
                if (this.pos.func_177956_o() >= 0) {
                    ItemGPSAreaTool.setGPSPosAndNotify((PlayerEntity)player, this.pos, this.hand, this.index);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

