/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.block.BlockAphorismTile;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAphorismTile;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.Property;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketAphorismTileUpdate
extends LocationIntPacket {
    private static final int MAX_LENGTH = 1024;
    private final String[] text;
    private final int textRotation;
    private final byte margin;
    private final boolean invis;

    public PacketAphorismTileUpdate(PacketBuffer buffer) {
        super(buffer);
        this.textRotation = buffer.readByte();
        int lines = buffer.func_150792_a();
        this.text = new String[lines];
        for (int i = 0; i < lines; ++i) {
            this.text[i] = buffer.func_150789_c(1024);
        }
        this.margin = buffer.readByte();
        this.invis = buffer.readBoolean();
    }

    public PacketAphorismTileUpdate(TileEntityAphorismTile tile) {
        super(tile.func_174877_v());
        this.text = tile.getTextLines();
        this.textRotation = tile.textRotation;
        this.margin = tile.getMarginSize();
        this.invis = (Boolean)tile.func_195044_w().func_177229_b((Property)BlockAphorismTile.INVISIBLE);
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        super.toBytes(buffer);
        buffer.writeByte(this.textRotation);
        buffer.func_150787_b(this.text.length);
        Arrays.stream(this.text).forEach(s -> buffer.func_211400_a(s, 1024));
        buffer.writeByte((int)this.margin);
        buffer.writeBoolean(this.invis);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlayerEntity player = (PlayerEntity)Objects.requireNonNull(((NetworkEvent.Context)ctx.get()).getSender());
            if (PneumaticCraftUtils.canPlayerReach(player, this.pos)) {
                PneumaticCraftUtils.getTileEntityAt((IBlockReader)player.field_70170_p, this.pos, TileEntityAphorismTile.class).ifPresent(te -> {
                    te.setTextLines(this.text, false);
                    te.textRotation = this.textRotation;
                    te.setMarginSize(this.margin);
                    te.setInvisible(this.invis);
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

