/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemSeismicSensor
extends Item {
    private static final int MAX_SEARCH = 500;
    private static final Set<ResourceLocation> fluidsOfInterest = new HashSet<ResourceLocation>();
    private static boolean needRecache = true;

    public ItemSeismicSensor() {
        super(ModItems.defaultProps().func_200917_a(1));
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        PlayerEntity player = ctx.func_195999_j();
        if (!world.field_72995_K && player != null) {
            BlockPos.Mutable searchPos = ctx.func_195995_a().func_239590_i_();
            while (searchPos.func_177956_o() > PneumaticCraftUtils.getMinHeight(world)) {
                searchPos.func_189536_c(Direction.DOWN);
                Fluid fluid = this.findFluid(world, (BlockPos)searchPos);
                if (fluid == null) continue;
                Set<BlockPos> fluidPositions = this.findLake(world, searchPos.func_185334_h(), fluid);
                int count = Math.max(1, fluidPositions.size() / 10 * 10);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pneumaticcraft.message.seismicSensor.foundOilDetails", new Object[]{new TranslationTextComponent(fluid.getAttributes().getTranslationKey()), TextFormatting.GREEN.toString() + (ctx.func_195995_a().func_177956_o() - searchPos.func_177956_o()), TextFormatting.GREEN.toString() + count}), false);
                world.func_184133_a(null, ctx.func_195995_a(), SoundEvents.field_193808_ex, SoundCategory.PLAYERS, 1.0f, 1.0f);
                return ActionResultType.SUCCESS;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("pneumaticcraft.message.seismicSensor.noOilFound"), false);
        }
        return ActionResultType.SUCCESS;
    }

    private Fluid findFluid(World world, BlockPos pos) {
        FluidState state;
        if (needRecache) {
            fluidsOfInterest.clear();
            Set tagsFromConfig = ((List)ConfigHelper.common().machines.seismicSensorFluidTags.get()).stream().map(ResourceLocation::new).collect(Collectors.toSet());
            Set fluidsFromConfig = ((List)ConfigHelper.common().machines.seismicSensorFluids.get()).stream().map(ResourceLocation::new).collect(Collectors.toSet());
            for (Fluid f : ForgeRegistries.FLUIDS.getValues()) {
                if (!Sets.intersection((Set)f.getTags(), tagsFromConfig).isEmpty()) {
                    fluidsOfInterest.add(f.getRegistryName());
                    continue;
                }
                if (!fluidsFromConfig.contains(f.getRegistryName())) continue;
                fluidsOfInterest.add(f.getRegistryName());
            }
            needRecache = false;
        }
        return fluidsOfInterest.contains((state = world.func_204610_c(pos)).func_206886_c().getRegistryName()) ? state.func_206886_c() : null;
    }

    private Set<BlockPos> findLake(World world, BlockPos searchPos, Fluid fluid) {
        HashSet<BlockPos> fluidPositions = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> pendingPositions = new ArrayDeque<BlockPos>();
        pendingPositions.add(searchPos);
        while (!pendingPositions.isEmpty() && fluidPositions.size() < 500) {
            BlockPos checkingPos = (BlockPos)pendingPositions.pop();
            for (Direction d : Direction.values()) {
                BlockPos newPos;
                FluidState state;
                if (d == Direction.UP || (state = world.func_204610_c(newPos = checkingPos.func_177972_a(d))).func_206886_c() != fluid || !state.func_206889_d() || !fluidPositions.add(newPos)) continue;
                pendingPositions.add(newPos);
            }
        }
        return fluidPositions;
    }

    public static void clearCachedFluids() {
        needRecache = true;
    }
}

