/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.pressure.IPressurizableItem;
import me.desht.pneumaticcraft.common.capabilities.AirHandlerItemStack;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemPressurizable
extends Item
implements IPressurizableItem,
IVanishable {
    private final int volume;
    private final float maxPressure;

    public ItemPressurizable(int maxAir, int volume) {
        this(ModItems.defaultProps(), maxAir, volume);
    }

    public ItemPressurizable(Item.Properties props, int maxAir, int volume) {
        super(props);
        this.volume = volume;
        this.maxPressure = (float)maxAir / (float)volume;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ItemPressurizable.shouldShowPressureDurability(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return ItemPressurizable.getPressureDurabilityColor(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(h -> Float.valueOf(1.0f - h.getPressure() / h.maxPressure())).orElse(Float.valueOf(1.0f)).floatValue();
    }

    static int getPressureDurabilityColor(ItemStack stack) {
        return stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(airHandler -> {
            float f = airHandler.getPressure() / airHandler.maxPressure();
            int c = (int)(64.0f + 191.0f * f);
            return 0x400000 | c << 8 | 0xFF;
        }).orElse(0xC0C0C0);
    }

    static boolean shouldShowPressureDurability(ItemStack stack) {
        return stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(airHandler -> airHandler.getPressure() < airHandler.maxPressure()).orElse(false);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack((IItemProvider)this));
            ItemStack stack = new ItemStack((IItemProvider)this);
            new AirHandlerItemStack(stack, this.maxPressure).addAir((int)((float)this.volume * this.maxPressure));
            items.add((Object)stack);
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return stack.func_77973_b() instanceof ItemPressurizable ? new AirHandlerItemStack(stack, this.maxPressure) : super.initCapabilities(stack, nbt);
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        return ItemPressurizable.roundedPressure(stack);
    }

    @Override
    public int getBaseVolume() {
        return this.volume;
    }

    @Override
    public int getVolumeUpgrades(ItemStack stack) {
        return UpgradableItemUtils.getUpgrades(stack, EnumUpgrade.VOLUME);
    }

    @Override
    public int getAir(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        return tag != null ? tag.func_74762_e("pneumaticcraft:air") : 0;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int func_77619_b() {
        return 9;
    }

    public static CompoundNBT roundedPressure(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (stack.func_77973_b() instanceof IPressurizableItem && tag != null && tag.func_74764_b("pneumaticcraft:air")) {
            int air = tag.func_74762_e("pneumaticcraft:air");
            CompoundNBT tag2 = PneumaticCraftUtils.copyNBTWithout(tag, "pneumaticcraft:air");
            int volume = ((IPressurizableItem)stack.func_77973_b()).getEffectiveVolume(stack);
            tag2.func_74768_a("pneumaticcraft:air", air - air % (volume / (Integer)ConfigHelper.common().advanced.pressureSyncPrecision.get()));
            return tag2;
        }
        return tag;
    }
}

