/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat.behaviour;

import me.desht.pneumaticcraft.api.heat.HeatBehaviour;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.heat.HeatExchangerManager;
import me.desht.pneumaticcraft.common.heat.HeatExtractionTracker;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourLiquid;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public abstract class HeatBehaviourTransition
extends HeatBehaviourLiquid {
    private double maxExchangedHeat;
    private double blockTemp = -1.0;
    private LazyOptional<IHeatExchangerLogic> logic;
    private HeatExtractionTracker tracker;

    @Override
    public boolean isApplicable() {
        this.logic = HeatExchangerManager.getInstance().getLogic(this.getWorld(), this.getPos(), null);
        return this.logic.isPresent();
    }

    @Override
    public HeatBehaviour<?> initialize(IHeatExchangerLogic connectedHeatLogic, World world, BlockPos pos, Direction direction) {
        super.initialize(connectedHeatLogic, world, pos, direction);
        this.tracker = HeatExtractionTracker.getInstance(this.getWorld());
        return this;
    }

    protected abstract int getMaxExchangedHeat();

    protected boolean transformBlockHot() {
        return false;
    }

    protected boolean transformBlockCold() {
        return false;
    }

    @Override
    public void tick() {
        double extractedHeat;
        if (this.blockTemp == -1.0) {
            this.logic.ifPresent(exchanger -> {
                this.blockTemp = exchanger.getTemperature();
                this.maxExchangedHeat = (double)this.getMaxExchangedHeat() * (exchanger.getThermalResistance() + this.getHeatExchanger().getThermalResistance());
            });
        }
        if ((extractedHeat = this.tracker.getHeatExtracted(this.getPos())) < Math.abs(this.maxExchangedHeat)) {
            double toExtract = this.blockTemp - this.getHeatExchanger().getTemperature();
            this.tracker.extractHeat(this.getPos(), toExtract);
            extractedHeat += toExtract;
        }
        if (extractedHeat >= this.maxExchangedHeat) {
            if (this.transformBlockCold()) {
                this.tracker.extractHeat(this.getPos(), -this.maxExchangedHeat);
            }
        } else if (extractedHeat <= -this.maxExchangedHeat && this.transformBlockHot()) {
            this.tracker.extractHeat(this.getPos(), this.maxExchangedHeat);
        }
    }

    void onTransition(BlockPos pos) {
        this.getWorld().func_184133_a(null, pos, SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 0.5f, 2.6f + (this.getWorld().field_73012_v.nextFloat() - this.getWorld().field_73012_v.nextFloat()) * 0.8f);
        NetworkHandler.sendToAllTracking(new PacketSpawnParticle((IParticleData)ParticleTypes.field_197601_L, pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p(), 0.0, 0.0, 0.0, 8, 1.0, 0.0, 1.0), this.getWorld(), pos);
    }

    public double getExtractionProgress() {
        return this.maxExchangedHeat == 0.0 ? 0.0 : this.tracker.getHeatExtracted(this.getPos()) / this.maxExchangedHeat;
    }
}

