/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;

public enum TemperatureCategory implements IStringSerializable
{
    SUPER_COLD(0, "super_cold"),
    VERY_COLD(1, "very_cold"),
    COLD(2, "cold"),
    COOL(3, "cool"),
    NORMAL(4, "normal"),
    WARM(5, "warm"),
    HOT(6, "hot"),
    VERY_HOT(7, "very_hot"),
    SUPER_HOT(8, "super_hot");

    private final int index;
    private final String name;

    private TemperatureCategory(int index, String name) {
        this.index = index;
        this.name = name;
    }

    public static TemperatureCategory forTemperature(double temp) {
        if (temp < 73.0) {
            return SUPER_COLD;
        }
        if (temp < 213.0) {
            return VERY_COLD;
        }
        if (temp < 263.0) {
            return COLD;
        }
        if (temp < 283.0) {
            return COOL;
        }
        if (temp < 323.0) {
            return NORMAL;
        }
        if (temp < 373.0) {
            return WARM;
        }
        if (temp < 773.0) {
            return HOT;
        }
        if (temp < 1273.0) {
            return VERY_HOT;
        }
        return SUPER_HOT;
    }

    public String func_176610_l() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public ResourceLocation getTextureName(String base) {
        return Textures.modelTexture(base + "_" + this.name + ".png");
    }
}

