/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking.secstation;

import java.util.ArrayList;
import me.desht.pneumaticcraft.common.hacking.secstation.HackSimulation;
import me.desht.pneumaticcraft.common.hacking.secstation.ISimulationController;
import me.desht.pneumaticcraft.common.inventory.ContainerSecurityStationHacking;
import me.desht.pneumaticcraft.common.item.ItemNetworkComponent;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncHackSimulationUpdate;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySecurityStation;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.tuple.Pair;

public class SimulationController
implements ISimulationController {
    private final TileEntitySecurityStation te;
    private final PlayerEntity hacker;
    private final HackSimulation playerSimulation;
    private final HackSimulation aiSimulation;
    private final boolean justTesting;

    public SimulationController(TileEntitySecurityStation te, PlayerEntity hacker, boolean justTesting) {
        this.te = te;
        this.hacker = hacker;
        this.playerSimulation = new HackSimulation(this, te.findComponent(ItemNetworkComponent.NetworkComponentType.NETWORK_IO_PORT), 0.02f, ISimulationController.HackingSide.PLAYER);
        this.aiSimulation = new HackSimulation(this, te.findComponent(ItemNetworkComponent.NetworkComponentType.DIAGNOSTIC_SUBROUTINE), 0.03f, ISimulationController.HackingSide.AI);
        for (int i = 0; i < te.getPrimaryInventory().getSlots(); ++i) {
            this.playerSimulation.addNode(i, te.getPrimaryInventory().getStackInSlot(i));
            this.aiSimulation.addNode(i, te.getPrimaryInventory().getStackInSlot(i));
        }
        this.justTesting = justTesting;
    }

    public SimulationController(TileEntitySecurityStation te, PlayerEntity hacker, HackSimulation playerSimulation, HackSimulation aiSimulation, boolean justTesting) {
        this.te = te;
        this.hacker = hacker;
        this.playerSimulation = playerSimulation.setController(this);
        this.aiSimulation = aiSimulation.setController(this);
        this.justTesting = justTesting;
    }

    @Override
    public void onConnectionStarted(HackSimulation hackSimulation, int fromPos, int toPos, float initialProgress) {
    }

    @Override
    public boolean isJustTesting() {
        return this.justTesting;
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.func_179255_a(this.te.func_174877_v());
        this.playerSimulation.writeToNetwork(buffer);
        this.aiSimulation.writeToNetwork(buffer);
        ArrayList<Pair> nodes = new ArrayList<Pair>();
        for (int i = 0; i < this.te.getPrimaryInventory().getSlots(); ++i) {
            ItemStack stack = this.te.getPrimaryInventory().getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            nodes.add(Pair.of((Object)i, (Object)stack));
        }
        buffer.func_150787_b(nodes.size());
        nodes.forEach(pair -> {
            buffer.func_150787_b(((Integer)pair.getLeft()).intValue());
            buffer.func_150788_a((ItemStack)pair.getRight());
        });
        buffer.writeBoolean(this.justTesting);
    }

    @Override
    public void onNodeHacked(HackSimulation hackSimulation, int pos) {
        if (hackSimulation.getSide() == ISimulationController.HackingSide.PLAYER && !this.aiSimulation.isAwake()) {
            this.maybeWakeAI();
        }
    }

    @Override
    public void onNodeFortified(HackSimulation hackSimulation, int pos) {
        if (hackSimulation.getSide() == ISimulationController.HackingSide.PLAYER && !this.aiSimulation.isAwake()) {
            this.maybeWakeAI();
        }
    }

    private void maybeWakeAI() {
        if (!this.te.func_145831_w().field_72995_K && this.aiSimulation.isStarted() && this.te.func_145831_w().field_73012_v.nextInt(100) < this.te.getDetectionChance()) {
            this.aiSimulation.wakeUp();
        }
    }

    @Override
    public void tick() {
        boolean syncToClient;
        if (this.te.func_145837_r() || !this.hacker.func_70089_S()) {
            return;
        }
        boolean wasDone = this.isSimulationDone();
        if (!(this.hacker.field_71070_bA instanceof ContainerSecurityStationHacking) && !this.playerSimulation.isHackComplete()) {
            for (int slot = 0; slot < 35; ++slot) {
                if (ItemNetworkComponent.getType(this.te.getPrimaryInventory().getStackInSlot(slot)) != ItemNetworkComponent.NetworkComponentType.NETWORK_IO_PORT) continue;
                this.aiSimulation.getNodeAt(slot).setHackProgress(slot, 1.0f, true);
                break;
            }
        } else if (!wasDone) {
            this.playerSimulation.tick();
            this.aiSimulation.tick();
        }
        boolean bl = syncToClient = (this.te.func_145831_w().func_82737_E() & 7L) == 0L;
        if (!wasDone && this.aiSimulation.isHackComplete()) {
            syncToClient = true;
            if (this.aiSimulation.isAwake()) {
                if (this.te.func_145831_w().field_72995_K) {
                    this.hacker.func_184185_a(SoundEvents.field_187530_aT, 1.0f, 1.0f);
                } else {
                    this.hacker.func_146105_b((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.hackFailed.1", new Object[0]).func_240699_a_(TextFormatting.RED), false);
                    if (!this.justTesting) {
                        this.hacker.func_146105_b((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.hackFailed.2", new Object[0]).func_240699_a_(TextFormatting.RED), false);
                        this.te.retaliate(this.hacker);
                    }
                }
            }
        } else if (!wasDone && this.playerSimulation.isHackComplete()) {
            syncToClient = true;
            if (this.te.func_145831_w().field_72995_K) {
                this.hacker.func_184185_a(SoundEvents.field_187802_ec, 1.0f, 1.0f);
            } else {
                this.hacker.func_146105_b((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.hackSucceeded.1", new Object[0]).func_240699_a_(TextFormatting.GREEN), false);
                if (!this.justTesting) {
                    this.hacker.func_146105_b((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.hackSucceeded.2", new Object[0]).func_240699_a_(TextFormatting.GREEN), false);
                    this.te.addHacker(this.hacker.func_146103_bH());
                }
            }
        }
        if (!this.te.func_145831_w().func_201670_d() && syncToClient) {
            NetworkHandler.sendToPlayer(new PacketSyncHackSimulationUpdate(this.te), (ServerPlayerEntity)this.hacker);
        }
    }

    @Override
    public boolean isSimulationDone() {
        return this.te.func_145837_r() || !this.hacker.func_70089_S() || this.aiSimulation.isHackComplete() || this.playerSimulation.isHackComplete();
    }

    @Override
    public HackSimulation getSimulation(ISimulationController.HackingSide side) {
        return side == ISimulationController.HackingSide.PLAYER ? this.playerSimulation : this.aiSimulation;
    }

    @Override
    public PlayerEntity getHacker() {
        return this.hacker;
    }
}

