/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.event;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableBlock;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public enum HackTickHandler {
    INSTANCE;

    private final Map<ResourceLocation, Map<BlockPos, IHackableBlock>> hackedBlocks = new HashMap<ResourceLocation, Map<BlockPos, IHackableBlock>>();
    private final Map<ResourceLocation, Set<Entity>> hackedEntities = new HashMap<ResourceLocation, Set<Entity>>();

    public static HackTickHandler instance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ResourceLocation worldKey = this.getKey(event.world);
            if (this.hackedBlocks.containsKey(worldKey)) {
                this.hackedBlocks.get(worldKey).entrySet().removeIf(entry -> !((IHackableBlock)entry.getValue()).afterHackTick((IBlockReader)event.world, (BlockPos)entry.getKey()));
            }
            if (this.hackedEntities.containsKey(worldKey)) {
                Set<Entity> entities = this.hackedEntities.get(worldKey);
                entities.forEach(entity -> entity.getCapability(PNCCapabilities.HACKING_CAPABILITY).ifPresent(hacking -> {
                    if (entity.func_70089_S() && !hacking.getCurrentHacks().isEmpty()) {
                        hacking.update((Entity)entity);
                    }
                }));
                entities.removeIf(e -> !e.func_70089_S() || e.getCapability(PNCCapabilities.HACKING_CAPABILITY).map(hacking -> hacking.getCurrentHacks().isEmpty()).orElse(true) != false);
            }
        }
    }

    public void trackBlock(World world, BlockPos pos, IHackableBlock iHackable) {
        this.hackedBlocks.computeIfAbsent(this.getKey(world), k1 -> new HashMap()).put(pos, iHackable);
    }

    public void trackEntity(Entity entity, IHackableEntity iHackable) {
        if (iHackable.getHackableId() != null) {
            entity.getCapability(PNCCapabilities.HACKING_CAPABILITY).ifPresent(hacking -> {
                hacking.addHackable(iHackable);
                this.hackedEntities.computeIfAbsent(this.getKey(entity.field_70170_p), k -> new HashSet()).add(entity);
            });
        }
    }

    private ResourceLocation getKey(World w) {
        return w.func_234923_W_().func_240901_a_();
    }
}

