/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.debug;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.debug.DroneDebugEntry;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSendDroneDebugEntry;
import me.desht.pneumaticcraft.common.network.PacketSyncDroneEntityProgWidgets;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSpawnParticlePacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class DroneDebugger {
    private final IDroneBase drone;
    private final DroneDebugList debugList = new DroneDebugList();
    private final Set<ServerPlayerEntity> debuggingPlayers = new HashSet<ServerPlayerEntity>();

    public DroneDebugger(IDroneBase drone) {
        this.drone = drone;
    }

    public DroneDebugEntry getDebugEntry(int widgetID) {
        return this.debugList.get(widgetID);
    }

    public void addEntry(String message) {
        this.addEntry(message, null);
    }

    public void addEntry(String message, BlockPos pos) {
        DroneDebugEntry entry = new DroneDebugEntry(message, this.getActiveWidgetIndex(), pos);
        this.addEntry(entry);
        PacketSendDroneDebugEntry packet = new PacketSendDroneDebugEntry(entry, this.drone);
        for (ServerPlayerEntity player : this.debuggingPlayers) {
            NetworkHandler.sendToPlayer(packet, player);
        }
    }

    public void addEntry(DroneDebugEntry entry) {
        this.debugList.addEntry(entry);
    }

    public void trackAsDebugged(ServerPlayerEntity player) {
        NetworkHandler.sendToPlayer(new PacketSyncDroneEntityProgWidgets(this.drone), player);
        for (DroneDebugEntry entry : this.debugList.getAll()) {
            NetworkHandler.sendToPlayer(new PacketSendDroneDebugEntry(entry, this.drone), player);
        }
        this.debuggingPlayers.add(player);
    }

    public void updateDebuggingPlayers() {
        this.debuggingPlayers.removeIf(player -> !player.func_70089_S() || !ItemPneumaticArmor.isPlayerDebuggingDrone((PlayerEntity)player, this.drone));
    }

    public Collection<ServerPlayerEntity> getDebuggingPlayers() {
        return this.debuggingPlayers;
    }

    private int getActiveWidgetIndex() {
        return this.drone.getActiveWidgetIndex();
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
            Path path;
            if (!((Boolean)ConfigHelper.common().general.droneDebuggerPathParticles.get()).booleanValue() || !(event.getEntityLiving() instanceof EntityDrone) || event.getEntityLiving().field_70170_p.field_72995_K) {
                return;
            }
            EntityDrone drone = (EntityDrone)event.getEntityLiving();
            if (drone.getDebugger().debuggingPlayers.isEmpty()) {
                return;
            }
            PathNavigator navi = drone.func_70661_as();
            if (drone.field_70170_p instanceof ServerWorld && drone.field_70170_p.func_82737_E() % 10L == 0L && (path = navi.func_75505_d()) != null) {
                for (int i = path.func_75873_e(); i < path.func_75874_d(); ++i) {
                    BlockPos pos = path.func_75877_a(i).func_224759_a();
                    BlockPos nextPos = i + 1 != path.func_75874_d() ? path.func_75877_a(i + 1).func_224759_a() : pos;
                    BlockPos endPos = nextPos.func_177973_b((Vector3i)pos);
                    Listener.spawnParticle(drone.getDebugger().debuggingPlayers, ParticleTypes.field_197632_y, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0, 0.0, 0.0, 0.0, 0.0);
                    Listener.spawnParticle(drone.getDebugger().debuggingPlayers, ParticleTypes.field_197624_q, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0, endPos.func_177958_n(), endPos.func_177956_o(), endPos.func_177952_p(), 0.1);
                }
                BlockPos pos = navi.func_208485_j();
                if (pos != null && drone.getDronePos().func_72436_e(Vector3d.func_237489_a_((Vector3i)pos)) > 1.0) {
                    Listener.spawnParticle(drone.getDebugger().debuggingPlayers, ParticleTypes.field_197633_z, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }

        private static <T extends IParticleData> void spawnParticle(Set<ServerPlayerEntity> players, T type, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
            SSpawnParticlePacket packet = new SSpawnParticlePacket(type, false, posX, posY, posZ, (float)xOffset, (float)yOffset, (float)zOffset, (float)speed, particleCount);
            players.forEach(player -> player.field_71135_a.func_147359_a((IPacket)packet));
        }
    }

    private class DroneDebugList {
        private final Map<Integer, DroneDebugEntry> debugEntries = new HashMap<Integer, DroneDebugEntry>();

        private DroneDebugList() {
        }

        void addEntry(DroneDebugEntry entry) {
            this.debugEntries.put(DroneDebugger.this.getActiveWidgetIndex(), entry);
        }

        public Collection<DroneDebugEntry> getAll() {
            return this.debugEntries.values();
        }

        public DroneDebugEntry get(int widgetId) {
            return this.debugEntries.get(widgetId);
        }

        public DroneDebugEntry getCurrent() {
            return this.debugEntries.get(DroneDebugger.this.getActiveWidgetIndex());
        }
    }
}

