/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.config.subconfig;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Set;
import me.desht.pneumaticcraft.common.config.subconfig.AuxConfigJson;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;

public class ArmorFeatureStatus
extends AuxConfigJson {
    private final Set<ResourceLocation> activeUpgrades = Sets.newHashSet();
    public static final ArmorFeatureStatus INSTANCE = new ArmorFeatureStatus();

    private ArmorFeatureStatus() {
        super(true);
    }

    @Override
    public String getConfigFilename() {
        return "ArmorFeatureStatus";
    }

    @Override
    protected void writeToJson(JsonObject json) {
        json.addProperty("description", "Tracks the active upgrades for the Pneumatic Armor (clientside)");
        JsonArray array = new JsonArray();
        if (this.activeUpgrades.isEmpty()) {
            this.activeUpgrades.add(ArmorUpgradeRegistry.getInstance().coreComponentsHandler.getID());
        }
        for (ResourceLocation s : this.activeUpgrades) {
            array.add(s.toString());
        }
        json.add("active", (JsonElement)array);
    }

    @Override
    protected void readFromJson(JsonObject json) {
        JsonArray array = json.get("active").getAsJsonArray();
        this.activeUpgrades.clear();
        for (JsonElement element : array) {
            try {
                this.activeUpgrades.add(new ResourceLocation(element.getAsString()));
            }
            catch (ResourceLocationException e) {
                Log.error("ignoring " + element.getAsString() + " in ArmorFeatureStatus.json: " + e.getMessage(), new Object[0]);
            }
        }
    }

    public void setUpgradeEnabled(ResourceLocation upgradeID, boolean enabled) {
        if (enabled) {
            this.activeUpgrades.add(upgradeID);
        } else {
            this.activeUpgrades.remove(upgradeID);
        }
    }

    public boolean isUpgradeEnabled(ResourceLocation upgradeID) {
        return this.activeUpgrades.contains(upgradeID);
    }
}

