/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.config;

import me.desht.pneumaticcraft.client.pneumatic_armor.ArmorUpgradeClientRegistry;
import me.desht.pneumaticcraft.common.config.ClientConfig;
import me.desht.pneumaticcraft.common.config.CommonConfig;
import me.desht.pneumaticcraft.common.item.ItemSeismicSensor;
import me.desht.pneumaticcraft.common.tileentity.TileEntityVacuumTrap;
import me.desht.pneumaticcraft.common.worldgen.ModWorldGen;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHolder {
    static ClientConfig client;
    static CommonConfig common;
    private static ForgeConfigSpec configCommonSpec;
    private static ForgeConfigSpec configClientSpec;

    public static void init() {
        Pair spec1 = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        client = (ClientConfig)spec1.getLeft();
        configClientSpec = (ForgeConfigSpec)spec1.getRight();
        Pair spec2 = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        common = (CommonConfig)spec2.getLeft();
        configCommonSpec = (ForgeConfigSpec)spec2.getRight();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, configCommonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, configClientSpec);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ConfigHolder::onConfigChanged);
    }

    private static void onConfigChanged(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == configClientSpec) {
            ConfigHolder.refreshClient();
        } else if (config.getSpec() == configCommonSpec) {
            ConfigHolder.refreshCommon();
        }
    }

    static void refreshClient() {
        ArmorUpgradeClientRegistry.getInstance().refreshConfig();
    }

    static void refreshCommon() {
        TileEntityVacuumTrap.clearBlacklistCache();
        ModWorldGen.clearBlacklistCache();
        ItemSeismicSensor.clearCachedFluids();
    }
}

