/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.capabilities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.pressure.IPressurizableItem;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.Validate;

public class AirHandlerItemStack
extends IAirHandlerItem.Provider {
    public static final String AIR_NBT_KEY = "pneumaticcraft:air";
    private final LazyOptional<IAirHandlerItem> holder = LazyOptional.of(() -> this);
    private final ItemStack container;
    private final IPressurizableItem pressurizable;
    private int baseVolume;
    private final float maxPressure;

    public AirHandlerItemStack(ItemStack container, float maxPressure) {
        Validate.isTrue((boolean)(container.func_77973_b() instanceof IPressurizableItem), (String)("itemstack " + container + " must be an IPressurizableItem!"), (Object[])new Object[0]);
        this.container = container;
        this.pressurizable = (IPressurizableItem)container.func_77973_b();
        this.baseVolume = this.pressurizable.getBaseVolume();
        this.maxPressure = maxPressure;
    }

    @Override
    @Nonnull
    public ItemStack getContainer() {
        return this.container;
    }

    @Override
    public float getPressure() {
        float pressure = this.pressurizable.getPressure(this.container);
        if (pressure > this.maxPressure) {
            this.container.func_196082_o().func_74768_a(AIR_NBT_KEY, (int)(this.maxPressure * (float)this.getVolume()));
            return this.maxPressure;
        }
        return pressure;
    }

    @Override
    public int getAir() {
        return this.pressurizable.getAir(this.container);
    }

    @Override
    public void addAir(int amount) {
        if (this.container.func_190916_E() != 1) {
            return;
        }
        int currentAir = this.getAir();
        int newAir = currentAir + amount;
        if (newAir != 0) {
            this.container.func_196082_o().func_74768_a(AIR_NBT_KEY, currentAir + amount);
        } else if (this.container.func_77942_o()) {
            this.container.func_77978_p().func_82580_o(AIR_NBT_KEY);
            if (this.container.func_77978_p().isEmpty()) {
                this.container.func_77982_d(null);
            }
        }
    }

    @Override
    public int getBaseVolume() {
        return this.baseVolume;
    }

    @Override
    public void setBaseVolume(int newBaseVolume) {
        this.baseVolume = newBaseVolume;
    }

    @Override
    public int getVolume() {
        return this.pressurizable.getEffectiveVolume(this.container);
    }

    @Override
    public float maxPressure() {
        return this.maxPressure;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY.orEmpty(cap, this.holder);
    }
}

