/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.stream.Stream;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.tileentity.TileEntityRefineryController;
import me.desht.pneumaticcraft.common.tileentity.TileEntityRefineryOutput;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockRefineryOutput
extends BlockPneumaticCraft {
    private static final VoxelShape SHAPE_N = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.func_208617_a((double)13.0, (double)11.0, (double)14.5, (double)14.5, (double)12.0, (double)15.5), Block.func_208617_a((double)12.0, (double)1.0, (double)14.0, (double)13.0, (double)13.0, (double)16.0), Block.func_208617_a((double)3.0, (double)1.0, (double)14.0, (double)4.0, (double)13.0, (double)16.0), Block.func_208617_a((double)1.5, (double)11.0, (double)14.5, (double)3.0, (double)12.0, (double)15.5), Block.func_208617_a((double)0.0, (double)10.0, (double)14.0, (double)2.0, (double)13.0, (double)16.0), Block.func_208617_a((double)14.0, (double)10.0, (double)14.0, (double)16.0, (double)13.0, (double)16.0), Block.func_208617_a((double)14.5, (double)1.0, (double)14.5, (double)15.5, (double)15.0, (double)15.5), Block.func_208617_a((double)14.5, (double)1.0, (double)0.5, (double)15.5, (double)15.0, (double)1.5), Block.func_208617_a((double)14.0, (double)10.0, (double)0.0, (double)16.0, (double)13.0, (double)2.0), Block.func_208617_a((double)1.5, (double)11.0, (double)0.5, (double)14.5, (double)12.0, (double)1.5), Block.func_208617_a((double)2.0, (double)1.0, (double)1.0, (double)14.0, (double)16.0, (double)13.0), Block.func_208617_a((double)4.0, (double)1.0, (double)13.0, (double)12.0, (double)14.0, (double)16.0), Block.func_208617_a((double)0.0, (double)15.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.func_208617_a((double)0.0, (double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)3.0), Block.func_208617_a((double)0.0, (double)15.0, (double)6.0, (double)1.0, (double)16.0, (double)15.0), Block.func_208617_a((double)15.0, (double)15.0, (double)1.0, (double)16.0, (double)16.0, (double)7.0), Block.func_208617_a((double)15.0, (double)15.0, (double)11.0, (double)16.0, (double)16.0, (double)15.0), Block.func_208617_a((double)0.5, (double)11.0, (double)1.5, (double)1.5, (double)12.0, (double)14.5), Block.func_208617_a((double)0.5, (double)1.0, (double)0.5, (double)1.5, (double)15.0, (double)1.5), Block.func_208617_a((double)0.5, (double)1.0, (double)14.5, (double)1.5, (double)15.0, (double)15.5), Block.func_208617_a((double)0.0, (double)10.0, (double)0.0, (double)2.0, (double)13.0, (double)2.0), Block.func_208617_a((double)14.0, (double)14.0, (double)7.0, (double)16.0, (double)16.0, (double)11.0), Block.func_208617_a((double)13.25, (double)7.5, (double)9.25, (double)14.25, (double)9.5, (double)11.25), Block.func_208617_a((double)13.25, (double)7.5, (double)6.75, (double)14.25, (double)9.5, (double)8.75), Block.func_208617_a((double)0.0, (double)13.0, (double)3.0, (double)2.0, (double)16.0, (double)6.0), Block.func_208617_a((double)0.0, (double)3.5, (double)3.0, (double)2.0, (double)5.5, (double)6.0), Block.func_208617_a((double)13.5, (double)8.0, (double)7.25, (double)15.5, (double)9.0, (double)8.25), Block.func_208617_a((double)13.5, (double)8.0, (double)9.75, (double)15.5, (double)9.0, (double)10.75), Block.func_208617_a((double)14.5, (double)1.0, (double)7.25, (double)15.5, (double)8.0, (double)8.25), Block.func_208617_a((double)14.5, (double)1.0, (double)9.75, (double)15.5, (double)8.0, (double)10.75), Block.func_208617_a((double)0.5, (double)1.0, (double)3.5, (double)2.5, (double)4.0, (double)5.5), Block.func_208617_a((double)14.5, (double)11.0, (double)1.5, (double)15.5, (double)12.0, (double)14.5)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape SHAPE_E = VoxelShapeUtils.rotateY(SHAPE_N, 90);
    private static final VoxelShape SHAPE_S = VoxelShapeUtils.rotateY(SHAPE_E, 90);
    private static final VoxelShape SHAPE_W = VoxelShapeUtils.rotateY(SHAPE_S, 90);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE_S, SHAPE_W, SHAPE_N, SHAPE_E};

    public BlockRefineryOutput() {
        super(ModBlocks.defaultProps());
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityRefineryOutput.class;
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult brtr) {
        return PneumaticCraftUtils.getTileEntityAt((IBlockReader)world, pos, TileEntityRefineryOutput.class).map(te -> {
            TileEntityRefineryController master;
            boolean canTransferFluid = FluidUtil.getFluidHandler((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)player.func_184586_b(hand), (int)1)).map(heldHandler -> FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (Direction)brtr.func_216354_b()).map(refineryHandler -> this.couldTransferFluidOut((IFluidHandler)heldHandler, (IFluidHandler)refineryHandler)).orElse(false)).orElse(false);
            if (canTransferFluid) {
                return super.func_225533_a_(state, world, pos, player, hand, brtr);
            }
            if (!world.field_72995_K && (master = te.getRefineryController()) != null) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)master, (BlockPos)master.func_174877_v());
            }
            return ActionResultType.SUCCESS;
        }).orElse(ActionResultType.PASS);
    }

    private boolean couldTransferFluidOut(IFluidHandler h1, IFluidHandler h2) {
        FluidStack f = FluidUtil.tryFluidTransfer((IFluidHandler)h1, (IFluidHandler)h2, (int)1000, (boolean)false);
        return !f.isEmpty();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction d = (Direction)state.func_177229_b((Property)this.directionProperty());
        return SHAPES[d.func_176736_b()];
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        int nOutputs = 0;
        int up = 1;
        int down = 1;
        while (worldIn.func_180495_p(pos.func_177981_b(up++)).func_177230_c() instanceof BlockRefineryOutput) {
            ++nOutputs;
        }
        while (worldIn.func_180495_p(pos.func_177979_c(down++)).func_177230_c() instanceof BlockRefineryOutput) {
            ++nOutputs;
        }
        return nOutputs < 4 && super.func_196260_a(state, worldIn, pos);
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!worldIn.func_201670_d() && facingState.func_177230_c() == ModBlocks.REFINERY_OUTPUT.get()) {
            this.recache(worldIn, currentPos);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private void recache(IWorld world, BlockPos pos) {
        PneumaticCraftUtils.getTileEntityAt((IBlockReader)world, pos, TileEntityRefineryOutput.class).ifPresent(te -> {
            TileEntityRefineryController teC = te.getRefineryController();
            if (teC != null) {
                teC.cacheRefineryOutputs();
            }
        });
    }
}

