/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import me.desht.pneumaticcraft.common.ai.ChunkPositionSorter;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.IAreaProvider;
import me.desht.pneumaticcraft.common.progwidgets.IGotoWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class DroneEntityAIGoToLocation
extends Goal {
    protected final IDroneBase drone;
    private final ProgWidget gotoWidget;
    private final ChunkPositionSorter positionSorter;
    private final List<BlockPos> validArea;

    public DroneEntityAIGoToLocation(IDroneBase drone, ProgWidget gotoWidget) {
        this.drone = drone;
        this.func_220684_a(EnumSet.allOf(Goal.Flag.class));
        this.gotoWidget = gotoWidget;
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        ((IAreaProvider)((Object)gotoWidget)).getArea(set);
        this.validArea = new ArrayList<BlockPos>(set);
        this.positionSorter = new ChunkPositionSorter(drone);
    }

    public boolean func_75250_a() {
        this.validArea.sort(this.positionSorter);
        for (BlockPos c : this.validArea) {
            Vector3d vector3d = new Vector3d((double)c.func_177958_n() + 0.5, (double)c.func_177956_o() + 0.5, (double)c.func_177952_p() + 0.5);
            if (this.drone.getDronePos().func_72436_e(vector3d) < 0.75) {
                return false;
            }
            if (!this.drone.getPathNavigator().moveToXYZ(c.func_177958_n(), c.func_177956_o(), c.func_177952_p())) continue;
            return !((IGotoWidget)((Object)this.gotoWidget)).doneWhenDeparting();
        }
        boolean teleport = this.drone.getPathNavigator().isGoingToTeleport();
        if (teleport) {
            return true;
        }
        for (BlockPos c : this.validArea) {
            this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.goto.debug.cantNavigate", c);
        }
        return false;
    }

    public boolean func_75253_b() {
        return !this.drone.getPathNavigator().hasNoPath();
    }
}

