/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.progwidgets.IEntityProvider;
import me.desht.pneumaticcraft.common.progwidgets.IMaxActions;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.player.PlayerEntity;

public class DroneAINearestAttackableTarget
extends TargetGoal {
    private final EntityDrone drone;
    private final ProgWidget widget;
    private final DistanceSorter distanceSorter;
    private LivingEntity targetEntity;

    public DroneAINearestAttackableTarget(EntityDrone drone, boolean checkSight, ProgWidget widget) {
        this(drone, checkSight, false, widget);
    }

    public DroneAINearestAttackableTarget(EntityDrone drone, boolean checkSight, boolean easyTargetsOnly, ProgWidget widget) {
        super((MobEntity)drone, checkSight, easyTargetsOnly);
        this.drone = drone;
        this.widget = widget;
        this.distanceSorter = new DistanceSorter((Entity)drone);
        this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean func_75250_a() {
        IMaxActions m;
        if (this.drone.hasMinigun() && this.drone.getSlotForAmmo() < 0) {
            return false;
        }
        if (this.widget instanceof IMaxActions && (m = (IMaxActions)((Object)this.widget)).useMaxActions() && this.drone.getAttackCount() >= m.getMaxActions()) {
            return false;
        }
        List<Entity> list = ((IEntityProvider)((Object)this.widget)).getValidEntities(this.drone.field_70170_p);
        list.sort(this.distanceSorter);
        for (Entity entity : list) {
            if (!entity.func_70089_S() || entity == this.field_75299_d || !(entity instanceof LivingEntity) || this.shouldIgnore(entity)) continue;
            this.targetEntity = (LivingEntity)entity;
            return true;
        }
        return false;
    }

    private boolean shouldIgnore(Entity entity) {
        return entity.func_175149_v() || entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_();
    }

    public void func_75249_e() {
        this.field_75299_d.func_70624_b(this.targetEntity);
        super.func_75249_e();
    }

    public static class DistanceSorter
    implements Comparator<Entity> {
        private final Entity entity;

        DistanceSorter(Entity entityIn) {
            this.entity = entityIn;
        }

        @Override
        public int compare(Entity e1, Entity e2) {
            return Double.compare(this.entity.func_70068_e(e1), this.entity.func_70068_e(e2));
        }
    }
}

