/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.util;

import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.programmer.GuiProgWidgetOptionBase;
import me.desht.pneumaticcraft.client.pneumatic_armor.ArmorUpgradeClientRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.EntityTrackerClientHandler;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class ClientUtils {
    public static void emitParticles(World world, BlockPos pos, IParticleData particle, double yOffset) {
        float xOff = world.field_73012_v.nextFloat() * 0.6f + 0.2f;
        float zOff = world.field_73012_v.nextFloat() * 0.6f + 0.2f;
        ClientUtils.getClientWorld().func_195594_a(particle, (double)((float)pos.func_177958_n() + xOff), (double)pos.func_177956_o() + yOffset, (double)((float)pos.func_177952_p() + zOff), 0.0, 0.0, 0.0);
    }

    public static void emitParticles(World world, BlockPos pos, IParticleData particle) {
        ClientUtils.emitParticles(world, pos, particle, 1.2);
    }

    @Nonnull
    public static ItemStack getWornArmor(EquipmentSlotType slot) {
        return Minecraft.func_71410_x().field_71439_g.func_184582_a(slot);
    }

    public static void addDroneToHudHandler(EntityDrone drone, BlockPos pos) {
        ArmorUpgradeClientRegistry.getInstance().getClientHandler(ArmorUpgradeRegistry.getInstance().entityTrackerHandler, EntityTrackerClientHandler.class).getTargetsStream().filter(target -> target.entity == drone).forEach(target -> target.getDroneAIRenderer().addBlackListEntry(drone.field_70170_p, pos));
    }

    public static boolean isKeyDown(int keyCode) {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)keyCode);
    }

    public static void openContainerGui(ContainerType<? extends Container> type, ITextComponent displayString) {
        ScreenManager.func_216909_a(type, (Minecraft)Minecraft.func_71410_x(), (int)-1, (ITextComponent)displayString);
    }

    public static void closeContainerGui(Screen parentScreen) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_147108_a(parentScreen);
        if (parentScreen instanceof ContainerScreen) {
            mc.field_71439_g.field_71070_bA = ((ContainerScreen)parentScreen).func_212873_a_();
        } else if (parentScreen instanceof GuiProgWidgetOptionBase) {
            mc.field_71439_g.field_71070_bA = ((GuiProgWidgetOptionBase)parentScreen).getProgrammerContainer();
        }
    }

    public static World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    public static PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static boolean hasShiftDown() {
        return Screen.func_231173_s_();
    }

    public static TileEntity getClientTE(BlockPos pos) {
        return Minecraft.func_71410_x().field_71441_e.func_175625_s(pos);
    }

    public static boolean intersects(Rectangle2d rect, double x, double y, double w, double h) {
        if (rect.func_199316_c() <= 0 || rect.func_199317_d() <= 0 || w <= 0.0 || h <= 0.0) {
            return false;
        }
        double x0 = rect.func_199318_a();
        double y0 = rect.func_199319_b();
        return x + w > x0 && y + h > y0 && x < x0 + (double)rect.func_199316_c() && y < y0 + (double)rect.func_199317_d();
    }

    public static boolean isScreenHiRes() {
        MainWindow mw = Minecraft.func_71410_x().func_228018_at_();
        return mw.func_198107_o() > 700 && mw.func_198087_p() > 512;
    }

    public static float getBrightnessAtWorldHeight() {
        PlayerEntity player = ClientUtils.getClientPlayer();
        BlockPos.Mutable pos = new BlockPos.Mutable(player.func_226277_ct_(), (double)ClientUtils.getClientWorld().func_217301_I(), player.func_226281_cx_());
        if (player.field_70170_p.func_175667_e((BlockPos)pos)) {
            return player.field_70170_p.func_230315_m_().func_236021_a_(player.field_70170_p.func_201696_r((BlockPos)pos));
        }
        return 0.0f;
    }

    public static int getLightAt(BlockPos pos) {
        return WorldRenderer.func_228421_a_((IBlockDisplayReader)Minecraft.func_71410_x().field_71441_e, (BlockPos)pos);
    }

    public static int getStringWidth(String line) {
        return Minecraft.func_71410_x().func_175598_ae().func_78716_a().func_78256_a(line);
    }

    public static boolean isGuiOpen(TileEntity te) {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiPneumaticContainerBase) {
            return ((GuiPneumaticContainerBase)Minecraft.func_71410_x().field_71462_r).te == te;
        }
        return false;
    }

    public static float[] getTextureUV(BlockState state, Direction face) {
        if (state == null) {
            return null;
        }
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        List quads = model.getQuads(state, face, Minecraft.func_71410_x().field_71441_e.field_73012_v, (IModelData)EmptyModelData.INSTANCE);
        if (!quads.isEmpty()) {
            TextureAtlasSprite sprite = ((BakedQuad)quads.get(0)).func_187508_a();
            return new float[]{sprite.func_94209_e(), sprite.func_94206_g(), sprite.func_94212_f(), sprite.func_94210_h()};
        }
        return null;
    }

    public static void spawnEntityClientside(Entity e) {
        ((ClientWorld)ClientUtils.getClientWorld()).func_217411_a(e.func_145782_y(), e);
    }

    public static String translateDirection(Direction d) {
        return I18n.func_135052_a((String)("pneumaticcraft.gui.tooltip.direction." + d.toString()), (Object[])new Object[0]);
    }

    public static ITextComponent translateDirectionComponent(Direction d) {
        return new TranslationTextComponent("pneumaticcraft.gui.tooltip.direction." + d.toString());
    }

    public static ITextComponent translateKeyBind(KeyBinding keyBinding) {
        return keyBinding.getKeyModifier().getCombinedName(keyBinding.getKey(), () -> {
            ITextComponent s = keyBinding.getKey().func_237520_d_();
            if (keyBinding.getKey().func_197938_b() == InputMappings.Type.KEYSYM && keyBinding.getKey().func_197937_c() >= 320 && keyBinding.getKey().func_197937_c() <= 336) {
                return new StringTextComponent("KP_").func_230529_a_(s);
            }
            return s;
        }).func_230532_e_().func_240699_a_(TextFormatting.YELLOW);
    }

    public static void addGuiContextSensitiveTooltip(ItemStack stack, List<ITextComponent> tooltip) {
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen != null) {
            String subKey = screen.getClass().getSimpleName().toLowerCase(Locale.ROOT);
            Item item = stack.func_77973_b();
            String base = item instanceof BlockItem ? "gui.tooltip.block" : "gui.tooltip.item";
            String k = String.join((CharSequence)".", base, item.getRegistryName().func_110624_b(), item.getRegistryName().func_110623_a(), subKey);
            if (I18n.func_188566_a((String)k)) {
                tooltip.addAll(GuiUtils.xlateAndSplit(k, new Object[0]).stream().map(s -> s.func_230532_e_().func_240699_a_(TextFormatting.GRAY)).collect(Collectors.toList()));
            }
        }
    }

    public static int getRenderDistanceThresholdSq() {
        int d = Minecraft.func_71410_x().field_71474_y.field_151451_c * 16;
        return d * d;
    }

    public static boolean isFirstPersonCamera() {
        return Minecraft.func_71410_x().field_71474_y.func_243230_g().func_243192_a();
    }
}

