/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.sound;

import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import net.minecraft.client.audio.TickableSound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;

public class MovingSoundJetBoots
extends TickableSound {
    private static final int END_TICKS = 20;
    private static final Vector3d IDLE_VEC = new Vector3d(0.0, -0.5, 0.0);
    private final PlayerEntity player;
    private final CommonArmorHandler handler;
    private float targetPitch;
    private int endTimer = Integer.MAX_VALUE;

    public MovingSoundJetBoots(PlayerEntity player) {
        super((SoundEvent)ModSounds.LEAKING_GAS_LOW.get(), SoundCategory.NEUTRAL);
        this.player = player;
        this.field_147659_g = true;
        this.field_147665_h = 0;
        this.targetPitch = 0.7f;
        this.field_147663_c = 0.5f;
        this.handler = CommonArmorHandler.getHandlerForPlayer(player);
        this.field_147662_b = this.volumeFromConfig(JetBootsStateTracker.getClientTracker().getJetBootsState(player).isBuilderMode());
        player.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_() + 0.1, player.func_226281_cx_());
    }

    public void func_73660_a() {
        if (!this.handler.isValid() || !this.handler.isArmorEnabled()) {
            return;
        }
        JetBootsStateTracker.JetBootsState jbState = JetBootsStateTracker.getClientTracker().getJetBootsState(this.player);
        if (this.endTimer == Integer.MAX_VALUE && (!jbState.isEnabled() || !jbState.isActive() && (this.player.func_233570_aj_() || this.player.func_184613_cA()))) {
            this.endTimer = 20;
        }
        if (this.endTimer <= 20) {
            this.endTimer = this.player.func_233570_aj_() || !jbState.isActive() ? --this.endTimer : Integer.MAX_VALUE;
        }
        this.field_147660_d = (float)this.player.func_226277_ct_();
        this.field_147661_e = (float)this.player.func_226278_cu_();
        this.field_147658_f = (float)this.player.func_226281_cx_();
        if (this.endTimer > 0 && this.endTimer <= 20) {
            this.targetPitch = 0.5f;
            this.field_147662_b = this.volumeFromConfig(jbState.isBuilderMode()) - (float)(20 - this.endTimer) / 50.0f;
        } else {
            if (jbState.isActive()) {
                double vel = this.player.func_213322_ci().func_72433_c();
                this.targetPitch = 0.9f + (float)vel / 15.0f;
                this.field_147662_b = this.volumeFromConfig(jbState.isBuilderMode()) + (float)vel / 15.0f;
            } else {
                this.targetPitch = 0.9f;
                this.field_147662_b = this.volumeFromConfig(jbState.isBuilderMode()) * 0.8f;
            }
            this.handleParticles(jbState.isActive(), jbState.isBuilderMode());
        }
        this.field_147663_c += (this.targetPitch - this.field_147663_c) / 10.0f;
        if (this.player.func_70090_H()) {
            this.field_147663_c *= 0.75f;
            this.field_147662_b *= 0.5f;
        }
    }

    public boolean func_147667_k() {
        return !this.handler.isValid() || !this.handler.isArmorEnabled() || this.endTimer <= 0;
    }

    private void handleParticles(boolean jetBootsActive, boolean builderMode) {
        int distThresholdSq = ClientUtils.getRenderDistanceThresholdSq();
        if ((jetBootsActive || (this.player.field_70170_p.func_82737_E() & 3L) == 0L || !ClientUtils.isFirstPersonCamera()) && this.player.func_70068_e((Entity)ClientUtils.getClientPlayer()) < (double)distThresholdSq) {
            Vector3d jetVec;
            int nParticles = jetBootsActive ? 3 : 1;
            Vector3d vector3d = jetVec = jetBootsActive && !builderMode ? this.player.func_70040_Z().func_186678_a(-0.5) : IDLE_VEC;
            Vector3d feet = jetBootsActive && !builderMode ? this.player.func_213303_ch().func_178787_e(this.player.func_70040_Z().func_186678_a(this.player == ClientUtils.getClientPlayer() ? -4.0 : -2.0)) : this.player.func_213303_ch().func_72441_c(0.0, -0.25, 0.0);
            for (int i = 0; i < nParticles; ++i) {
                this.player.field_70170_p.func_195594_a((IParticleData)AirParticleData.DENSE, feet.field_72450_a, feet.field_72448_b, feet.field_72449_c, jetVec.field_72450_a, jetVec.field_72448_b, jetVec.field_72449_c);
            }
        }
    }

    private float volumeFromConfig(boolean builderMode) {
        return builderMode ? ((Double)ConfigHelper.client().sound.jetbootsVolumeBuilderMode.get()).floatValue() : ((Double)ConfigHelper.client().sound.jetbootsVolume.get()).floatValue();
    }
}

