/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;

public class PneumaticArmorLayer<T extends LivingEntity, M extends BipedModel<T>, A extends BipedModel<T>>
extends LayerRenderer<T, M> {
    private final A modelLeggings;
    private final A modelArmor;

    public PneumaticArmorLayer(IEntityRenderer<T, M> entityRendererIn, A modelLeggings, A modelArmor) {
        super(entityRendererIn);
        this.modelLeggings = modelLeggings;
        this.modelArmor = modelArmor;
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.renderSlot(matrixStackIn, bufferIn, entity, EquipmentSlotType.CHEST, packedLightIn, this.modelArmor);
        this.renderSlot(matrixStackIn, bufferIn, entity, EquipmentSlotType.LEGS, packedLightIn, this.modelLeggings);
        this.renderSlot(matrixStackIn, bufferIn, entity, EquipmentSlotType.FEET, packedLightIn, this.modelArmor);
        this.renderSlot(matrixStackIn, bufferIn, entity, EquipmentSlotType.HEAD, packedLightIn, this.modelArmor);
    }

    private void renderSlot(MatrixStack matrixStack, IRenderTypeBuffer buffer, T entity, EquipmentSlotType slot, int light, A model) {
        ItemStack stack = entity.func_184582_a(slot);
        if (stack.func_77973_b() instanceof ItemPneumaticArmor && ((ItemPneumaticArmor)stack.func_77973_b()).func_185083_B_() == slot) {
            model = ForgeHooksClient.getArmorModel(entity, (ItemStack)stack, (EquipmentSlotType)slot, model);
            ((BipedModel)this.func_215332_c()).func_217148_a(model);
            this.setModelSlotVisible(model, slot);
            boolean glint = stack.func_77962_s();
            float[] secondary = RenderUtils.decomposeColorF(((ItemPneumaticArmor)stack.func_77973_b()).getSecondaryColor(stack));
            this.doRender(matrixStack, buffer, light, glint, model, secondary[1], secondary[2], secondary[3], slot, ExtraLayer.SECONDARY_COLOR);
            if (slot == EquipmentSlotType.CHEST) {
                this.doRender(matrixStack, buffer, 0xF000F0, glint, model, 1.0f, 1.0f, 1.0f, slot, ExtraLayer.TRANSLUCENT);
            }
            if (slot == EquipmentSlotType.HEAD) {
                float[] eyepiece = RenderUtils.decomposeColorF(((ItemPneumaticArmor)stack.func_77973_b()).getEyepieceColor(stack));
                this.doRender(matrixStack, buffer, 0xF000F0, false, model, eyepiece[1], eyepiece[2], eyepiece[3], slot, ExtraLayer.EYEPIECE);
            }
        }
    }

    private void doRender(MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, boolean glint, A model, float r, float g, float b, EquipmentSlotType slot, ExtraLayer extraLayer) {
        ResourceLocation armorResource = extraLayer.getArmorResource(slot);
        IVertexBuilder ivertexbuilder = ItemRenderer.func_239386_a_((IRenderTypeBuffer)buffer, (RenderType)extraLayer.getRenderType(armorResource), (boolean)false, (boolean)glint);
        model.func_225598_a_(matrixStack, ivertexbuilder, light, OverlayTexture.field_229196_a_, r, g, b, 1.0f);
    }

    protected void setModelSlotVisible(A model, EquipmentSlotType slotIn) {
        model.func_178719_a(false);
        switch (slotIn) {
            case HEAD: {
                ((BipedModel)model).field_78116_c.field_78806_j = true;
                ((BipedModel)model).field_178720_f.field_78806_j = true;
                break;
            }
            case CHEST: {
                ((BipedModel)model).field_78115_e.field_78806_j = true;
                ((BipedModel)model).field_178723_h.field_78806_j = true;
                ((BipedModel)model).field_178724_i.field_78806_j = true;
                break;
            }
            case LEGS: {
                ((BipedModel)model).field_78115_e.field_78806_j = true;
                ((BipedModel)model).field_178721_j.field_78806_j = true;
                ((BipedModel)model).field_178722_k.field_78806_j = true;
                break;
            }
            case FEET: {
                ((BipedModel)model).field_178721_j.field_78806_j = true;
                ((BipedModel)model).field_178722_k.field_78806_j = true;
            }
        }
    }

    static enum ExtraLayer {
        SECONDARY_COLOR("overlay", false),
        TRANSLUCENT("translucent", true),
        EYEPIECE("eyepiece", true);

        private final ResourceLocation rl1;
        private final ResourceLocation rl2;
        private final boolean translucent;

        private ExtraLayer(String name, boolean translucent) {
            this.translucent = translucent;
            this.rl1 = PneumaticRegistry.RL("textures/armor/pneumatic_1_" + name + ".png");
            this.rl2 = PneumaticRegistry.RL("textures/armor/pneumatic_2_" + name + ".png");
        }

        RenderType getRenderType(ResourceLocation rl) {
            return this.translucent ? ModRenderTypes.getArmorTranslucentNoCull(rl) : RenderType.func_239263_a_((ResourceLocation)rl);
        }

        ResourceLocation getArmorResource(EquipmentSlotType slot) {
            return slot == EquipmentSlotType.LEGS ? this.rl2 : this.rl1;
        }
    }
}

