/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.fluid;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.client.render.fluid.AbstractFluidTER;
import me.desht.pneumaticcraft.client.render.fluid.IFluidItemRenderInfoProvider;
import me.desht.pneumaticcraft.client.render.fluid.TankRenderInfo;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.tileentity.TileEntityFluidTank;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class RenderFluidTank
extends AbstractFluidTER<TileEntityFluidTank> {
    private static final AxisAlignedBB BOUNDS_NONE = new AxisAlignedBB(0.125625, 0.063125, 0.125625, 0.874375, 0.936875, 0.874375);
    private static final AxisAlignedBB BOUNDS_UP = new AxisAlignedBB(0.125625, 0.063125, 0.125625, 0.874375, 1.0, 0.874375);
    private static final AxisAlignedBB BOUNDS_DOWN = new AxisAlignedBB(0.125625, 0.0, 0.125625, 0.874375, 0.936875, 0.874375);
    private static final AxisAlignedBB BOUNDS_BOTH = new AxisAlignedBB(0.125625, 0.0, 0.125625, 0.874375, 1.0, 0.874375);

    public RenderFluidTank(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    Collection<TankRenderInfo> getTanksToRender(TileEntityFluidTank te) {
        boolean up = (Boolean)te.func_195044_w().func_177229_b((Property)BlockPneumaticCraft.UP);
        boolean down = (Boolean)te.func_195044_w().func_177229_b((Property)BlockPneumaticCraft.DOWN);
        AxisAlignedBB bounds = up && down ? BOUNDS_BOTH : (up ? BOUNDS_UP : (down ? BOUNDS_DOWN : BOUNDS_NONE));
        return Collections.singletonList(new FluidTankRenderInfo((IFluidTank)te.getTank(), up, down, bounds));
    }

    private static class FluidTankRenderInfo
    extends TankRenderInfo {
        private final boolean up;
        private final boolean down;

        FluidTankRenderInfo(IFluidTank tank, boolean up, boolean down, AxisAlignedBB bounds) {
            super(tank, bounds, new Direction[0]);
            this.up = up;
            this.down = down;
        }

        @Override
        public boolean shouldRender(Direction face) {
            switch (face) {
                case UP: {
                    return this.up || this.getTank().getFluid().getAmount() < this.getTank().getCapacity() && !this.getTank().getFluid().getFluid().getAttributes().isLighterThanAir();
                }
                case DOWN: {
                    return this.down || this.getTank().getFluid().getAmount() < this.getTank().getCapacity() && this.getTank().getFluid().getFluid().getAttributes().isLighterThanAir();
                }
            }
            return true;
        }
    }

    public static class ItemRenderInfoProvider
    implements IFluidItemRenderInfoProvider {
        @Override
        public List<TankRenderInfo> getTanksToRender(ItemStack stack) {
            return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(h -> Collections.singletonList(new TankRenderInfo(h.getFluidInTank(0), h.getTankCapacity(0), BOUNDS_NONE, new Direction[0]))).orElse(Collections.emptyList());
        }
    }
}

