/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.lwjgl.opengl.GL11;

public class WidgetList<T>
extends Widget
implements ITooltipProvider {
    @Nonnull
    private final Consumer<WidgetList<T>> pressable;
    private final List<T> items = new ArrayList<T>();
    private int selected = -1;
    private long lastClick = 0L;
    private boolean doubleClicked;
    private int fgColor = 0x404040;
    private int selectedFg = 0xFFFFFF;
    private int selectedBg = 0;
    private boolean inverseSelected = true;
    private ToolTipType toolTipType = ToolTipType.AUTO;

    public WidgetList(int xIn, int yIn, int width, int height) {
        this(xIn, yIn, width, height, c -> {});
    }

    public WidgetList(int xIn, int yIn, int width, int height, @Nonnull Consumer<WidgetList<T>> pressable) {
        super(xIn, yIn, width, height, StringTextComponent.field_240750_d_);
        this.pressable = pressable;
    }

    public WidgetList<T> setColor(int color) {
        this.fgColor = color;
        return this;
    }

    public WidgetList<T> setToolTipType(ToolTipType toolTipType) {
        this.toolTipType = toolTipType;
        return this;
    }

    public WidgetList<T> setSelectedColors(int selectedFg, int selectedBg) {
        this.selectedFg = selectedFg;
        this.selectedBg = selectedBg;
        return this;
    }

    public WidgetList<T> inverseSelected(boolean inverse) {
        this.inverseSelected = inverse;
        return this;
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230694_p_) {
            this.drawList(matrixStack);
        }
    }

    public boolean isDoubleClicked() {
        return this.doubleClicked;
    }

    public void setSelected(int selected) {
        this.selected = selected;
    }

    public void unselectAll() {
        this.selected = -1;
    }

    public List<T> getLines() {
        return ImmutableList.copyOf(this.items);
    }

    public T getSelectedLine() {
        return this.selected >= 0 && this.selected < this.items.size() ? (T)this.items.get(this.selected) : null;
    }

    public boolean contains(T s) {
        return this.items.contains(s);
    }

    public void add(T s) {
        this.items.add(s);
    }

    public void removeSelected() {
        if (this.selected >= 0 && this.selected < this.items.size()) {
            this.items.remove(this.selected);
            this.updateSelection();
        }
    }

    public void clear() {
        this.items.clear();
        this.setSelected(-1);
    }

    private void updateSelection() {
        if (this.items.isEmpty()) {
            this.selected = -1;
        } else if (this.selected >= this.items.size()) {
            this.selected = this.items.size() - 1;
        }
    }

    public int size() {
        return this.items.size();
    }

    private void drawList(MatrixStack matrixStack) {
        Minecraft mc = Minecraft.func_71410_x();
        int sf = mc.field_71474_y.field_74335_Z;
        mc.field_71466_p.getClass();
        int h = 9;
        int lines = this.field_230689_k_ / h;
        matrixStack.func_227860_a_();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)(this.field_230690_l_ * sf), (int)((this.field_230691_m_ + this.field_230689_k_) * sf), (int)(this.field_230688_j_ * sf), (int)(this.field_230689_k_ * sf));
        if (this.inverseSelected && this.selected >= 0) {
            RenderSystem.disableTexture();
            WidgetList.func_238467_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)(this.field_230691_m_ + h * this.selected), (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + h * (this.selected + 1)), (int)(0xFF000000 | this.selectedBg));
            RenderSystem.enableTexture();
        }
        matrixStack.func_227861_a_((double)this.field_230690_l_, (double)this.field_230691_m_, 0.0);
        matrixStack.func_227862_a_(0.75f, 1.0f, 1.0f);
        for (int i = 0; i < this.items.size() && i < lines; ++i) {
            mc.field_71466_p.func_238421_b_(matrixStack, this.items.get(i).toString(), 0.0f, (float)(i * h), i == this.selected ? this.selectedFg : this.fgColor);
        }
        GL11.glDisable((int)3089);
        matrixStack.func_227865_b_();
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        if (this.field_230693_o_) {
            long now = System.currentTimeMillis();
            Minecraft.func_71410_x().field_71466_p.getClass();
            int h = 9;
            int newSel = MathHelper.func_76125_a((int)((int)(mouseY - (double)this.field_230691_m_) / h), (int)0, (int)(this.items.size() - 1));
            this.doubleClicked = now - this.lastClick < 250L && newSel == this.selected;
            this.setSelected(newSel);
            this.lastClick = now;
            this.pressable.accept(this);
        }
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<ITextComponent> curTip, boolean shift) {
        if (this.toolTipType == ToolTipType.NONE) {
            return;
        }
        Minecraft.func_71410_x().field_71466_p.getClass();
        int h = 9;
        int idx = Math.max(0, (int)(mouseY - (double)this.field_230691_m_) / h);
        if (idx >= 0 && idx < this.items.size()) {
            String s = this.items.get(idx).toString();
            if (this.toolTipType == ToolTipType.ALWAYS || Minecraft.func_71410_x().field_71466_p.func_78256_a(s) * 3 / 4 > this.field_230688_j_) {
                curTip.add((ITextComponent)new StringTextComponent(s));
            }
        }
    }

    public static enum ToolTipType {
        NONE,
        AUTO,
        ALWAYS;

    }
}

