/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.client.gui.widget.WidgetFluidFilter;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;

public class WidgetFluidStack
extends WidgetFluidFilter {
    private boolean adjustable = false;

    public WidgetFluidStack(int x, int y, FluidStack stack, Consumer<WidgetFluidFilter> pressable) {
        super(x, y, stack, pressable);
    }

    public WidgetFluidStack setAdjustable() {
        this.adjustable = true;
        return this;
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public WidgetFluidStack setFluidStack(FluidStack fluidStack) {
        this.fluidStack = fluidStack;
        return this;
    }

    @Override
    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTick) {
        int fluidAmount;
        super.func_230431_b_(matrixStack, mouseX, mouseY, partialTick);
        if (!this.fluidStack.isEmpty() && (fluidAmount = this.fluidStack.getAmount() / 1000) > 1) {
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, 200.0);
            String s = fluidAmount + "B";
            fr.func_238405_a_(matrixStack, s, (float)(this.field_230690_l_ - fr.func_78256_a(s) + 17), (float)(this.field_230691_m_ + 9), -1);
            matrixStack.func_227865_b_();
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.func_230992_c_(mouseX, mouseY)) {
            if (!this.fluidStack.isEmpty() && this.adjustable) {
                boolean shift = Screen.func_231173_s_();
                switch (button) {
                    case 0: {
                        this.fluidStack.setAmount(shift ? this.fluidStack.getAmount() / 2 : Math.max(0, this.fluidStack.getAmount() - 1000));
                        if (this.fluidStack.getAmount() >= 1000) break;
                        this.fluidStack.setAmount(0);
                        break;
                    }
                    case 1: {
                        this.fluidStack.setAmount(shift ? this.fluidStack.getAmount() * 2 : this.fluidStack.getAmount() + 1000);
                        break;
                    }
                    case 2: {
                        this.fluidStack.setAmount(0);
                    }
                }
            }
            if (this.pressable != null) {
                this.pressable.accept(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<ITextComponent> curTip, boolean shiftPressed) {
        if (!this.fluidStack.isEmpty()) {
            curTip.add(new FluidStack(this.fluidStack, 1).getDisplayName());
            curTip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.message.misc.fluidmB", this.fluidStack.getAmount()).func_240699_a_(TextFormatting.GRAY));
            curTip.add((ITextComponent)new StringTextComponent(ModNameCache.getModName(this.fluidStack.getFluid())).func_240701_a_(new TextFormatting[]{TextFormatting.BLUE, TextFormatting.ITALIC}));
        }
    }
}

