/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticScreenBase;
import me.desht.pneumaticcraft.client.gui.widget.ICanRender3d;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.client.gui.widget.WidgetVerticalScrollbar;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ICharacterConsumer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class WidgetAnimatedStat
extends Widget
implements IGuiAnimatedStat,
ITooltipProvider {
    private static final int MIN_WIDTH_HEIGHT = 17;
    private static final int MAX_VISIBLE_LINES = 12;
    private static final int SCROLLBAR_MARGIN_WIDTH = 20;
    private static final int TOP_MARGIN_HEIGHT = 20;
    private IGuiAnimatedStat statAbove;
    private StatIcon statIcon;
    private final Screen gui;
    private final List<ITextComponent> textComponents = new ArrayList<ITextComponent>();
    private final List<IReorderingProcessor> reorderingProcessors = new ArrayList<IReorderingProcessor>();
    private final List<Boolean> dropShadows = new ArrayList<Boolean>();
    private final List<Widget> subWidgets = new ArrayList<Widget>();
    private int effectiveY;
    private int reservedLines = 0;
    private boolean autoLineWrap = true;
    private int prevX;
    private int prevEffectiveY;
    private int prevWidth;
    private int prevHeight;
    private boolean isClicked = false;
    private int minWidth = 17;
    private int minHeight = 17;
    private int minExpandedHeight;
    private int minExpandedWidth;
    private int expandedWidth;
    private int expandedHeight;
    private int backGroundColor;
    private TintColor bgColorHi;
    private TintColor bgColorLo;
    private boolean leftSided;
    private boolean doneExpanding;
    private int curScroll;
    private int lineSpacing = 10;
    private int widgetOffsetLeft = 0;
    private int widgetOffsetRight = 0;
    private boolean bevel = false;
    private WidgetVerticalScrollbar scrollBar = null;
    private boolean needTextRecalc = true;
    private int foregroundColor = -1;
    private int titleColor = -256;
    private List<ITextComponent> extraTooltipText = new ArrayList<ITextComponent>();

    public WidgetAnimatedStat(Screen gui, ITextComponent title, int xPos, int yPos, int backGroundColor, IGuiAnimatedStat statAbove, boolean leftSided) {
        super(xPos, yPos, 17, 17, title);
        this.gui = gui;
        this.statAbove = statAbove;
        this.leftSided = leftSided;
        this.statIcon = StatIcon.NONE;
        this.backGroundColor = backGroundColor;
        this.calculateColorHighlights(this.backGroundColor);
        this.effectiveY = this.field_230691_m_;
        if (statAbove != null) {
            this.effectiveY += statAbove.getEffectiveY() + statAbove.getStatHeight();
        }
    }

    public WidgetAnimatedStat(Screen gui, int backgroundColor) {
        this(gui, StringTextComponent.field_240750_d_, 0, 0, backgroundColor, null, false);
    }

    public WidgetAnimatedStat(Screen gui, int backgroundColor, ItemStack icon) {
        this(gui, backgroundColor);
        this.statIcon = StatIcon.of(icon);
    }

    public WidgetAnimatedStat(Screen gui, int backgroundColor, ResourceLocation texture) {
        this(gui, backgroundColor);
        this.statIcon = StatIcon.of(texture);
    }

    public WidgetAnimatedStat(Screen gui, ITextComponent title, StatIcon icon, int xPos, int yPos, int backGroundColor, IGuiAnimatedStat statAbove, boolean leftSided) {
        this(gui, title, xPos, yPos, backGroundColor, statAbove, leftSided);
        this.statIcon = icon;
    }

    public WidgetAnimatedStat(Screen gui, ITextComponent title, StatIcon icon, int backGroundColor, IGuiAnimatedStat statAbove, ArmorHUDLayout.LayoutItem layout) {
        this(gui, title, 0, 0, backGroundColor, statAbove, layout.isLeftSided());
        MainWindow mw = Minecraft.func_71410_x().func_228018_at_();
        int x = layout.getX() == -1.0f ? mw.func_198107_o() - 2 : (int)((float)mw.func_198107_o() * layout.getX());
        this.setBaseX(x);
        this.setBaseY((int)((float)mw.func_198087_p() * layout.getY()));
        this.statIcon = icon;
    }

    public void func_238482_a_(ITextComponent message) {
        super.func_238482_a_(message);
        this.needTextRecalc = true;
    }

    @Override
    public void setParentStat(IGuiAnimatedStat stat) {
        this.statAbove = stat;
    }

    public void addSubWidget(Widget widget) {
        this.subWidgets.add(widget);
    }

    public void removeSubWidget(Widget widget) {
        this.subWidgets.remove(widget);
    }

    public void setSubwidgetRenderOffsets(int left, int right) {
        this.widgetOffsetLeft = left;
        this.widgetOffsetRight = right;
    }

    @Override
    public boolean isLeftSided() {
        return this.leftSided;
    }

    @Override
    public void setLeftSided(boolean leftSided) {
        this.leftSided = leftSided;
    }

    @Override
    public void setAutoLineWrap(boolean wrap) {
        this.autoLineWrap = wrap;
    }

    @Override
    public ITextComponent getTitle() {
        return this.func_230458_i_();
    }

    @Override
    public void setTitle(ITextComponent title) {
        this.func_238482_a_(title);
    }

    @Override
    public IGuiAnimatedStat setText(List<ITextComponent> text) {
        this.textComponents.clear();
        this.textComponents.addAll(text);
        this.needTextRecalc = true;
        return this;
    }

    @Override
    public IGuiAnimatedStat setText(ITextComponent text) {
        this.textComponents.clear();
        this.textComponents.add(text);
        this.needTextRecalc = true;
        return this;
    }

    @Override
    public void appendText(List<ITextComponent> text) {
        this.textComponents.addAll(text);
        this.needTextRecalc = true;
    }

    @Override
    public void setBackgroundColor(int backgroundColor) {
        if (backgroundColor != this.backGroundColor) {
            this.backGroundColor = backgroundColor;
            this.calculateColorHighlights(backgroundColor);
        }
    }

    @Override
    public void setForegroundColor(int foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    @Override
    public void setTitleColor(int titleColor) {
        this.titleColor = titleColor;
    }

    @Override
    public int getBackgroundColor() {
        return this.backGroundColor;
    }

    private void calculateColorHighlights(int color) {
        if (((Boolean)ConfigHelper.client().general.guiBevel.get()).booleanValue()) {
            float fgR = (float)(color >> 16 & 0xFF) / 255.0f;
            float fgG = (float)(color >> 8 & 0xFF) / 255.0f;
            float fgB = (float)(color & 0xFF) / 255.0f;
            float fgA = (float)(color >> 24 & 0xFF) / 255.0f;
            TintColor c = new TintColor(fgR, fgG, fgB, fgA);
            if (this.bevel) {
                this.bgColorHi = c.brighter();
                this.bgColorLo = c.darker();
            } else {
                this.bgColorLo = this.bgColorHi = c.darker().darker();
            }
        } else {
            this.bgColorLo = this.bgColorHi = TintColor.BLACK;
        }
    }

    @Override
    public void setBeveled(boolean bevel) {
        this.bevel = bevel;
        this.calculateColorHighlights(this.backGroundColor);
    }

    private int getVisibleLines() {
        return 12 - this.reservedLines;
    }

    @Override
    public void setReservedLines(int reservedLines) {
        this.reservedLines = MathHelper.func_76125_a((int)reservedLines, (int)0, (int)11);
        this.needTextRecalc = true;
    }

    private void recalcText() {
        int n;
        this.reorderingProcessors.clear();
        this.dropShadows.clear();
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int titleWidth = font.func_238414_a_((ITextProperties)this.func_230458_i_());
        if (this.autoLineWrap) {
            int availableWidth = this.calculateAvailableWidth();
            this.reorderingProcessors.addAll(GuiUtils.wrapTextComponentList(this.textComponents, availableWidth, font));
            this.expandedWidth = Math.min(availableWidth, Math.max(titleWidth, this.minExpandedWidth));
        } else {
            this.expandedWidth = titleWidth;
            this.textComponents.forEach(c -> this.reorderingProcessors.add(c.func_241878_f()));
        }
        this.reorderingProcessors.forEach(processedLine -> {
            this.expandedWidth = Math.max(this.expandedWidth, font.func_243245_a(processedLine));
            this.dropShadows.add(this.needsDropShadow((IReorderingProcessor)processedLine));
        });
        this.expandedWidth += 20;
        if (this.reorderingProcessors.isEmpty()) {
            font.getClass();
            n = 9;
        } else {
            n = 20;
        }
        int topMargin = n;
        int n2 = Math.min(12, this.reorderingProcessors.size() + this.reservedLines);
        font.getClass();
        this.expandedHeight = Math.max(this.minExpandedHeight, topMargin + n2 * 9) + 3;
        this.addOrRemoveScrollbar();
        this.needTextRecalc = false;
    }

    private int calculateAvailableWidth() {
        int availableWidth;
        if (this.gui instanceof ContainerScreen) {
            ContainerScreen gc = (ContainerScreen)this.gui;
            availableWidth = Math.min(Math.max(this.minExpandedWidth, gc.getXSize()), this.leftSided ? gc.getGuiLeft() : gc.field_230708_k_ - (gc.getGuiLeft() + gc.getXSize()));
        } else if (this.gui instanceof GuiPneumaticScreenBase) {
            GuiPneumaticScreenBase g = (GuiPneumaticScreenBase)this.gui;
            availableWidth = Math.min(Math.max(this.minExpandedWidth, g.xSize), this.leftSided ? g.guiLeft : g.xSize - (g.guiLeft + g.xSize));
        } else {
            availableWidth = this.leftSided ? this.field_230690_l_ : Minecraft.func_71410_x().func_228018_at_().func_198107_o() - this.field_230690_l_;
        }
        return availableWidth - 5 - 20;
    }

    private boolean needsDropShadow(IReorderingProcessor line) {
        StyleChecker styleChecker = new StyleChecker(this.foregroundColor);
        line.accept((ICharacterConsumer)styleChecker);
        return styleChecker.isLightColor();
    }

    private void addOrRemoveScrollbar() {
        if (this.reorderingProcessors.size() > this.getVisibleLines()) {
            int n;
            if (this.subWidgets.contains(this.scrollBar)) {
                return;
            }
            this.curScroll = 0;
            int scrollbarHeight = this.getVisibleLines() * this.lineSpacing - 20;
            if (this.reservedLines > 0) {
                Minecraft.func_71410_x().field_71466_p.getClass();
                n = this.reservedLines * 9;
            } else {
                n = 0;
            }
            int yOffset = n;
            this.scrollBar = new WidgetVerticalScrollbar(this.leftSided ? -16 : 2, 20 + yOffset, scrollbarHeight).setStates(this.reorderingProcessors.size() - this.getVisibleLines()).setListening(true);
            this.addSubWidget(this.scrollBar);
        } else if (this.subWidgets.removeIf(w -> w == this.scrollBar)) {
            this.curScroll = 0;
            this.scrollBar = null;
        }
    }

    @Override
    public void setMinimumContractedDimensions(int minWidth, int minHeight) {
        this.minWidth = minWidth;
        this.minHeight = minHeight;
        this.field_230688_j_ = minWidth;
        this.field_230689_k_ = minHeight;
    }

    @Override
    public void setMinimumExpandedDimensions(int minWidth, int minHeight) {
        if (this.minExpandedWidth != minWidth) {
            this.needTextRecalc = true;
        }
        this.minExpandedWidth = minWidth;
        this.minExpandedHeight = minHeight;
    }

    @Override
    public void tickWidget() {
        if (this.needTextRecalc) {
            this.recalcText();
        }
        this.prevX = this.field_230690_l_;
        this.prevEffectiveY = this.effectiveY;
        this.prevWidth = this.field_230688_j_;
        this.prevHeight = this.field_230689_k_;
        this.doneExpanding = true;
        int expandX = this.expandedWidth / 4;
        int expandY = this.expandedHeight / 4;
        if (this.isClicked) {
            this.field_230688_j_ = Math.min(this.expandedWidth, this.field_230688_j_ + expandX);
            this.field_230689_k_ = Math.min(this.expandedHeight, this.field_230689_k_ + expandY);
            this.doneExpanding = this.field_230688_j_ == this.expandedWidth && this.field_230689_k_ == this.expandedHeight;
            int scaledWidth = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
            int scaledHeight = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
            if (this.isLeftSided()) {
                if (this.field_230690_l_ >= scaledWidth) {
                    this.field_230690_l_ = scaledWidth;
                }
            } else if (this.field_230690_l_ < 0) {
                this.field_230690_l_ = 1;
            }
            if (this.field_230691_m_ + this.field_230689_k_ >= scaledHeight) {
                this.field_230691_m_ = scaledHeight - this.field_230689_k_ - 1;
            }
            if (this.doneExpanding && this.scrollBar != null) {
                this.curScroll = this.scrollBar.getState();
            }
        } else {
            this.field_230688_j_ = Math.max(this.minWidth, this.field_230688_j_ - expandX);
            this.field_230689_k_ = Math.max(this.minHeight, this.field_230689_k_ - expandY);
            this.doneExpanding = false;
        }
        this.effectiveY = this.field_230691_m_;
        if (this.statAbove != null) {
            this.effectiveY += this.statAbove.getEffectiveY() + this.statAbove.getStatHeight();
        }
    }

    @Override
    public void renderStat(MatrixStack matrixStack, int x, int y, float partialTicks) {
        this.func_230431_b_(matrixStack, x, y, partialTicks);
    }

    protected boolean func_230992_c_(double mouseX, double mouseY) {
        if (this.leftSided) {
            return this.field_230693_o_ && this.field_230694_p_ && mouseX >= (double)this.field_230690_l_ - (double)this.field_230688_j_ && mouseX < (double)this.field_230690_l_ && mouseY >= (double)this.field_230691_m_ && mouseY < (double)(this.field_230691_m_ + this.field_230689_k_);
        }
        return super.func_230992_c_(mouseX, mouseY);
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.field_230694_p_) {
            return;
        }
        int baseX = this.leftSided ? this.field_230690_l_ - this.field_230688_j_ : this.field_230690_l_;
        this.field_230692_n_ = mouseX >= baseX && mouseY >= this.effectiveY && mouseX < baseX + this.field_230688_j_ && mouseY < this.effectiveY + this.field_230689_k_;
        float zLevel = 0.0f;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int renderBaseX = (int)MathHelper.func_219799_g((float)partialTicks, (float)this.prevX, (float)this.field_230690_l_);
        int renderAffectedY = (int)MathHelper.func_219799_g((float)partialTicks, (float)this.prevEffectiveY, (float)this.effectiveY);
        int renderWidth = (int)MathHelper.func_219799_g((float)partialTicks, (float)this.prevWidth, (float)this.field_230688_j_);
        int renderHeight = (int)MathHelper.func_219799_g((float)partialTicks, (float)this.prevHeight, (float)this.field_230689_k_);
        if (this.leftSided) {
            renderWidth *= -1;
        }
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)renderBaseX, (int)renderAffectedY, (int)(renderBaseX + renderWidth), (int)(renderAffectedY + renderHeight), (int)this.backGroundColor);
        RenderSystem.disableTexture();
        RenderSystem.lineWidth((float)3.0f);
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        float[] c1 = this.leftSided ? this.bgColorLo.getComponents(null) : this.bgColorHi.getComponents(null);
        float[] c2 = this.bgColorHi.getComponents(null);
        float[] c3 = this.leftSided ? this.bgColorHi.getComponents(null) : this.bgColorLo.getComponents(null);
        float[] c4 = this.bgColorLo.getComponents(null);
        wr.func_225582_a_((double)renderBaseX, (double)renderAffectedY, (double)zLevel).func_227885_a_(c1[0], c1[1], c1[2], c1[3]).func_181675_d();
        wr.func_225582_a_((double)(renderBaseX + renderWidth), (double)renderAffectedY, (double)zLevel).func_227885_a_(c2[0], c2[1], c2[2], c2[3]).func_181675_d();
        wr.func_225582_a_((double)(renderBaseX + renderWidth), (double)(renderAffectedY + renderHeight), (double)zLevel).func_227885_a_(c3[0], c3[1], c3[2], c3[3]).func_181675_d();
        wr.func_225582_a_((double)renderBaseX, (double)(renderAffectedY + renderHeight), (double)zLevel).func_227885_a_(c4[0], c4[1], c4[2], c4[3]).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.enableTexture();
        if (this.leftSided) {
            renderWidth *= -1;
        }
        if (this.doneExpanding) {
            String title;
            int titleYoffset;
            if (this.needTextRecalc) {
                this.recalcText();
            }
            int n = titleYoffset = (title = this.func_230458_i_().getString()).isEmpty() ? 3 : 12;
            if (!title.isEmpty()) {
                fontRenderer.func_238405_a_(matrixStack, title, (float)(renderBaseX + (this.leftSided ? -renderWidth + 2 : 18)), (float)(renderAffectedY + 2), this.titleColor);
            }
            for (int i = this.curScroll; i < this.reorderingProcessors.size() && i < this.curScroll + this.getVisibleLines(); ++i) {
                IReorderingProcessor line = this.reorderingProcessors.get(i);
                int renderX = renderBaseX + (this.leftSided ? -renderWidth + 2 : 18);
                fontRenderer.getClass();
                int renderY = renderAffectedY + (i - this.curScroll) * this.lineSpacing + titleYoffset + this.reservedLines * 9;
                if (this.dropShadows.get(i).booleanValue()) {
                    fontRenderer.func_238407_a_(matrixStack, line, (float)renderX, (float)renderY, this.foregroundColor);
                    continue;
                }
                fontRenderer.func_238422_b_(matrixStack, line, (float)renderX, (float)renderY, this.foregroundColor);
            }
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(renderBaseX + (this.leftSided ? this.widgetOffsetLeft : this.widgetOffsetRight)), (double)(renderAffectedY + (titleYoffset - 10)), 0.0);
            RenderSystem.enableTexture();
            this.subWidgets.forEach(widget -> widget.func_230430_a_(matrixStack, mouseX - renderBaseX, mouseY - renderAffectedY, partialTicks));
            matrixStack.func_227865_b_();
        }
        if (renderHeight > 16 && renderWidth > 16 && this.statIcon != null) {
            this.statIcon.render(matrixStack, renderBaseX, renderAffectedY, this.leftSided);
        }
    }

    @Override
    public void renderStat(MatrixStack matrixStack, IRenderTypeBuffer buffer, float partialTicks) {
        if (this.needTextRecalc) {
            this.recalcText();
        }
        int renderBaseX = (int)MathHelper.func_219799_g((float)partialTicks, (float)this.prevX, (float)this.field_230690_l_);
        int renderEffectiveY = (int)MathHelper.func_219799_g((float)partialTicks, (float)this.prevEffectiveY, (float)this.effectiveY);
        int renderWidth = (int)MathHelper.func_219799_g((float)partialTicks, (float)this.prevWidth, (float)this.field_230688_j_);
        int renderHeight = (int)MathHelper.func_219799_g((float)partialTicks, (float)this.prevHeight, (float)this.field_230689_k_);
        int[] cols = RenderUtils.decomposeColor(this.backGroundColor);
        RenderUtils.renderWithTypeAndFinish(matrixStack, buffer, ModRenderTypes.getUntexturedQuad(true), (posMat, builder) -> {
            int rw = this.leftSided ? -renderWidth : renderWidth;
            builder.func_227888_a_(posMat, (float)renderBaseX, (float)renderEffectiveY + (float)renderHeight, 0.0f).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(posMat, (float)renderBaseX + (float)rw, (float)renderEffectiveY + (float)renderHeight, 0.0f).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(posMat, (float)renderBaseX + (float)rw, (float)renderEffectiveY, 0.0f).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(posMat, (float)renderBaseX, (float)renderEffectiveY, 0.0f).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_227886_a_(0xF000F0).func_181675_d();
        });
        RenderUtils.renderWithTypeAndFinish(matrixStack, buffer, ModRenderTypes.getLineLoopsTransparent(5.0), (posMat, builder) -> {
            int rw = this.leftSided ? -renderWidth : renderWidth;
            float[] c1 = this.leftSided ? this.bgColorLo.getComponents(null) : this.bgColorHi.getComponents(null);
            float[] c2 = this.bgColorHi.getComponents(null);
            float[] c3 = this.leftSided ? this.bgColorHi.getComponents(null) : this.bgColorLo.getComponents(null);
            float[] c4 = this.bgColorLo.getComponents(null);
            builder.func_227888_a_(posMat, (float)renderBaseX, (float)renderEffectiveY, 0.0f).func_227885_a_(c1[0], c1[1], c1[2], c1[3]).func_181675_d();
            builder.func_227888_a_(posMat, (float)(renderBaseX + rw), (float)renderEffectiveY, 0.0f).func_227885_a_(c2[0], c2[1], c2[2], c2[3]).func_181675_d();
            builder.func_227888_a_(posMat, (float)(renderBaseX + rw), (float)(renderEffectiveY + renderHeight), 0.0f).func_227885_a_(c3[0], c3[1], c3[2], c3[3]).func_181675_d();
            builder.func_227888_a_(posMat, (float)renderBaseX, (float)(renderEffectiveY + renderHeight), 0.0f).func_227885_a_(c4[0], c4[1], c4[2], c4[3]).func_181675_d();
        });
        if (this.doneExpanding) {
            matrixStack.func_227860_a_();
            String title = this.func_230458_i_().getString();
            if (!title.isEmpty()) {
                RenderUtils.renderString3d(TextFormatting.UNDERLINE + title, renderBaseX + (this.leftSided ? -renderWidth + 2 : 18), renderEffectiveY + 2, this.titleColor, matrixStack, buffer, false, true);
            }
            int titleYoffset = title.isEmpty() ? 3 : 12;
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            for (int i = this.curScroll; i < this.textComponents.size() && i < this.curScroll + this.getVisibleLines(); ++i) {
                int renderX = renderBaseX + (this.leftSided ? -renderWidth + 2 : 18);
                font.getClass();
                int renderY = renderEffectiveY + (i - this.curScroll) * this.lineSpacing + titleYoffset + this.reservedLines * 9;
                font.func_238416_a_(this.reorderingProcessors.get(i), (float)renderX, (float)renderY, this.foregroundColor, this.dropShadows.get(i).booleanValue(), matrixStack.func_227866_c_().func_227870_a_(), buffer, true, 0, 0xF000F0);
            }
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(renderBaseX + (this.leftSided ? this.widgetOffsetLeft : this.widgetOffsetRight)), (double)(renderEffectiveY + (titleYoffset - 10)), 0.0);
            this.subWidgets.stream().filter(widget -> widget instanceof ICanRender3d).forEach(widget -> ((ICanRender3d)widget).render3d(matrixStack, buffer, partialTicks));
            matrixStack.func_227865_b_();
            matrixStack.func_227865_b_();
        }
        if (renderHeight > 16 && renderWidth > 16 && this.statIcon != null) {
            this.statIcon.render3d(matrixStack, buffer, renderBaseX, renderEffectiveY);
        }
    }

    private void toggle() {
        boolean bl = this.isClicked = !this.isClicked;
        if (this.isClicked && this.gui instanceof GuiPneumaticContainerBase) {
            List<IGuiAnimatedStat> otherStats = ((GuiPneumaticContainerBase)this.gui).getStatWidgets();
            otherStats.stream().filter(stat -> this != stat && stat.isLeftSided() == this.isLeftSided()).forEach(IGuiAnimatedStat::closeStat);
            this.subWidgets.stream().filter(w -> w instanceof TextFieldWidget).findFirst().ifPresent(w -> ((TextFieldWidget)w).func_146195_b(true));
        }
    }

    public boolean func_231047_b_(double mouseX, double mouseY) {
        return this.field_230693_o_ && this.field_230694_p_ && this.getBounds().func_199315_b((int)mouseX, (int)mouseY);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.func_230449_g_()) {
            for (Widget widget : this.subWidgets) {
                if (!widget.func_231044_a_(mouseX - (double)this.field_230690_l_, mouseY - (double)this.effectiveY, button)) continue;
                return true;
            }
            this.toggle();
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.func_230449_g_()) {
            for (Widget widget : this.subWidgets) {
                if (!widget.func_231048_c_(mouseX - (double)this.field_230690_l_, mouseY - (double)this.effectiveY, button)) continue;
                return true;
            }
            return true;
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.func_230449_g_()) {
            Rectangle2d bounds = this.getBounds();
            for (Widget widget : this.subWidgets) {
                if (!widget.func_231045_a_(mouseX - (double)bounds.func_199318_a(), mouseY - (double)bounds.func_199319_b(), button, dragX, dragY)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean func_231043_a_(double x, double y, double dir) {
        Rectangle2d bounds = this.getBounds();
        for (Widget widget : this.subWidgets) {
            if (!widget.func_230999_j_() || !widget.func_231043_a_(x - (double)bounds.func_199318_a(), y - (double)bounds.func_199319_b(), dir)) continue;
            return true;
        }
        return this.scrollBar != null && this.scrollBar.func_231043_a_(x, y, dir);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        for (Widget widget : this.subWidgets) {
            if (!widget.func_231046_a_(keyCode, scanCode, modifiers) && (!(widget instanceof TextFieldWidget) || !widget.func_230999_j_() || keyCode == 256)) continue;
            return true;
        }
        return false;
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        for (Widget widget : this.subWidgets) {
            if (!widget.func_231042_a_(codePoint, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void closeStat() {
        this.isClicked = false;
    }

    @Override
    public void openStat() {
        this.isClicked = true;
    }

    @Override
    public boolean isStatOpen() {
        return this.isClicked;
    }

    @Override
    public int getEffectiveY() {
        return this.effectiveY;
    }

    @Override
    public int getBaseX() {
        return this.field_230690_l_;
    }

    @Override
    public int getBaseY() {
        return this.field_230691_m_;
    }

    @Override
    public int getStatHeight() {
        return this.func_238483_d_();
    }

    @Override
    public int getStatWidth() {
        return this.func_230998_h_();
    }

    @Override
    public void setBaseY(int y) {
        this.field_230691_m_ = y;
    }

    @Override
    public void setBaseX(int x) {
        this.field_230690_l_ = x;
    }

    @Override
    public boolean isDoneExpanding() {
        return this.doneExpanding;
    }

    @Override
    public Rectangle2d getBounds() {
        return new Rectangle2d(this.field_230690_l_ - (this.leftSided ? this.field_230688_j_ : 0), this.effectiveY, this.field_230688_j_, this.field_230689_k_);
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<ITextComponent> curTooltip, boolean shiftPressed) {
        if (this.mouseIsHoveringOverIcon(mouseX, mouseY)) {
            curTooltip.add(this.func_230458_i_());
            curTooltip.addAll(this.getExtraTooltipText());
        }
        for (Widget widget : this.subWidgets) {
            if (!widget.func_230449_g_() || !(widget instanceof ITooltipProvider)) continue;
            ((ITooltipProvider)widget).addTooltip(mouseX, mouseY, curTooltip, shiftPressed);
        }
    }

    public void setExtraTooltipText(List<ITextComponent> extraTooltipText) {
        this.extraTooltipText = extraTooltipText;
    }

    private List<ITextComponent> getExtraTooltipText() {
        return this.extraTooltipText;
    }

    private boolean mouseIsHoveringOverIcon(double x, double y) {
        if (this.leftSided) {
            return x <= (double)this.field_230690_l_ && x >= (double)(this.field_230690_l_ - 16) && y >= (double)this.effectiveY && y <= (double)(this.effectiveY + 16);
        }
        return x >= (double)this.field_230690_l_ && x <= (double)(this.field_230690_l_ + 16) && y >= (double)this.effectiveY && y <= (double)(this.effectiveY + 16);
    }

    public void setLineSpacing(int lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    @Override
    public void setTexture(ResourceLocation texture) {
        this.statIcon = StatIcon.of(texture);
    }

    @Override
    public void setTexture(ItemStack itemStack) {
        this.statIcon = StatIcon.of(itemStack);
    }

    private static class StyleChecker
    implements ICharacterConsumer {
        private static final int THRESHOLD = 129;
        Style style = Style.field_240709_b_;
        private final int defColor;

        private StyleChecker(int defColor) {
            this.defColor = defColor;
        }

        public boolean accept(int p_accept_1_, Style p_accept_2_, int p_accept_3_) {
            if (this.style == Style.field_240709_b_) {
                this.style = p_accept_2_;
            }
            return true;
        }

        public boolean isLightColor() {
            int c = this.style == null || this.style.func_150229_g() || this.style.func_240711_a_() == null ? this.defColor : this.style.func_240711_a_().func_240742_a_();
            return this.isLightColor(new TintColor(c));
        }

        private boolean isLightColor(TintColor bg) {
            int luminance = (int)Math.sqrt((double)(bg.getRed() * bg.getRed()) * 0.241 + (double)(bg.getGreen() * bg.getGreen()) * 0.691 + (double)(bg.getBlue() * bg.getBlue()) * 0.068);
            return luminance > 129;
        }
    }

    public static class StatIcon {
        public static final StatIcon NONE = StatIcon.of(ItemStack.field_190927_a);
        private final Either<ItemStack, ResourceLocation> texture;

        private StatIcon(Either<ItemStack, ResourceLocation> texture) {
            this.texture = texture;
        }

        public static StatIcon of(ItemStack stack) {
            return new StatIcon((Either<ItemStack, ResourceLocation>)Either.left((Object)stack));
        }

        public static StatIcon of(IItemProvider item) {
            return new StatIcon((Either<ItemStack, ResourceLocation>)Either.left((Object)new ItemStack(item, 1)));
        }

        public static StatIcon of(ResourceLocation texture) {
            return new StatIcon((Either<ItemStack, ResourceLocation>)Either.right((Object)texture));
        }

        void render(MatrixStack matrixStack, int x, int y, boolean leftSided) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            this.texture.ifLeft(stack -> GuiUtils.renderItemStack(matrixStack, stack, x - (leftSided ? 16 : 0), y)).ifRight(resLoc -> GuiUtils.drawTexture(matrixStack, resLoc, x - (leftSided ? 16 : 0), y));
            RenderSystem.disableBlend();
        }

        public void render3d(MatrixStack matrixStack, IRenderTypeBuffer buffer, int x, int y) {
            this.texture.ifLeft(stack -> {
                ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
                IBakedModel ibakedmodel = itemRenderer.func_184393_a(stack, ClientUtils.getClientWorld(), null);
                itemRenderer.func_229111_a_(stack, ItemCameraTransforms.TransformType.FIXED, true, matrixStack, buffer, 0xF000F0, OverlayTexture.field_229196_a_, ibakedmodel);
            }).ifRight(resLoc -> RenderUtils.renderWithTypeAndFinish(matrixStack, buffer, ModRenderTypes.getTextureRenderColored(resLoc), (posMat, builder) -> RenderUtils.drawTexture(matrixStack, builder, x, y, 0xF000F0)));
        }
    }
}

