/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor.option_screens;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.gui.GuiProgrammer;
import me.desht.pneumaticcraft.client.gui.ProgrammerWidgetAreaRenderer;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.DroneDebugClientHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.debug.DroneDebugEntry;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.progwidgets.IAreaProvider;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetStart;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class DroneDebuggerOptions
extends IOptionPage.SimpleOptionPage<DroneDebugClientHandler> {
    private static final int PROGRAMMING_MARGIN = 20;
    private static final int PROGRAMMING_START_Y = 40;
    private final IDroneBase selectedDrone = ItemPneumaticArmor.getDebuggedDrone();
    private ProgrammerWidgetAreaRenderer programmerUnit;
    private int programmingStartX;
    private int programmingWidth;
    private int programmingHeight;
    private IProgWidget areaShowingWidget;
    private Button showActive;
    private Button showStart;
    private WidgetCheckBox followCheckbox;
    private static int areaShowWidgetId = -1;

    public DroneDebuggerOptions(IGuiScreen screen, DroneDebugClientHandler upgradeHandler) {
        super(screen, upgradeHandler);
    }

    public static void clearAreaShowWidgetId() {
        areaShowWidgetId = -1;
    }

    @Override
    public void populateGui(IGuiScreen gui) {
        this.showStart = new WidgetButtonExtended(30, 128, 150, 20, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.debug.showStart", new Object[0]), b -> this.programmerUnit.gotoPiece(GuiProgrammer.findWidget(this.selectedDrone.getProgWidgets(), ProgWidgetStart.class)));
        gui.addWidget(this.showStart);
        this.showActive = new WidgetButtonExtended(30, 150, 150, 20, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.debug.showActive", new Object[0]), b -> this.programmerUnit.gotoPiece(this.selectedDrone.getActiveWidget()));
        gui.addWidget(this.showActive);
        this.followCheckbox = new WidgetCheckBox(30, 176, -1, (ITextComponent)new StringTextComponent(" ").func_230529_a_((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.debug.followActive", new Object[0])));
        this.followCheckbox.field_230690_l_ = 180 - this.followCheckbox.func_230998_h_();
        gui.addWidget(this.followCheckbox);
        Screen guiScreen = this.getGuiScreen().getScreen();
        this.programmingStartX = 20;
        this.programmingWidth = guiScreen.field_230708_k_ - 40;
        this.programmingHeight = guiScreen.field_230709_l_ - 20 - 40;
        this.programmerUnit = new DebugWidgetAreaRenderer(guiScreen, this.selectedDrone != null ? this.selectedDrone.getProgWidgets() : new ArrayList(), 0, 0, new Rectangle2d(this.programmingStartX, 40, this.programmingWidth, this.programmingHeight), 0, 0, 0);
        if (this.isDroneValid()) {
            this.programmerUnit.gotoPiece(GuiProgrammer.findWidget(this.selectedDrone.getProgWidgets(), ProgWidgetStart.class));
        }
    }

    private boolean isDroneValid() {
        return this.selectedDrone != null && this.selectedDrone.isDroneStillValid();
    }

    @Override
    public void renderPre(MatrixStack matrixStack, int x, int y, float partialTicks) {
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)this.programmingStartX, (int)40, (int)(this.programmingStartX + this.programmingWidth), (int)(40 + this.programmingHeight), (int)0x55000000);
    }

    @Override
    public void renderPost(MatrixStack matrixStack, int x, int y, float partialTicks) {
        Screen guiScreen = this.getGuiScreen().getScreen();
        int screenWidth = guiScreen.field_230708_k_;
        int screenHeight = guiScreen.field_230709_l_;
        if (this.isDroneValid()) {
            Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrixStack, PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.debug.droneName", this.selectedDrone.getDroneName().getString()).func_241878_f(), 20.0f, (float)(screenHeight - 15), -1);
            Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrixStack, PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.debug.routine", this.selectedDrone.getLabel()).func_241878_f(), (float)screenWidth / 2.0f, (float)(screenHeight - 15), -1);
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 300.0);
        this.programmerUnit.render(matrixStack, x, y, true, true);
        this.programmerUnit.renderForeground(matrixStack, x, y, null, this.getGuiScreen().getFontRenderer());
        matrixStack.func_227865_b_();
        this.followCheckbox.func_230430_a_(matrixStack, x, y, partialTicks);
        if (this.isDroneValid()) {
            ((DroneDebugClientHandler)this.getClientUpgradeHandler()).getShowingPositions().clear();
            if (this.areaShowingWidget != null) {
                int widgetId = this.selectedDrone.getProgWidgets().indexOf(this.areaShowingWidget);
                DroneDebugEntry entry = this.selectedDrone.getDebugger().getDebugEntry(widgetId);
                if (entry != null && entry.hasCoords()) {
                    ((DroneDebugClientHandler)this.getClientUpgradeHandler()).getShowingPositions().add(entry.getPos());
                }
            }
        } else {
            matrixStack.func_227861_a_(0.0, 0.0, 200.0);
            AbstractGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.debug.pressToDebug", ClientUtils.translateKeyBind(KeyHandler.getInstance().keybindDebuggingDrone)), (int)(screenWidth / 2), (int)(screenHeight - 40), (int)-65536);
            matrixStack.func_227861_a_(0.0, 0.0, 200.0);
        }
    }

    @Override
    public void tick() {
        this.programmerUnit.tick();
        this.showStart.field_230693_o_ = this.isDroneValid() && !this.selectedDrone.getProgWidgets().isEmpty();
        boolean bl = this.showActive.field_230693_o_ = this.isDroneValid() && this.selectedDrone.getActiveWidget() != null;
        if (this.followCheckbox.checked && this.isDroneValid() && this.selectedDrone.getActiveWidget() != null) {
            this.programmerUnit.gotoPiece(this.selectedDrone.getActiveWidget());
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (!this.isDroneValid()) {
            return super.mouseClicked(mouseX, mouseY, mouseButton);
        }
        IProgWidget widget = this.programmerUnit.getHoveredWidget((int)mouseX, (int)mouseY);
        if (mouseButton == 0) {
            this.areaShowingWidget = this.areaShowingWidget == widget ? null : this.programmerUnit.getHoveredWidget((int)mouseX, (int)mouseY);
        } else if (mouseButton == 1 && widget instanceof IAreaProvider) {
            ((DroneDebugClientHandler)this.getClientUpgradeHandler()).getShownArea().clear();
            int widgetId = this.selectedDrone.getProgWidgets().indexOf(widget);
            if (areaShowWidgetId != widgetId) {
                HashSet area = Sets.newHashSet();
                ((IAreaProvider)((Object)widget)).getArea(area);
                ((DroneDebugClientHandler)this.getClientUpgradeHandler()).getShownArea().addAll(area);
                areaShowWidgetId = widgetId;
            } else {
                DroneDebuggerOptions.clearAreaShowWidgetId();
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double mouseButton) {
        return this.isDroneValid() && this.programmerUnit.getScrollBar().func_231043_a_(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.isDroneValid() && this.programmerUnit.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public boolean isToggleable() {
        return false;
    }

    @Override
    public boolean displaySettingsHeader() {
        return false;
    }

    private class DebugWidgetAreaRenderer
    extends ProgrammerWidgetAreaRenderer {
        DebugWidgetAreaRenderer(Screen parent, List<IProgWidget> progWidgets, int guiLeft, int guiTop, Rectangle2d bounds, int translatedX, int translatedY, int lastZoom) {
            super(parent, progWidgets, guiLeft, guiTop, bounds, translatedX, translatedY, lastZoom);
            TileEntityProgrammer.updatePuzzleConnections(progWidgets);
        }

        @Override
        protected void addAdditionalInfoToTooltip(IProgWidget widget, List<ITextComponent> tooltip) {
            if (!DroneDebuggerOptions.this.isDroneValid()) {
                return;
            }
            int widgetId = DroneDebuggerOptions.this.selectedDrone.getProgWidgets().indexOf(widget);
            DroneDebugEntry entry = DroneDebuggerOptions.this.selectedDrone.getDebugger().getDebugEntry(widgetId);
            if (entry != null) {
                long elapsed = (System.currentTimeMillis() - entry.getReceivedTime()) / 50L;
                tooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.debug.lastMessage", PneumaticCraftUtils.convertTicksToMinutesAndSeconds(elapsed, true)).func_240699_a_(TextFormatting.AQUA));
                tooltip.add((ITextComponent)new StringTextComponent("  \"").func_230529_a_((ITextComponent)PneumaticCraftUtils.xlate(entry.getMessage(), new Object[0])).func_240702_b_("\"  ").func_240701_a_(new TextFormatting[]{TextFormatting.AQUA, TextFormatting.ITALIC}));
                if (entry.hasCoords()) {
                    tooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.debug.hasPositions", new Object[0]).func_240699_a_(TextFormatting.YELLOW));
                    tooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.debug.clickToShow", new Object[0]).func_240699_a_(TextFormatting.GREEN));
                }
            }
            if (widget instanceof IAreaProvider) {
                if (widgetId == areaShowWidgetId) {
                    tooltip.add((ITextComponent)new StringTextComponent("Right-Click: ").func_230529_a_((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.stopShowingArea", new Object[0])).func_240699_a_(TextFormatting.GREEN));
                } else {
                    tooltip.add((ITextComponent)new StringTextComponent("Right-Click: ").func_230529_a_((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.showArea", new Object[0])).func_240699_a_(TextFormatting.GREEN));
                }
            }
        }

        @Override
        protected void renderAdditionally(MatrixStack matrixStack) {
            if (DroneDebuggerOptions.this.isDroneValid() && DroneDebuggerOptions.this.selectedDrone.getActiveWidget() != null) {
                this.drawBorder(matrixStack, DroneDebuggerOptions.this.selectedDrone.getActiveWidget(), -16711936);
                if (areaShowWidgetId >= 0) {
                    this.drawBorder(matrixStack, DroneDebuggerOptions.this.selectedDrone.getProgWidgets().get(areaShowWidgetId), -1606352992, 2);
                }
            }
        }
    }
}

