/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.ICheckboxWidget;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticScreenBase;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.option_screens.NullOptions;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.pneumatic_armor.ArmorUpgradeClientRegistry;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.CoreComponentsHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiArmorMainScreen
extends GuiPneumaticScreenBase
implements IGuiScreen {
    private static final TextFormatting[] TITLE_PREFIX = new TextFormatting[]{TextFormatting.AQUA, TextFormatting.UNDERLINE};
    public static final ItemStack[] ARMOR_STACKS = new ItemStack[]{new ItemStack((IItemProvider)ModItems.PNEUMATIC_BOOTS.get()), new ItemStack((IItemProvider)ModItems.PNEUMATIC_LEGGINGS.get()), new ItemStack((IItemProvider)ModItems.PNEUMATIC_CHESTPLATE.get()), new ItemStack((IItemProvider)ModItems.PNEUMATIC_HELMET.get())};
    private static GuiArmorMainScreen instance;
    private static int pageNumber;
    private final List<UpgradeOption> upgradeOptions = new ArrayList<UpgradeOption>();
    private boolean inInitPhase = true;
    private final UpgradeOption nullOptionsPage = new UpgradeOption(new NullOptions(this), PneumaticRegistry.RL("null"), new ItemStack((IItemProvider)Items.field_221803_eL));

    private GuiArmorMainScreen() {
        super((ITextComponent)new StringTextComponent("Main Screen"));
    }

    public static GuiArmorMainScreen getInstance() {
        return instance;
    }

    public static void initHelmetCoreComponents() {
        if (instance == null) {
            instance = new GuiArmorMainScreen();
            MainWindow mw = Minecraft.func_71410_x().func_228018_at_();
            instance.func_231158_b_(Minecraft.func_71410_x(), mw.func_198107_o(), mw.func_198087_p());
            int i = 1;
            while (i < GuiArmorMainScreen.instance.upgradeOptions.size()) {
                pageNumber = i++;
                instance.func_231160_c_();
            }
            pageNumber = 0;
            GuiArmorMainScreen.instance.inInitPhase = false;
        }
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.xSize = this.field_230708_k_;
        this.ySize = this.field_230709_l_;
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        this.upgradeOptions.clear();
        this.addPages();
        int xPos = 200;
        int yPos = 5;
        int buttonWidth = this.field_230712_o_.func_238414_a_((ITextProperties)PneumaticCraftUtils.xlate("pneumaticcraft.armor.upgrade.core_components", new Object[0]));
        for (UpgradeOption opt : this.upgradeOptions) {
            buttonWidth = Math.max(buttonWidth, this.field_230712_o_.func_238414_a_((ITextProperties)opt.page.getPageName()));
        }
        for (int i = 0; i < this.upgradeOptions.size(); ++i) {
            int idx = i;
            WidgetButtonExtended button = new WidgetButtonExtended(xPos, yPos, buttonWidth + 10, 20, (ITextComponent)this.upgradeOptions.get(i).page.getPageName(), b -> this.setPage(idx));
            button.setRenderStacks(this.upgradeOptions.get(i).icons).setIconPosition(WidgetButtonExtended.IconPosition.RIGHT).setIconSpacing(12);
            if (pageNumber == i) {
                button.field_230693_o_ = false;
            }
            this.func_230480_a_(button);
            if ((yPos += 22) <= this.ySize - 22) continue;
            yPos = 5;
            xPos += buttonWidth + 55;
        }
        if ((pageNumber = Math.min(pageNumber, this.upgradeOptions.size() - 1)) < 0 && !this.upgradeOptions.isEmpty()) {
            pageNumber = 0;
        }
        ICheckboxWidget checkBox = PneumaticRegistry.getInstance().getHelmetRegistry().makeKeybindingCheckBox(this.getCurrentOptionsPage().upgradeID, 40, 25, -1, null);
        if (this.getCurrentOptionsPage().page.isToggleable()) {
            this.func_230480_a_(checkBox.asWidget());
        }
        this.getCurrentOptionsPage().page.populateGui(this);
    }

    private void setPage(int newPage) {
        pageNumber = newPage;
        this.func_231160_c_();
    }

    private UpgradeOption getCurrentOptionsPage() {
        if (pageNumber >= 0 && pageNumber < this.upgradeOptions.size()) {
            return this.upgradeOptions.get(pageNumber);
        }
        return this.nullOptionsPage;
    }

    @Override
    protected ResourceLocation getTexture() {
        return null;
    }

    private void addPages() {
        for (EquipmentSlotType slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            List<IArmorUpgradeHandler<?>> upgradeHandlers = ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot);
            for (int i = 0; i < upgradeHandlers.size(); ++i) {
                IArmorUpgradeClientHandler<?> clientHandler;
                IOptionPage optionPage;
                if (!this.inInitPhase && !CommonArmorHandler.getHandlerForPlayer().isUpgradeInserted(slot, i) && (slot != EquipmentSlotType.HEAD || i != 0)) continue;
                IArmorUpgradeHandler<?> handler = upgradeHandlers.get(i);
                if (!this.inInitPhase && !ItemPneumaticArmor.isPneumaticArmorPiece((PlayerEntity)Minecraft.func_71410_x().field_71439_g, slot) && !(handler instanceof CoreComponentsHandler) || (optionPage = (clientHandler = ArmorUpgradeClientRegistry.getInstance().getClientHandler(handler.getID())).getGuiOptionsPage(this)) == null) continue;
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                stacks.add(ARMOR_STACKS[handler.getEquipmentSlot().func_188454_b()]);
                Arrays.stream(handler.getRequiredUpgrades()).map(EnumUpgrade::getItemStack).forEach(stacks::add);
                this.upgradeOptions.add(new UpgradeOption(optionPage, handler.getID(), stacks.toArray(new ItemStack[0])));
            }
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int x, int y, float partialTicks) {
        this.func_230446_a_(matrixStack);
        IOptionPage optionPage = this.getCurrentOptionsPage().page;
        optionPage.renderPre(matrixStack, x, y, partialTicks);
        GuiArmorMainScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.getCurrentOptionsPage().page.getPageName().func_230532_e_().func_240701_a_(TITLE_PREFIX), (int)100, (int)12, (int)-1);
        if (optionPage.displaySettingsHeader()) {
            GuiArmorMainScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.settings", new Object[0]).func_240699_a_(TextFormatting.DARK_AQUA), (int)100, (int)optionPage.settingsYposition(), (int)-1);
        }
        super.func_230430_a_(matrixStack, x, y, partialTicks);
        optionPage.renderPost(matrixStack, x, y, partialTicks);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        IOptionPage optionPage = this.getCurrentOptionsPage().page;
        optionPage.tick();
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        return this.getCurrentOptionsPage().page.keyPressed(keyCode, scanCode, modifiers) || super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        return this.getCurrentOptionsPage().page.keyReleased(keyCode, scanCode, modifiers) || super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        return this.getCurrentOptionsPage().page.mouseClicked(mouseX, mouseY, mouseButton) || super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double dir) {
        return this.getCurrentOptionsPage().page.mouseScrolled(mouseX, mouseY, dir) || super.func_231043_a_(mouseX, mouseY, dir);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.getCurrentOptionsPage().page.mouseDragged(mouseX, mouseY, button, dragX, dragY) || super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public <T extends Widget> T addWidget(T w) {
        return this.func_230480_a_(w);
    }

    @Override
    public List<Widget> getWidgetList() {
        return ImmutableList.copyOf((Collection)this.field_230710_m_);
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.field_230712_o_;
    }

    @Override
    public void setFocusedWidget(Widget w) {
        this.func_231035_a_((IGuiEventListener)w);
    }

    public boolean func_231177_au__() {
        return false;
    }

    private static class UpgradeOption {
        private final IOptionPage page;
        private final ResourceLocation upgradeID;
        private final ItemStack[] icons;

        UpgradeOption(IOptionPage page, ResourceLocation upgradeID, ItemStack ... icons) {
            this.page = page;
            this.upgradeID = upgradeID;
            this.icons = icons;
        }
    }
}

