/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.inventory.ContainerThermalCompressor;
import me.desht.pneumaticcraft.common.tileentity.TileEntityThermalCompressor;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiThermalCompressor
extends GuiPneumaticContainerBase<ContainerThermalCompressor, TileEntityThermalCompressor> {
    private final WidgetTemperatureSided[] tempWidgets = new WidgetTemperatureSided[4];

    public GuiThermalCompressor(ContainerThermalCompressor container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        for (Direction d : DirectionUtil.HORIZONTALS) {
            WidgetTemperatureSided widgetTemperatureSided = (WidgetTemperatureSided)new WidgetTemperatureSided(d).setDrawText(false);
            this.tempWidgets[d.func_176736_b()] = widgetTemperatureSided;
            this.func_230480_a_(widgetTemperatureSided);
        }
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_THERMAL_COMPRESSOR;
    }

    @Override
    protected PointXY getGaugeLocation() {
        int xStart = (this.field_230708_k_ - this.field_146999_f) / 2;
        int yStart = (this.field_230709_l_ - this.field_147000_g) / 2;
        return new PointXY(xStart + (int)((double)this.field_146999_f * 0.82), yStart + this.field_147000_g / 4 + 4);
    }

    private int getTemperatureDifferential(Direction side) {
        IHeatExchangerLogic l1 = ((TileEntityThermalCompressor)this.te).getHeatExchanger(side);
        IHeatExchangerLogic l2 = ((TileEntityThermalCompressor)this.te).getHeatExchanger(side.func_176734_d());
        return l1 != null && l2 != null ? Math.abs(l1.getTemperatureAsInt() - l2.getTemperatureAsInt()) : 0;
    }

    @Override
    protected void addPressureStatInfo(List<ITextComponent> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        double prod = ((TileEntityThermalCompressor)this.te).airProduced(Direction.NORTH) + ((TileEntityThermalCompressor)this.te).airProduced(Direction.EAST);
        if (prod > 0.0 && ((TileEntityThermalCompressor)this.te).getRedstoneController().shouldRun()) {
            pressureStatText.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.producingAir", PneumaticCraftUtils.roundNumberTo(prod, 1)).func_240699_a_(TextFormatting.BLACK));
        }
    }

    @Override
    protected void addProblems(List<ITextComponent> curInfo) {
        super.addProblems(curInfo);
        if (this.getTemperatureDifferential(Direction.NORTH) < 10 && this.getTemperatureDifferential(Direction.EAST) < 10) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.thermal_compressor.no_temp_diff", new Object[0]));
        }
    }

    @Override
    protected void addWarnings(List<ITextComponent> curInfo) {
        super.addWarnings(curInfo);
        int dns = this.getTemperatureDifferential(Direction.NORTH);
        int dew = this.getTemperatureDifferential(Direction.EAST);
        if (dns < 20 && dew >= 10 && dew < 20 || dew < 20 && dns >= 10 && dns < 20) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.thermal_compressor.poor_temp_diff", new Object[0]));
        }
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (Direction d : DirectionUtil.HORIZONTALS) {
            int t = Objects.requireNonNull(((TileEntityThermalCompressor)this.te).getHeatExchanger(d)).getTemperatureAsInt();
            this.tempWidgets[d.func_176736_b()].setTemperature(t);
            min = Math.min(min, t);
            max = Math.max(max, t);
        }
        int rounding = this.getRounding(max - min);
        TemperatureRange range = TemperatureRange.of(Math.max(0, WidgetTemperature.roundDownK(min - 1, rounding)), Math.min(2273, WidgetTemperature.roundUpK(max + 1, rounding)));
        int interval = WidgetTemperature.calcInterval(range.getMax() - range.getMin());
        for (WidgetTemperatureSided temp : this.tempWidgets) {
            temp.setTotalRange(range);
            temp.setTickInterval(interval);
        }
    }

    private int getRounding(int range) {
        if (range < 100) {
            return 10;
        }
        if (range < 250) {
            return 25;
        }
        if (range < 500) {
            return 50;
        }
        return 100;
    }

    static int getWidgetX(Direction side) {
        switch (side) {
            case SOUTH: {
                return 56;
            }
            case NORTH: {
                return 66;
            }
            case WEST: {
                return 89;
            }
            case EAST: {
                return 99;
            }
        }
        throw new IllegalArgumentException("invalid side " + side);
    }

    private class WidgetTemperatureSided
    extends WidgetTemperature {
        private final Direction side;

        WidgetTemperatureSided(Direction side) {
            super(GuiThermalCompressor.this.field_147003_i + GuiThermalCompressor.getWidgetX(side), GuiThermalCompressor.this.field_147009_r + 20, TemperatureRange.of(0, 2000), 273, 200);
            this.side = side;
        }

        @Override
        public void addTooltip(double mouseX, double mouseY, List<ITextComponent> curTip, boolean shift) {
            curTip.add(HeatUtil.formatHeatString(this.side, this.getTemperature()));
        }

        @Override
        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            super.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
            String s = this.side.toString().substring(0, 1).toUpperCase();
            GuiUtils.drawScaledText(matrixStack, GuiThermalCompressor.this.field_230712_o_, s, this.field_230690_l_ + 8, this.field_230691_m_ - 4, 0x404040, 0.5f);
        }
    }
}

