/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.gui.GuiPastebin;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.ProgrammerWidgetAreaRenderer;
import me.desht.pneumaticcraft.client.gui.programmer.GuiProgWidgetOptionBase;
import me.desht.pneumaticcraft.client.gui.programmer.ProgWidgetGuiManager;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetRadioButton;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.client.util.ProgWidgetRenderer;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.inventory.ContainerProgrammer;
import me.desht.pneumaticcraft.common.item.ItemGPSAreaTool;
import me.desht.pneumaticcraft.common.item.ItemGPSTool;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.network.PacketProgrammerUpdate;
import me.desht.pneumaticcraft.common.network.PacketUpdateTextfield;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetCoordinate;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetCoordinateOperator;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetStart;
import me.desht.pneumaticcraft.common.thirdparty.ThirdPartyManager;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiProgrammer
extends GuiPneumaticContainerBase<ContainerProgrammer, TileEntityProgrammer> {
    private GuiPastebin pastebinGui;
    private WidgetButtonExtended importButton;
    private WidgetButtonExtended exportButton;
    private WidgetButtonExtended allWidgetsButton;
    private WidgetCheckBox showInfo;
    private WidgetCheckBox showFlow;
    private WidgetTextField nameField;
    private WidgetTextField filterField;
    private WidgetButtonExtended undoButton;
    private WidgetButtonExtended redoButton;
    private WidgetButtonExtended convertToRelativeButton;
    private final List<IProgWidget> visibleSpawnWidgets = new ArrayList<IProgWidget>();
    private final List<RemovingWidget> removingWidgets = new ArrayList<RemovingWidget>();
    private BitSet filteredSpawnWidgets;
    private ProgrammerWidgetAreaRenderer programmerUnit;
    private IProgWidget draggingWidget;
    private int lastMouseX;
    private int lastMouseY;
    private double dragMouseStartX;
    private double dragMouseStartY;
    private double dragWidgetStartX;
    private double dragWidgetStartY;
    private boolean draggingBG;
    private static final int FAULT_MARGIN = 4;
    private int widgetPage;
    private int maxPage;
    private boolean showingAllWidgets;
    private int showingWidgetProgress;
    private int oldShowingWidgetProgress;
    private static final Rectangle2d PROGRAMMER_STD_RES = new Rectangle2d(5, 17, 294, 154);
    private static final Rectangle2d PROGRAMMER_HI_RES = new Rectangle2d(5, 17, 644, 410);
    private static final int WIDGET_X_SPACING = 22;
    private final boolean hiRes;
    private IProgWidget.WidgetDifficulty programmerDifficulty;
    private static final ITextComponent TDR = new StringTextComponent("\u25e2");
    private static final ITextComponent TUL = new StringTextComponent("\u25e4");

    public GuiProgrammer(ContainerProgrammer container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.hiRes = container.isHiRes();
        this.field_146999_f = this.hiRes ? 700 : 350;
        this.field_147000_g = this.hiRes ? 512 : 256;
        this.programmerDifficulty = (IProgWidget.WidgetDifficulty)((Object)ConfigHelper.client().general.programmerDifficulty.get());
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        if (this.pastebinGui != null && this.pastebinGui.outputTag != null) {
            if (this.pastebinGui.shouldMerge) {
                List<IProgWidget> newWidgets = ((TileEntityProgrammer)this.te).mergeWidgetsFromNBT(this.pastebinGui.outputTag);
                TileEntityProgrammer.updatePuzzleConnections(newWidgets);
                ((TileEntityProgrammer)this.te).setProgWidgets(newWidgets, ClientUtils.getClientPlayer());
            } else {
                ((TileEntityProgrammer)this.te).readProgWidgetsFromNBT(this.pastebinGui.outputTag);
            }
            this.pastebinGui = null;
            NetworkHandler.sendToServer(new PacketProgrammerUpdate((TileEntityProgrammer)this.te));
            ((TileEntityProgrammer)this.te).recentreStartPiece = true;
        }
        if (this.programmerUnit != null) {
            ((TileEntityProgrammer)this.te).translatedX = this.programmerUnit.getTranslatedX();
            ((TileEntityProgrammer)this.te).translatedY = this.programmerUnit.getTranslatedY();
            ((TileEntityProgrammer)this.te).zoomState = this.programmerUnit.getLastZoom();
        }
        Rectangle2d bounds = this.getProgrammerBounds();
        this.programmerUnit = new ProgrammerWidgetAreaRenderer((Screen)this, ((TileEntityProgrammer)this.te).progWidgets, this.field_147003_i, this.field_147009_r, bounds, ((TileEntityProgrammer)this.te).translatedX, ((TileEntityProgrammer)this.te).translatedY, ((TileEntityProgrammer)this.te).zoomState);
        this.func_230480_a_(this.programmerUnit.getScrollBar());
        int xStart = (this.field_230708_k_ - this.field_146999_f) / 2;
        int yStart = (this.field_230709_l_ - this.field_147000_g) / 2;
        int xRight = this.getProgrammerBounds().func_199318_a() + this.getProgrammerBounds().func_199316_c();
        int yBottom = this.getProgrammerBounds().func_199319_b() + this.getProgrammerBounds().func_199317_d() + 3;
        this.importButton = new WidgetButtonExtended(xStart + xRight + 2, yStart + 3, 20, 15, "\u27f5").withTag("import").setTooltipKey("pneumaticcraft.gui.programmer.button.import", new Object[0]);
        this.func_230480_a_(this.importButton);
        this.exportButton = new WidgetButtonExtended(xStart + xRight + 2, yStart + 20, 20, 15, "\u27f6").withTag("export");
        this.func_230480_a_(this.exportButton);
        this.func_230480_a_(new WidgetButtonExtended(xStart + xRight - 3, yStart + yBottom, 13, 10, "\u25c0", b -> this.adjustPage(-1)));
        this.func_230480_a_(new WidgetButtonExtended(xStart + xRight + 34, yStart + yBottom, 13, 10, "\u25b6", b -> this.adjustPage(1)));
        this.allWidgetsButton = new WidgetButtonExtended(xStart + xRight + 22, yStart + yBottom - 16, 10, 10, "\u25e4", b -> this.toggleShowWidgets());
        this.allWidgetsButton.setTooltipText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.openPanel.tooltip", new Object[0]));
        this.func_230480_a_(this.allWidgetsButton);
        WidgetRadioButton.Builder<DifficultyButton> rbb = WidgetRadioButton.Builder.create();
        for (IProgWidget.WidgetDifficulty wd : IProgWidget.WidgetDifficulty.values()) {
            DifficultyButton dButton = new DifficultyButton(xStart + xRight - 36, yStart + yBottom + 29 + wd.ordinal() * 12, -12566464, wd, b -> this.updateDifficulty(wd));
            dButton.setTooltip((ITextComponent)PneumaticCraftUtils.xlate(wd.getTooltipTranslationKey(), new Object[0]));
            rbb.addRadioButton(dButton, wd == this.programmerDifficulty);
        }
        rbb.build(this::func_230480_a_);
        this.func_230480_a_(new WidgetButtonExtended(xStart + 5, yStart + yBottom + 4, 87, 20, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.showStart", new Object[0]), b -> this.gotoStart()).setTooltipText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.showStart.tooltip", new Object[0])));
        this.func_230480_a_(new WidgetButtonExtended(xStart + 5, yStart + yBottom + 26, 87, 20, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.showLatest", new Object[0]), b -> this.gotoLatest()).setTooltipText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.showLatest.tooltip", new Object[0])));
        this.showInfo = new WidgetCheckBox(xStart + 5, yStart + yBottom + 49, -12566464, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.checkbox.showInfo", new Object[0])).setChecked(((TileEntityProgrammer)this.te).showInfo);
        this.func_230480_a_(this.showInfo);
        this.showFlow = new WidgetCheckBox(xStart + 5, yStart + yBottom + 61, -12566464, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.checkbox.showFlow", new Object[0])).setChecked(((TileEntityProgrammer)this.te).showFlow);
        this.func_230480_a_(this.showFlow);
        WidgetButtonExtended pastebinButton = new WidgetButtonExtended(this.field_147003_i - 24, this.field_147009_r + 44, 20, 20, "", b -> this.pastebin());
        pastebinButton.setTooltipText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.button.pastebinButton", new Object[0]));
        pastebinButton.setRenderedIcon(Textures.GUI_PASTEBIN_ICON_LOCATION);
        this.func_230480_a_(pastebinButton);
        this.undoButton = new WidgetButtonExtended(this.field_147003_i - 24, this.field_147009_r + 2, 20, 20, "").withTag("undo");
        this.redoButton = new WidgetButtonExtended(this.field_147003_i - 24, this.field_147009_r + 23, 20, 20, "").withTag("redo");
        WidgetButtonExtended clearAllButton = new WidgetButtonExtended(this.field_147003_i - 24, this.field_147009_r + 65, 20, 20, StringTextComponent.field_240750_d_, b -> this.clear());
        this.convertToRelativeButton = new WidgetButtonExtended(this.field_147003_i - 24, this.field_147009_r + 86, 20, 20, "R", b -> this.convertToRelative());
        this.undoButton.setRenderedIcon(Textures.GUI_UNDO_ICON_LOCATION);
        this.redoButton.setRenderedIcon(Textures.GUI_REDO_ICON_LOCATION);
        clearAllButton.setRenderedIcon(Textures.GUI_DELETE_ICON_LOCATION);
        this.undoButton.setTooltipText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.undoButton.tooltip", new Object[0]));
        this.redoButton.setTooltipText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.redoButton.tooltip", new Object[0]));
        clearAllButton.setTooltipText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.clearAllButton.tooltip", new Object[0]));
        this.func_230480_a_(this.undoButton);
        this.func_230480_a_(this.redoButton);
        this.func_230480_a_(clearAllButton);
        this.func_230480_a_(this.convertToRelativeButton);
        this.addLabel(this.field_230704_d_, this.field_147003_i + 7, this.field_147009_r + 5, -12566464);
        this.field_230712_o_.getClass();
        this.nameField = new WidgetTextField(this.field_230712_o_, this.field_147003_i + xRight - 99, this.field_147009_r + 5, 98, 9);
        this.nameField.func_212954_a(s -> this.updateDroneName());
        this.func_230480_a_(this.nameField);
        this.field_230712_o_.getClass();
        this.filterField = new FilterTextField(this.field_230712_o_, this.field_147003_i + 78, this.field_147009_r + 26, 100, 9);
        this.filterField.func_212954_a(s -> this.filterSpawnWidgets());
        this.func_230480_a_(this.filterField);
        TranslationTextComponent name = PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.name", new Object[0]);
        this.addLabel((ITextComponent)name, this.field_147003_i + xRight - 102 - this.field_230712_o_.func_238414_a_((ITextProperties)name), this.field_147009_r + 5, -12566464);
        this.updateVisibleProgWidgets();
        for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
            if (this.programmerUnit.isOutsideProgrammingArea(widget)) continue;
            return;
        }
        this.programmerUnit.gotoPiece(GuiProgrammer.findWidget(((TileEntityProgrammer)this.te).progWidgets, ProgWidgetStart.class));
    }

    public boolean func_231177_au__() {
        return (Boolean)ConfigHelper.client().general.programmerGuiPauses.get();
    }

    public static void onCloseFromContainer() {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiProgrammer) {
            GuiProgrammer p = (GuiProgrammer)Minecraft.func_71410_x().field_71462_r;
            p.func_231164_f_();
        }
    }

    private Rectangle2d getProgrammerBounds() {
        return this.hiRes ? PROGRAMMER_HI_RES : PROGRAMMER_STD_RES;
    }

    private int getWidgetTrayRight() {
        return this.hiRes ? 672 : 322;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return this.hiRes ? Textures.GUI_PROGRAMMER_LARGE : Textures.GUI_PROGRAMMER_STD;
    }

    private void updateVisibleProgWidgets() {
        this.updateVisibleProgWidgets(this.programmerDifficulty);
    }

    private void updateVisibleProgWidgets(IProgWidget.WidgetDifficulty difficulty) {
        int y = 0;
        int page = 0;
        int x = this.getWidgetTrayRight() - this.maxPage * 22;
        boolean showAllWidgets = this.showingWidgetProgress == 22 * this.maxPage && this.showingAllWidgets;
        this.filterField.func_146189_e(showAllWidgets);
        this.maxPage = 0;
        this.visibleSpawnWidgets.clear();
        int idx = 0;
        int nWidgets = ModProgWidgets.PROG_WIDGETS.get().getValues().size();
        for (ProgWidgetType type : ModProgWidgets.PROG_WIDGETS.get().getValues()) {
            IProgWidget widget = IProgWidget.create(type);
            if (widget.isAvailable() && widget.isDifficultyOK(difficulty)) {
                widget.setY(y + 40);
                widget.setX(showAllWidgets ? x : this.getWidgetTrayRight());
                int widgetHeight = widget.getHeight() / 2 + (widget.hasStepOutput() ? 5 : 0) + 1;
                y += widgetHeight;
                if (showAllWidgets || page == this.widgetPage) {
                    this.visibleSpawnWidgets.add(widget);
                }
                if (y > this.field_147000_g - (this.hiRes ? 260 : 160)) {
                    y = 0;
                    x += 22;
                    ++page;
                    if (idx < nWidgets - 1) {
                        ++this.maxPage;
                    }
                }
            }
            ++idx;
        }
        ++this.maxPage;
        this.filterField.field_230690_l_ = Math.min(this.field_147003_i + this.getWidgetTrayRight() - 25 - this.filterField.func_230998_h_(), this.field_147003_i + this.getWidgetTrayRight() - this.maxPage * 22 - 2);
        this.filterSpawnWidgets();
        if (this.widgetPage >= this.maxPage) {
            this.widgetPage = this.maxPage - 1;
            this.updateVisibleProgWidgets();
        }
    }

    private void filterSpawnWidgets() {
        String filterText = this.filterField.func_146179_b().trim();
        if (!this.visibleSpawnWidgets.isEmpty() && !filterText.isEmpty()) {
            this.filteredSpawnWidgets = new BitSet(this.visibleSpawnWidgets.size());
            for (int i = 0; i < this.visibleSpawnWidgets.size(); ++i) {
                IProgWidget widget = this.visibleSpawnWidgets.get(i);
                String widgetName = I18n.func_135052_a((String)widget.getTranslationKey(), (Object[])new Object[0]);
                this.filteredSpawnWidgets.set(i, widgetName.toLowerCase().contains(filterText.toLowerCase()));
            }
        } else {
            this.filteredSpawnWidgets = null;
        }
    }

    @Override
    protected boolean shouldAddInfoTab() {
        return false;
    }

    private void updateDroneName() {
        ItemStack stack = ((TileEntityProgrammer)this.te).getItemInProgrammingSlot();
        if (stack != ItemStack.field_190927_a && !stack.func_200301_q().func_150261_e().equals(this.nameField.func_146179_b())) {
            stack.func_200302_a((ITextComponent)new StringTextComponent(this.nameField.func_146179_b()));
            this.sendDelayed(5);
        }
    }

    @Override
    protected void doDelayedAction() {
        NetworkHandler.sendToServer(new PacketUpdateTextfield(this.te, 0));
    }

    private void adjustPage(int dir) {
        this.widgetPage += dir;
        if (this.widgetPage < 0) {
            this.widgetPage = this.maxPage - 1;
        } else if (this.widgetPage >= this.maxPage) {
            this.widgetPage = 0;
        }
        this.updateVisibleProgWidgets();
    }

    private void toggleShowWidgets() {
        this.showingAllWidgets = !this.showingAllWidgets;
        this.allWidgetsButton.func_238482_a_(this.showingAllWidgets ? TDR : TUL);
        this.updateVisibleProgWidgets();
        this.filterField.func_146195_b(this.showingAllWidgets);
    }

    private void updateDifficulty(IProgWidget.WidgetDifficulty difficulty) {
        this.programmerDifficulty = difficulty;
        ConfigHelper.setProgrammerDifficulty(difficulty);
        if (this.showingAllWidgets) {
            this.toggleShowWidgets();
        }
        this.updateVisibleProgWidgets(difficulty);
    }

    private void gotoLatest() {
        if (((TileEntityProgrammer)this.te).progWidgets.size() > 0) {
            this.programmerUnit.gotoPiece(((TileEntityProgrammer)this.te).progWidgets.get(((TileEntityProgrammer)this.te).progWidgets.size() - 1));
        }
    }

    private void gotoStart() {
        this.programmerUnit.gotoPiece(GuiProgrammer.findWidget(((TileEntityProgrammer)this.te).progWidgets, ProgWidgetStart.class));
    }

    private void pastebin() {
        CompoundNBT mainTag = ((TileEntityProgrammer)this.te).writeProgWidgetsToNBT(new CompoundNBT());
        this.pastebinGui = new GuiPastebin((Screen)this, mainTag);
        this.field_230706_i_.func_147108_a((Screen)this.pastebinGui);
    }

    private void clear() {
        ((TileEntityProgrammer)this.te).progWidgets.forEach(w -> this.removingWidgets.add(new RemovingWidget((IProgWidget)w)));
        ((TileEntityProgrammer)this.te).progWidgets.clear();
        NetworkHandler.sendToServer(new PacketProgrammerUpdate((TileEntityProgrammer)this.te));
    }

    private void convertToRelative() {
        for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
            if (!(widget instanceof ProgWidgetStart)) continue;
            this.generateRelativeOperators((ProgWidgetCoordinateOperator)widget.getOutputWidget(), null, false);
            break;
        }
    }

    @Override
    protected PointXY getInvNameOffset() {
        return null;
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return false;
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        super.func_230451_b_(matrixStack, x, y);
        int xRight = this.getProgrammerBounds().func_199318_a() + this.getProgrammerBounds().func_199316_c();
        int yBottom = this.getProgrammerBounds().func_199319_b() + this.getProgrammerBounds().func_199317_d();
        String str = this.widgetPage + 1 + "/" + this.maxPage;
        this.field_230712_o_.func_238421_b_(matrixStack, str, (float)(xRight + 22) - (float)this.field_230712_o_.func_78256_a(str) / 2.0f, (float)(yBottom + 4), 0x404040);
        this.field_230712_o_.func_238422_b_(matrixStack, PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.difficulty", new Object[0]).func_241878_f(), (float)(xRight - 36), (float)(yBottom + 20), 0x404040);
        if (this.showingWidgetProgress == 0) {
            this.programmerUnit.renderForeground(matrixStack, x, y, this.draggingWidget, this.field_230712_o_);
        }
        for (int i = 0; i < this.visibleSpawnWidgets.size(); ++i) {
            IProgWidget widget = this.visibleSpawnWidgets.get(i);
            if (widget == this.draggingWidget || x - this.field_147003_i < widget.getX() || y - this.field_147009_r < widget.getY() || x - this.field_147003_i > widget.getX() + widget.getWidth() / 2 || y - this.field_147009_r > widget.getY() + widget.getHeight() / 2 || this.showingAllWidgets && this.filteredSpawnWidgets != null && !this.filteredSpawnWidgets.get(i)) continue;
            ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
            widget.getTooltip(tooltip);
            ThirdPartyManager.instance().getDocsProvider().addTooltip(tooltip, this.showingAllWidgets);
            if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
                tooltip.add((ITextComponent)new StringTextComponent(widget.getType().getRegistryName().toString()).func_240699_a_(TextFormatting.DARK_GRAY));
            }
            if (tooltip.isEmpty()) continue;
            this.drawHoveringString(matrixStack, tooltip, x - this.field_147003_i, y - this.field_147009_r, this.field_230712_o_);
        }
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_230446_a_(matrixStack);
        this.bindGuiTexture();
        int xStart = (this.field_230708_k_ - this.field_146999_f) / 2;
        int yStart = (this.field_230709_l_ - this.field_147000_g) / 2;
        GuiProgrammer.func_238463_a_((MatrixStack)matrixStack, (int)xStart, (int)yStart, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (int)this.field_146999_f, (int)this.field_147000_g);
        super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
        this.programmerUnit.render(matrixStack, mouseX, mouseY, this.showFlow.checked, this.showInfo.checked && this.showingWidgetProgress == 0);
        if (this.showingWidgetProgress > 0) {
            int xRight = this.getProgrammerBounds().func_199318_a() + this.getProgrammerBounds().func_199316_c();
            int yBottom = this.getProgrammerBounds().func_199319_b() + this.getProgrammerBounds().func_199317_d();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.bindGuiTexture();
            int width = (int)MathHelper.func_219799_g((float)partialTicks, (float)this.oldShowingWidgetProgress, (float)this.showingWidgetProgress);
            for (int i = 0; i < width; ++i) {
                GuiProgrammer.func_238463_a_((MatrixStack)matrixStack, (int)(xStart + xRight + 21 - i), (int)(yStart + 36), (float)(xRight + 24), (float)36.0f, (int)1, (int)(yBottom - 35), (int)this.field_146999_f, (int)this.field_147000_g);
            }
            GuiProgrammer.func_238463_a_((MatrixStack)matrixStack, (int)(xStart + xRight + 20 - width), (int)(yStart + 36), (float)(xRight + 20), (float)36.0f, (int)2, (int)(yBottom - 35), (int)this.field_146999_f, (int)this.field_147000_g);
            if (this.showingAllWidgets && this.draggingWidget != null) {
                this.toggleShowWidgets();
            }
        }
        RenderSystem.enableTexture();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        for (int i = 0; i < this.visibleSpawnWidgets.size(); ++i) {
            IProgWidget widget = this.visibleSpawnWidgets.get(i);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(widget.getX() + this.field_147003_i), (double)(widget.getY() + this.field_147009_r), 0.0);
            matrixStack.func_227862_a_(0.5f, 0.5f, 1.0f);
            if (this.showingAllWidgets && this.filteredSpawnWidgets != null && !this.filteredSpawnWidgets.get(i)) {
                ProgWidgetRenderer.renderProgWidget2d(matrixStack, widget, 48);
            } else {
                ProgWidgetRenderer.renderProgWidget2d(matrixStack, widget);
            }
            matrixStack.func_227865_b_();
        }
        float scale = this.programmerUnit.getScale();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(this.programmerUnit.getTranslatedX(), this.programmerUnit.getTranslatedY(), 0.0);
        matrixStack.func_227862_a_(scale, scale, 1.0f);
        if (this.draggingWidget != null) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(this.draggingWidget.getX() + this.field_147003_i), (double)(this.draggingWidget.getY() + this.field_147009_r), 0.0);
            matrixStack.func_227862_a_(0.5f, 0.5f, 1.0f);
            ProgWidgetRenderer.renderProgWidget2d(matrixStack, this.draggingWidget);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
        RenderSystem.disableBlend();
        if (!this.removingWidgets.isEmpty()) {
            this.drawRemovingWidgets(matrixStack);
        }
    }

    private void drawRemovingWidgets(MatrixStack matrixStack) {
        Iterator<RemovingWidget> iter = this.removingWidgets.iterator();
        int h = this.field_230706_i_.func_228018_at_().func_198087_p();
        float scale = this.programmerUnit.getScale();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(this.programmerUnit.getTranslatedX(), this.programmerUnit.getTranslatedY(), 0.0);
        matrixStack.func_227862_a_(scale, scale, 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        while (iter.hasNext()) {
            RemovingWidget rw = iter.next();
            IProgWidget w = rw.widget;
            if ((double)w.getY() + rw.ty > (double)((float)h / scale)) {
                iter.remove();
                continue;
            }
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)w.getX() + rw.tx + (double)this.field_147003_i, (double)w.getY() + rw.ty + (double)this.field_147009_r, 0.0);
            matrixStack.func_227862_a_(0.5f, 0.5f, 1.0f);
            ProgWidgetRenderer.renderProgWidget2d(matrixStack, w);
            matrixStack.func_227865_b_();
            rw.tick();
        }
        RenderSystem.disableBlend();
        matrixStack.func_227865_b_();
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            return super.func_231046_a_(keyCode, scanCode, modifiers);
        }
        if (this.nameField.func_230999_j_()) {
            return this.nameField.func_231046_a_(keyCode, scanCode, modifiers);
        }
        if (this.filterField.func_230999_j_() && keyCode != 258) {
            return this.filterField.func_231046_a_(keyCode, scanCode, modifiers);
        }
        switch (keyCode) {
            case 73: {
                return this.showWidgetDocs();
            }
            case 82: {
                if (this.exportButton.func_230449_g_()) {
                    NetworkHandler.sendToServer(new PacketGuiButton("program_when"));
                }
                return true;
            }
            case 258: {
                this.toggleShowWidgets();
                return true;
            }
            case 261: {
                if (ClientUtils.hasShiftDown()) {
                    this.clear();
                } else {
                    IProgWidget widget = this.programmerUnit.getHoveredWidget(this.lastMouseX, this.lastMouseY);
                    if (widget != null) {
                        this.removingWidgets.add(new RemovingWidget(widget));
                        ((TileEntityProgrammer)this.te).progWidgets.remove(widget);
                        NetworkHandler.sendToServer(new PacketProgrammerUpdate((TileEntityProgrammer)this.te));
                    }
                }
                return true;
            }
            case 90: {
                NetworkHandler.sendToServer(new PacketGuiButton("undo"));
                return true;
            }
            case 89: {
                NetworkHandler.sendToServer(new PacketGuiButton("redo"));
                return true;
            }
            case 268: {
                this.gotoStart();
                break;
            }
            case 269: {
                this.gotoLatest();
            }
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    private boolean showWidgetDocs() {
        int x = this.lastMouseX;
        int y = this.lastMouseY;
        IProgWidget hoveredWidget = this.programmerUnit.getHoveredWidget(x, y);
        if (hoveredWidget != null) {
            ThirdPartyManager.instance().getDocsProvider().showWidgetDocs(this.getWidgetId(hoveredWidget));
            return true;
        }
        for (IProgWidget widget : this.visibleSpawnWidgets) {
            if (widget == this.draggingWidget || x - this.field_147003_i < widget.getX() || y - this.field_147009_r < widget.getY() || x - this.field_147003_i > widget.getX() + widget.getWidth() / 2 || y - this.field_147009_r > widget.getY() + widget.getHeight() / 2) continue;
            ThirdPartyManager.instance().getDocsProvider().showWidgetDocs(this.getWidgetId(widget));
            return true;
        }
        return false;
    }

    private String getWidgetId(IProgWidget w) {
        return w == null ? null : w.getTypeID().func_110623_a();
    }

    @Override
    protected boolean shouldDrawBackground() {
        return false;
    }

    private boolean isValidPlaced(IProgWidget widget1) {
        IProgWidget iProgWidget;
        Rectangle2d draggingRect = new Rectangle2d(widget1.getX(), widget1.getY(), widget1.getWidth() / 2, widget1.getHeight() / 2);
        for (IProgWidget iProgWidget2 : ((TileEntityProgrammer)this.te).progWidgets) {
            if (iProgWidget2 == widget1 || !ClientUtils.intersects(draggingRect, iProgWidget2.getX(), iProgWidget2.getY(), (double)iProgWidget2.getWidth() / 2.0, (double)iProgWidget2.getHeight() / 2.0)) continue;
            return false;
        }
        IProgWidget[] parameters = widget1.getConnectedParameters();
        if (parameters != null) {
            for (IProgWidget widget : parameters) {
                if (widget == null || this.isValidPlaced(widget)) continue;
                return false;
            }
        }
        return (iProgWidget = widget1.getOutputWidget()) == null || this.isValidPlaced(iProgWidget);
    }

    private void handlePuzzleMargins() {
        List<ProgWidgetType<?>> parameters;
        ProgWidgetType<?> returnValue = this.draggingWidget.returnType();
        if (returnValue != null) {
            for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
                if (widget == this.draggingWidget || Math.abs(widget.getX() + widget.getWidth() / 2 - this.draggingWidget.getX()) > 4) continue;
                List<ProgWidgetType<?>> parameters2 = widget.getParameters();
                for (int i = 0; i < parameters2.size(); ++i) {
                    if (!widget.canSetParameter(i) || parameters2.get(i) != returnValue || Math.abs(widget.getY() + i * 11 - this.draggingWidget.getY()) > 4) continue;
                    this.setConnectingWidgetsToXY(this.draggingWidget, widget.getX() + widget.getWidth() / 2, widget.getY() + i * 11);
                    return;
                }
            }
        }
        if (!(parameters = this.draggingWidget.getParameters()).isEmpty()) {
            for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
                IProgWidget outerPiece = this.draggingWidget;
                if (outerPiece.returnType() != null) {
                    while (outerPiece.getConnectedParameters()[0] != null) {
                        outerPiece = outerPiece.getConnectedParameters()[0];
                    }
                }
                if (widget == this.draggingWidget || Math.abs(outerPiece.getX() + outerPiece.getWidth() / 2 - widget.getX()) > 4) continue;
                if (widget.returnType() != null) {
                    for (int i = 0; i < parameters.size(); ++i) {
                        if (!this.draggingWidget.canSetParameter(i) || parameters.get(i) != widget.returnType() || Math.abs(this.draggingWidget.getY() + i * 11 - widget.getY()) > 4) continue;
                        this.setConnectingWidgetsToXY(this.draggingWidget, widget.getX() - this.draggingWidget.getWidth() / 2 - (outerPiece.getX() - this.draggingWidget.getX()), widget.getY() - i * 11);
                    }
                    continue;
                }
                List<ProgWidgetType<?>> checkingPieceParms = widget.getParameters();
                for (int i = 0; i < checkingPieceParms.size(); ++i) {
                    if (!widget.canSetParameter(i + parameters.size()) || checkingPieceParms.get(i) != parameters.get(0) || Math.abs(widget.getY() + i * 11 - this.draggingWidget.getY()) > 4) continue;
                    this.setConnectingWidgetsToXY(this.draggingWidget, widget.getX() - this.draggingWidget.getWidth() / 2 - (outerPiece.getX() - this.draggingWidget.getX()), widget.getY() + i * 11);
                }
            }
        }
        if (this.draggingWidget.hasStepInput()) {
            for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
                if (!widget.hasStepOutput() || Math.abs(widget.getX() - this.draggingWidget.getX()) > 4 || Math.abs(widget.getY() + widget.getHeight() / 2 - this.draggingWidget.getY()) > 4) continue;
                this.setConnectingWidgetsToXY(this.draggingWidget, widget.getX(), widget.getY() + widget.getHeight() / 2);
            }
        }
        if (this.draggingWidget.hasStepOutput()) {
            for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
                if (!widget.hasStepInput() || Math.abs(widget.getX() - this.draggingWidget.getX()) > 4 || Math.abs(widget.getY() - this.draggingWidget.getY() - this.draggingWidget.getHeight() / 2) > 4) continue;
                this.setConnectingWidgetsToXY(this.draggingWidget, widget.getX(), widget.getY() - this.draggingWidget.getHeight() / 2);
            }
        }
    }

    private void setConnectingWidgetsToXY(IProgWidget widget, int x, int y) {
        IProgWidget outputWidget;
        widget.setX(x);
        widget.setY(y);
        IProgWidget[] connectingWidgets = widget.getConnectedParameters();
        if (connectingWidgets != null) {
            for (int i = 0; i < connectingWidgets.length; ++i) {
                if (connectingWidgets[i] == null) continue;
                if (i < connectingWidgets.length / 2) {
                    this.setConnectingWidgetsToXY(connectingWidgets[i], x + widget.getWidth() / 2, y + i * 11);
                    continue;
                }
                int totalWidth = 0;
                IProgWidget branch = connectingWidgets[i];
                while (branch != null) {
                    totalWidth += branch.getWidth() / 2;
                    branch = branch.getConnectedParameters()[0];
                }
                this.setConnectingWidgetsToXY(connectingWidgets[i], x - totalWidth, y + (i - connectingWidgets.length / 2) * 11);
            }
        }
        if ((outputWidget = widget.getOutputWidget()) != null) {
            this.setConnectingWidgetsToXY(outputWidget, x, y + widget.getHeight() / 2);
        }
    }

    private void copyAndConnectConnectingWidgets(IProgWidget original, IProgWidget copy) {
        IProgWidget outputWidget;
        IProgWidget c;
        IProgWidget[] connectingWidgets = original.getConnectedParameters();
        if (connectingWidgets != null) {
            for (int i = 0; i < connectingWidgets.length; ++i) {
                if (connectingWidgets[i] == null) continue;
                c = connectingWidgets[i].copy();
                ((TileEntityProgrammer)this.te).progWidgets.add(c);
                copy.setParameter(i, c);
                this.copyAndConnectConnectingWidgets(connectingWidgets[i], c);
            }
        }
        if ((outputWidget = original.getOutputWidget()) != null) {
            c = outputWidget.copy();
            ((TileEntityProgrammer)this.te).progWidgets.add(c);
            copy.setOutputWidget(c);
            this.copyAndConnectConnectingWidgets(outputWidget, c);
        }
    }

    private void deleteConnectingWidgets(IProgWidget widget) {
        IProgWidget outputWidget;
        ((TileEntityProgrammer)this.te).progWidgets.remove(widget);
        this.removingWidgets.add(new RemovingWidget(widget));
        IProgWidget[] connectingWidgets = widget.getConnectedParameters();
        if (connectingWidgets != null) {
            for (IProgWidget widg : connectingWidgets) {
                if (widg == null) continue;
                this.deleteConnectingWidgets(widg);
            }
        }
        if ((outputWidget = widget.getOutputWidget()) != null) {
            this.deleteConnectingWidgets(outputWidget);
        }
    }

    @Override
    public void func_231023_e_() {
        boolean isDeviceInserted;
        super.func_231023_e_();
        this.programmerUnit.tick();
        if (((TileEntityProgrammer)this.te).recentreStartPiece) {
            this.programmerUnit.gotoPiece(GuiProgrammer.findWidget(((TileEntityProgrammer)this.te).progWidgets, ProgWidgetStart.class));
            ((TileEntityProgrammer)this.te).recentreStartPiece = false;
        }
        boolean bl = this.programmerUnit.getScrollBar().field_230694_p_ = this.showingWidgetProgress == 0;
        if (this.showingWidgetProgress > 0) {
            this.programmerUnit.getScrollBar().setCurrentState(this.programmerUnit.getLastZoom());
        }
        this.undoButton.field_230693_o_ = ((TileEntityProgrammer)this.te).canUndo;
        this.redoButton.field_230693_o_ = ((TileEntityProgrammer)this.te).canRedo;
        this.updateConvertRelativeState();
        ItemStack programmedItem = ((TileEntityProgrammer)this.te).getItemInProgrammingSlot();
        this.oldShowingWidgetProgress = this.showingWidgetProgress;
        int maxProgress = this.maxPage * 22;
        if (this.showingAllWidgets) {
            if (this.showingWidgetProgress < maxProgress) {
                this.showingWidgetProgress += maxProgress / 5;
                if (this.showingWidgetProgress >= maxProgress) {
                    this.showingWidgetProgress = maxProgress;
                    this.updateVisibleProgWidgets();
                }
            } else {
                this.func_231035_a_((IGuiEventListener)this.filterField);
            }
        } else {
            this.showingWidgetProgress -= maxProgress / 5;
            if (this.showingWidgetProgress < 0) {
                this.showingWidgetProgress = 0;
            }
        }
        this.importButton.field_230693_o_ = isDeviceInserted = !programmedItem.func_190926_b();
        this.exportButton.field_230693_o_ = isDeviceInserted && this.programmerUnit.getTotalErrors() == 0;
        this.updateExportButtonTooltip(programmedItem);
        if (!programmedItem.func_190926_b()) {
            this.nameField.func_146184_c(true);
            if (!this.nameField.func_146179_b().equals(programmedItem.func_200301_q().func_150261_e())) {
                this.nameField.func_146180_a(programmedItem.func_200301_q().getString());
            }
        } else {
            this.nameField.func_146184_c(false);
            this.nameField.func_146180_a("");
        }
    }

    private void updateExportButtonTooltip(ItemStack programmedItem) {
        ArrayList<ITextComponent> exportButtonTooltip = new ArrayList<ITextComponent>();
        exportButtonTooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.export", new Object[0]));
        exportButtonTooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.export.programmingWhen", PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.export." + (((TileEntityProgrammer)this.te).programOnInsert ? "onItemInsert" : "pressingButton"), new Object[0])).func_240699_a_(TextFormatting.AQUA));
        exportButtonTooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.export.pressRToChange", new Object[0]).func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GRAY}));
        if (!programmedItem.func_190926_b()) {
            int required = ((TileEntityProgrammer)this.te).getRequiredPuzzleCount();
            if (required != 0) {
                exportButtonTooltip.add(StringTextComponent.field_240750_d_);
            }
            int effectiveRequired = this.field_230706_i_.field_71439_g.func_184812_l_() ? 0 : required;
            int available = ((TileEntityProgrammer)this.te).availablePuzzlePieces + this.countPlayerPuzzlePieces();
            boolean bl = this.exportButton.field_230693_o_ = effectiveRequired <= available;
            if (required > 0) {
                exportButtonTooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.programmable.requiredPieces", effectiveRequired).func_240699_a_(TextFormatting.YELLOW));
                exportButtonTooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.programmable.availablePieces", available).func_240699_a_(TextFormatting.YELLOW));
            } else if (required < 0) {
                exportButtonTooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.programmable.returnedPieces", -effectiveRequired).func_240699_a_(TextFormatting.GREEN));
            }
            if (required != 0 && this.field_230706_i_.field_71439_g.func_184812_l_()) {
                exportButtonTooltip.add((ITextComponent)new StringTextComponent("(Creative mode)").func_240699_a_(TextFormatting.LIGHT_PURPLE));
            }
            if (effectiveRequired > available) {
                exportButtonTooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.programmable.notEnoughPieces", new Object[0]).func_240699_a_(TextFormatting.RED));
            }
        } else {
            exportButtonTooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.export.noProgrammableItem", new Object[0]).func_240699_a_(TextFormatting.GOLD));
        }
        if (this.programmerUnit.getTotalErrors() > 0) {
            exportButtonTooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.errorCount", this.programmerUnit.getTotalErrors()).func_240699_a_(TextFormatting.RED));
        }
        if (this.programmerUnit.getTotalWarnings() > 0) {
            exportButtonTooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.warningCount", this.programmerUnit.getTotalWarnings()).func_240699_a_(TextFormatting.YELLOW));
        }
        this.exportButton.setTooltipText(exportButtonTooltip);
    }

    private int countPlayerPuzzlePieces() {
        int count = 0;
        for (ItemStack stack : ClientUtils.getClientPlayer().field_71071_by.field_70462_a) {
            if (stack.func_77973_b() != ModItems.PROGRAMMING_PUZZLE.get()) continue;
            count += stack.func_190916_E();
        }
        return count;
    }

    private void updateConvertRelativeState() {
        this.convertToRelativeButton.field_230693_o_ = false;
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        tooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.convertToRelative.desc", new Object[0]));
        boolean startFound = false;
        for (IProgWidget startWidget : ((TileEntityProgrammer)this.te).progWidgets) {
            if (!(startWidget instanceof ProgWidgetStart)) continue;
            startFound = true;
            IProgWidget widget = startWidget.getOutputWidget();
            if (widget instanceof ProgWidgetCoordinateOperator) {
                ProgWidgetCoordinateOperator operatorWidget = (ProgWidgetCoordinateOperator)widget;
                if (!operatorWidget.getVariable().isEmpty()) {
                    try {
                        if (this.generateRelativeOperators(operatorWidget, tooltip, true)) {
                            this.convertToRelativeButton.field_230693_o_ = true;
                            continue;
                        }
                        tooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.convertToRelative.notEnoughRoom", new Object[0]));
                    }
                    catch (NullPointerException e) {
                        tooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.convertToRelative.cantHaveVariables", new Object[0]));
                    }
                    continue;
                }
                tooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.convertToRelative.noVariableName", new Object[0]));
                continue;
            }
            tooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.convertToRelative.noBaseCoordinate", new Object[0]));
        }
        if (!startFound) {
            tooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.convertToRelative.noStartPiece", new Object[0]));
        }
        this.convertToRelativeButton.setTooltipText(tooltip);
    }

    private boolean generateRelativeOperators(ProgWidgetCoordinateOperator baseWidget, List<ITextComponent> tooltip, boolean simulate) {
        BlockPos baseCoord = ProgWidgetCoordinateOperator.calculateCoordinate(baseWidget, 0, baseWidget.getOperator());
        HashMap<BlockPos, String> offsetToVariableNames = new HashMap<BlockPos, String>();
        for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
            ProgWidgetCoordinate coordinate;
            if (widget instanceof ProgWidgetArea) {
                String var;
                BlockPos offset;
                ProgWidgetArea area = (ProgWidgetArea)widget;
                if (area.getCoord1Variable().equals("") && (area.x1 != 0 || area.y1 != 0 || area.z1 != 0)) {
                    offset = new BlockPos(area.x1 - baseCoord.func_177958_n(), area.y1 - baseCoord.func_177956_o(), area.z1 - baseCoord.func_177952_p());
                    var = this.getOffsetVariable(offsetToVariableNames, baseWidget.getVariable(), offset);
                    if (!simulate) {
                        area.setCoord1Variable(var);
                    }
                }
                if (!area.getCoord2Variable().equals("") || area.x2 == 0 && area.y2 == 0 && area.z2 == 0) continue;
                offset = new BlockPos(area.x2 - baseCoord.func_177958_n(), area.y2 - baseCoord.func_177956_o(), area.z2 - baseCoord.func_177952_p());
                var = this.getOffsetVariable(offsetToVariableNames, baseWidget.getVariable(), offset);
                if (simulate) continue;
                area.setCoord2Variable(var);
                continue;
            }
            if (!(widget instanceof ProgWidgetCoordinate) || baseWidget.getConnectedParameters()[0] == widget || (coordinate = (ProgWidgetCoordinate)widget).isUsingVariable()) continue;
            BlockPos coord = coordinate.getCoordinate();
            String coordStr = PneumaticCraftUtils.posToString(coord);
            if (PneumaticCraftUtils.distBetweenSq((Vector3i)coord, 0.0, 0.0, 0.0) < 4096.0) {
                if (tooltip == null) continue;
                tooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.convertToRelative.coordIsNotChangedWarning", coordStr));
                continue;
            }
            if (tooltip != null) {
                tooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.convertToRelative.coordIsChangedWarning", coordStr));
            }
            if (simulate) continue;
            BlockPos offset = coord.func_177973_b((Vector3i)baseCoord);
            String var = this.getOffsetVariable(offsetToVariableNames, baseWidget.getVariable(), offset);
            coordinate.setVariable(var);
            coordinate.setUsingVariable(true);
        }
        if (!offsetToVariableNames.isEmpty()) {
            ProgWidgetCoordinateOperator firstOperator = null;
            ProgWidgetCoordinateOperator prevOperator = baseWidget;
            int x = baseWidget.getX();
            for (Map.Entry entry : offsetToVariableNames.entrySet()) {
                ProgWidgetCoordinateOperator operator = new ProgWidgetCoordinateOperator();
                operator.setVariable((String)entry.getValue());
                int y = prevOperator.getY() + prevOperator.getHeight() / 2;
                operator.setX(x);
                operator.setY(y);
                if (!this.isValidPlaced(operator)) {
                    return false;
                }
                ProgWidgetCoordinate coordinatePiece1 = new ProgWidgetCoordinate();
                coordinatePiece1.setX(x + prevOperator.getWidth() / 2);
                coordinatePiece1.setY(y);
                coordinatePiece1.setVariable(baseWidget.getVariable());
                coordinatePiece1.setUsingVariable(true);
                if (!this.isValidPlaced(coordinatePiece1)) {
                    return false;
                }
                ProgWidgetCoordinate coordinatePiece2 = new ProgWidgetCoordinate();
                coordinatePiece2.setX(x + prevOperator.getWidth() / 2 + coordinatePiece1.getWidth() / 2);
                coordinatePiece2.setY(y);
                coordinatePiece2.setCoordinate((BlockPos)entry.getKey());
                if (!this.isValidPlaced(coordinatePiece2)) {
                    return false;
                }
                if (!simulate) {
                    ((TileEntityProgrammer)this.te).progWidgets.add(operator);
                    ((TileEntityProgrammer)this.te).progWidgets.add(coordinatePiece1);
                    ((TileEntityProgrammer)this.te).progWidgets.add(coordinatePiece2);
                }
                if (firstOperator == null) {
                    firstOperator = operator;
                }
                prevOperator = operator;
            }
            if (!simulate) {
                NetworkHandler.sendToServer(new PacketProgrammerUpdate((TileEntityProgrammer)this.te));
                TileEntityProgrammer.updatePuzzleConnections(((TileEntityProgrammer)this.te).progWidgets);
            }
        }
        return true;
    }

    private String getOffsetVariable(Map<BlockPos, String> offsetToVariableNames, String baseVariable, BlockPos offset) {
        if (offset.equals((Object)BlockPos.field_177992_a)) {
            return baseVariable;
        }
        return offsetToVariableNames.computeIfAbsent(offset, k -> "var" + (offsetToVariableNames.size() + 1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        IProgWidget widget;
        double origX = mouseX;
        double origY = mouseY;
        float scale = this.programmerUnit.getScale();
        mouseX = (mouseX - this.programmerUnit.getTranslatedX()) / (double)scale;
        mouseY = (mouseY - this.programmerUnit.getTranslatedY()) / (double)scale;
        if (button == 0) {
            IProgWidget hovered = this.programmerUnit.getHoveredWidget((int)origX, (int)origY);
            ItemStack heldItem = this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o();
            if (heldItem.func_77973_b() instanceof IPositionProvider) {
                return this.mouseClickedWithPosProvider(mouseX, mouseY, hovered, heldItem);
            }
            if (!heldItem.func_190926_b()) {
                return this.mouseClickedWithItem(mouseX, mouseY, hovered, heldItem);
            }
            if (!this.mouseClickedEmpty(mouseX, mouseY, origX, origY, scale, hovered)) return super.func_231044_a_(origX, origY, button);
            return true;
        }
        if (button == 2) {
            if (this.showingWidgetProgress != 0) return this.showWidgetDocs();
            IProgWidget widget2 = this.programmerUnit.getHoveredWidget((int)origX, (int)origY);
            if (widget2 == null) return super.func_231044_a_(origX, origY, button);
            this.draggingWidget = widget2.copy();
            ((TileEntityProgrammer)this.te).progWidgets.add(this.draggingWidget);
            this.dragMouseStartX = mouseX - (double)this.field_147003_i;
            this.dragMouseStartY = mouseY - (double)this.field_147009_r;
            this.dragWidgetStartX = widget2.getX();
            this.dragWidgetStartY = widget2.getY();
            if (!Screen.func_231173_s_()) return true;
            this.copyAndConnectConnectingWidgets(widget2, this.draggingWidget);
            return true;
        }
        if (button != 1 || this.showingWidgetProgress != 0 || (widget = this.programmerUnit.getHoveredWidget((int)origX, (int)origY)) == null) return super.func_231044_a_(origX, origY, button);
        GuiProgWidgetOptionBase<IProgWidget> gui = ProgWidgetGuiManager.getGui(widget, this);
        if (gui == null) return true;
        this.field_230706_i_.func_147108_a(gui);
        return true;
    }

    private boolean mouseClickedWithPosProvider(double mouseX, double mouseY, IProgWidget hovered, ItemStack heldItem) {
        ProgWidgetArea areaToolWidget;
        ProgWidgetArea progWidgetArea = areaToolWidget = heldItem.func_77973_b() instanceof ItemGPSAreaTool ? ItemGPSAreaTool.getArea(heldItem) : null;
        if (hovered != null) {
            if (areaToolWidget != null && hovered instanceof ProgWidgetArea) {
                CompoundNBT tag = new CompoundNBT();
                areaToolWidget.writeToNBT(tag);
                tag.func_74768_a("x", hovered.getX());
                tag.func_74768_a("y", hovered.getY());
                hovered.readFromNBT(tag);
                NetworkHandler.sendToServer(new PacketProgrammerUpdate((TileEntityProgrammer)this.te));
            } else if (heldItem.func_77973_b() == ModItems.GPS_TOOL.get()) {
                if (hovered instanceof ProgWidgetCoordinate) {
                    ((ProgWidgetCoordinate)hovered).loadFromGPSTool(heldItem);
                } else if (hovered instanceof ProgWidgetArea) {
                    BlockPos pos = ItemGPSTool.getGPSLocation(heldItem);
                    String var = ItemGPSTool.getVariable(heldItem);
                    ProgWidgetArea areaHovered = (ProgWidgetArea)hovered;
                    if (pos != null) {
                        areaHovered.setP1(pos);
                    }
                    areaHovered.setP2(BlockPos.field_177992_a);
                    areaHovered.setCoord1Variable(var);
                    areaHovered.setCoord2Variable("");
                }
                NetworkHandler.sendToServer(new PacketProgrammerUpdate((TileEntityProgrammer)this.te));
            }
        } else {
            ArrayList<ProgWidget> toCreate = new ArrayList<ProgWidget>();
            if (areaToolWidget != null) {
                if (Screen.func_231173_s_()) {
                    ProgWidgetCoordinate pc = new ProgWidgetCoordinate();
                    pc.setCoordinate(new BlockPos(areaToolWidget.x1, areaToolWidget.y1, areaToolWidget.z1));
                    toCreate.add(pc);
                    if (areaToolWidget.x2 != 0 && areaToolWidget.y2 != 0 && areaToolWidget.z2 != 0) {
                        ProgWidgetCoordinate pc2 = new ProgWidgetCoordinate();
                        pc2.setCoordinate(new BlockPos(areaToolWidget.x2, areaToolWidget.y2, areaToolWidget.z2));
                        toCreate.add(pc2);
                    }
                } else {
                    toCreate.add(areaToolWidget);
                }
            } else if (heldItem.func_77973_b() == ModItems.GPS_TOOL.get()) {
                if (Screen.func_231173_s_()) {
                    BlockPos pos = ItemGPSTool.getGPSLocation(heldItem);
                    ProgWidgetArea areaWidget = ProgWidgetArea.fromPositions(pos, BlockPos.field_177992_a);
                    String var = ItemGPSTool.getVariable(heldItem);
                    if (!var.isEmpty()) {
                        areaWidget.setCoord1Variable(var);
                    }
                    toCreate.add(areaWidget);
                } else {
                    ProgWidgetCoordinate coordWidget = new ProgWidgetCoordinate();
                    coordWidget.loadFromGPSTool(heldItem);
                    toCreate.add(coordWidget);
                }
            }
            for (int i = 0; i < toCreate.size(); ++i) {
                IProgWidget p = (IProgWidget)toCreate.get(i);
                p.setX((int)(mouseX - (double)this.field_147003_i - (double)p.getWidth() / 3.0));
                p.setY((int)(mouseY - (double)this.field_147009_r - (double)p.getHeight() / 4.0) + i * p.getHeight());
                if (this.programmerUnit.isOutsideProgrammingArea(p)) continue;
                ((TileEntityProgrammer)this.te).progWidgets.add(p);
            }
            if (!toCreate.isEmpty()) {
                NetworkHandler.sendToServer(new PacketProgrammerUpdate((TileEntityProgrammer)this.te));
            }
        }
        return true;
    }

    private boolean mouseClickedWithItem(double mouseX, double mouseY, IProgWidget hovered, ItemStack heldItem) {
        if (hovered == null) {
            ProgWidgetItemFilter p = new ProgWidgetItemFilter();
            p.setFilter(heldItem.func_77946_l());
            p.setX((int)(mouseX - (double)this.field_147003_i - (double)p.getWidth() / 3.0));
            p.setY((int)(mouseY - (double)this.field_147009_r - (double)p.getHeight() / 4.0));
            if (!this.programmerUnit.isOutsideProgrammingArea(p)) {
                ((TileEntityProgrammer)this.te).progWidgets.add(p);
            }
            NetworkHandler.sendToServer(new PacketProgrammerUpdate((TileEntityProgrammer)this.te));
            return true;
        }
        if (hovered instanceof ProgWidgetItemFilter) {
            ProgWidgetItemFilter p = (ProgWidgetItemFilter)hovered;
            p.setFilter(heldItem.func_77946_l());
            NetworkHandler.sendToServer(new PacketProgrammerUpdate((TileEntityProgrammer)this.te));
            return true;
        }
        return false;
    }

    private boolean mouseClickedEmpty(double mouseX, double mouseY, double origX, double origY, float scale, IProgWidget hovered) {
        if (this.showingAllWidgets || origX > (double)(this.field_147003_i + this.getProgrammerBounds().func_199318_a() + this.getProgrammerBounds().func_199316_c())) {
            for (IProgWidget widget : this.visibleSpawnWidgets) {
                if (!(origX >= (double)(widget.getX() + this.field_147003_i)) || !(origY >= (double)(widget.getY() + this.field_147009_r)) || !(origX <= (double)((float)(widget.getX() + this.field_147003_i) + (float)widget.getWidth() / 2.0f)) || !(origY <= (double)((float)(widget.getY() + this.field_147009_r) + (float)widget.getHeight() / 2.0f))) continue;
                this.draggingWidget = widget.copy();
                ((TileEntityProgrammer)this.te).progWidgets.add(this.draggingWidget);
                this.dragMouseStartX = mouseX - (double)((int)((float)this.field_147003_i / scale));
                this.dragMouseStartY = mouseY - (double)((int)((float)this.field_147009_r / scale));
                this.dragWidgetStartX = (int)(((double)widget.getX() - this.programmerUnit.getTranslatedX()) / (double)scale);
                this.dragWidgetStartY = (int)(((double)widget.getY() - this.programmerUnit.getTranslatedY()) / (double)scale);
                return true;
            }
        }
        if (hovered != null) {
            this.draggingWidget = hovered;
            this.dragMouseStartX = mouseX - (double)this.field_147003_i;
            this.dragMouseStartY = mouseY - (double)this.field_147009_r;
            this.dragWidgetStartX = hovered.getX();
            this.dragWidgetStartY = hovered.getY();
            return true;
        }
        if (this.getProgrammerBounds().func_199315_b((int)origX - this.field_147003_i, (int)origY - this.field_147009_r)) {
            this.draggingBG = true;
        }
        return false;
    }

    @Override
    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        this.draggingBG = false;
        if (this.draggingWidget != null) {
            if (this.programmerUnit.isOutsideProgrammingArea(this.draggingWidget)) {
                this.deleteConnectingWidgets(this.draggingWidget);
            } else {
                this.handlePuzzleMargins();
                if (!this.isValidPlaced(this.draggingWidget)) {
                    this.setConnectingWidgetsToXY(this.draggingWidget, (int)this.dragWidgetStartX, (int)this.dragWidgetStartY);
                    if (this.programmerUnit.isOutsideProgrammingArea(this.draggingWidget) || !this.isValidPlaced(this.draggingWidget)) {
                        this.deleteConnectingWidgets(this.draggingWidget);
                    }
                }
            }
            NetworkHandler.sendToServer(new PacketProgrammerUpdate((TileEntityProgrammer)this.te));
            TileEntityProgrammer.updatePuzzleConnections(((TileEntityProgrammer)this.te).progWidgets);
            this.draggingWidget = null;
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231043_a_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        return this.programmerUnit.mouseScrolled(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
    }

    @Override
    public boolean func_231045_a_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        if (this.draggingWidget != null) {
            mouseX = (mouseX - this.programmerUnit.getTranslatedX()) / (double)this.programmerUnit.getScale();
            mouseY = (mouseY - this.programmerUnit.getTranslatedY()) / (double)this.programmerUnit.getScale();
            this.setConnectingWidgetsToXY(this.draggingWidget, (int)(mouseX - this.dragMouseStartX + this.dragWidgetStartX - (double)this.field_147003_i), (int)(mouseY - this.dragMouseStartY + this.dragWidgetStartY - (double)this.field_147009_r));
            return true;
        }
        if (this.draggingBG) {
            return this.programmerUnit.mouseDragged(mouseX, mouseY, mouseButton, dragX, dragY);
        }
        return false;
    }

    @Override
    public void func_231164_f_() {
        ((TileEntityProgrammer)this.te).translatedX = this.programmerUnit.getTranslatedX();
        ((TileEntityProgrammer)this.te).translatedY = this.programmerUnit.getTranslatedY();
        ((TileEntityProgrammer)this.te).zoomState = this.programmerUnit.getLastZoom();
        ((TileEntityProgrammer)this.te).showFlow = this.showFlow.checked;
        ((TileEntityProgrammer)this.te).showInfo = this.showInfo.checked;
    }

    public static IProgWidget findWidget(List<IProgWidget> widgets, Class<? extends IProgWidget> cls) {
        return widgets.stream().filter(w -> cls.isAssignableFrom(w.getClass())).findFirst().orElse(null);
    }

    private static class RemovingWidget {
        final IProgWidget widget;
        double ty = 0.0;
        double tx = 0.0;
        final double velX;
        double velY;

        private RemovingWidget(IProgWidget widget) {
            this.velX = (Minecraft.func_71410_x().field_71441_e.field_73012_v.nextDouble() - 0.5) * 3.0;
            this.velY = -4.0;
            this.widget = widget;
        }

        public void tick() {
            this.ty += this.velY;
            this.tx += this.velX;
            this.velY += 0.35;
        }
    }

    private static class DifficultyButton
    extends WidgetRadioButton {
        final IProgWidget.WidgetDifficulty difficulty;

        DifficultyButton(int x, int y, int color, IProgWidget.WidgetDifficulty difficulty, Consumer<WidgetRadioButton> pressable) {
            super(x, y, color, (ITextComponent)PneumaticCraftUtils.xlate(difficulty.getTranslationKey(), new Object[0]), pressable);
            this.difficulty = difficulty;
        }
    }

    private static class FilterTextField
    extends WidgetTextField {
        FilterTextField(FontRenderer font, int x, int y, int width, int height) {
            super(font, x, y, width, height);
        }

        @Override
        public void func_230431_b_(MatrixStack matrixStack, int x, int y, float partialTicks) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, 300.0);
            super.func_230431_b_(matrixStack, x, y, partialTicks);
            matrixStack.func_227865_b_();
        }
    }
}

