/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.google.common.base.CaseFormat;
import com.mojang.blaze3d.matrix.MatrixStack;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticScreenBase;
import me.desht.pneumaticcraft.client.gui.GuiProgrammer;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaType;
import me.desht.pneumaticcraft.common.util.JsonToNBTConverter;
import me.desht.pneumaticcraft.common.util.LegacyAreaWidgetConverter;
import me.desht.pneumaticcraft.common.util.NBTToJsonConverter;
import me.desht.pneumaticcraft.common.util.PastebinHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiPastebin
extends GuiPneumaticScreenBase {
    private WidgetTextField usernameBox;
    private WidgetTextField passwordBox;
    private WidgetTextField pastebinBox;
    private WidgetCheckBox prettyCB;
    private final CompoundNBT pastingNBT;
    private final Screen parentScreen;
    private ITextComponent statusMessage = StringTextComponent.field_240750_d_;
    private ITextComponent lastMessage = StringTextComponent.field_240750_d_;
    private int messageTimer;
    private EnumState state = EnumState.NONE;
    CompoundNBT outputTag;
    boolean shouldMerge;

    GuiPastebin(Screen parentScreen, CompoundNBT tag) {
        super((ITextComponent)new StringTextComponent("Pastebin"));
        this.xSize = 183;
        this.ySize = 202;
        this.pastingNBT = tag;
        this.parentScreen = parentScreen;
        Minecraft.func_71410_x().field_195559_v.func_197967_a(true);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        if (!PastebinHandler.isLoggedIn()) {
            this.usernameBox = new WidgetTextField(this.field_230712_o_, this.guiLeft + 10, this.guiTop + 30, 80, 10);
            this.func_230480_a_(this.usernameBox);
            this.passwordBox = new WidgetTextField(this.field_230712_o_, this.guiLeft + 10, this.guiTop + 56, 80, 10).setAsPasswordBox();
            this.func_230480_a_(this.passwordBox);
            WidgetButtonExtended loginButton = new WidgetButtonExtended(this.guiLeft + 100, this.guiTop + 30, 60, 20, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.button.login", new Object[0]), b -> this.login());
            loginButton.setTooltipText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.loginOptional", new Object[0]));
            this.func_230480_a_(loginButton);
            this.addLabel((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.username", new Object[0]), this.guiLeft + 10, this.guiTop + 20);
            this.addLabel((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.password", new Object[0]), this.guiLeft + 10, this.guiTop + 46);
        } else {
            WidgetButtonExtended logoutButton = new WidgetButtonExtended(this.guiLeft + 60, this.guiTop + 30, 60, 20, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.button.logout", new Object[0]), b -> this.logout());
            this.func_230480_a_(logoutButton);
        }
        this.pastebinBox = new WidgetTextField(this.field_230712_o_, this.guiLeft + 10, this.guiTop + 130, 160, 10){

            protected void func_230995_c_(boolean focused) {
                if (focused) {
                    this.func_146202_e();
                    this.func_146199_i(0);
                }
                super.func_230995_c_(focused);
            }
        };
        this.func_230480_a_(this.pastebinBox);
        WidgetButtonExtended pasteButton = new WidgetButtonExtended(this.guiLeft + 31, this.guiTop + 78, 120, 20, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.button.upload", new Object[0]), b -> this.sendToPastebin());
        this.func_230480_a_(pasteButton);
        WidgetButtonExtended getButton = new WidgetButtonExtended(this.guiLeft + 31, this.guiTop + 167, 120, 20, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.button.get", new Object[0]), b -> this.getFromPastebin());
        this.func_230480_a_(getButton);
        WidgetButtonExtended putInClipBoard = new WidgetButtonExtended(this.guiLeft + 8, this.guiTop + 78, 20, 20, StringTextComponent.field_240750_d_, b -> this.putToClipboard());
        putInClipBoard.setRenderedIcon(Textures.GUI_COPY_ICON_LOCATION);
        putInClipBoard.setTooltipText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.button.copyToClipboard", new Object[0]));
        this.func_230480_a_(putInClipBoard);
        WidgetButtonExtended retrieveFromClipboard = new WidgetButtonExtended(this.guiLeft + 8, this.guiTop + 167, 20, 20, StringTextComponent.field_240750_d_, b -> this.getFromClipboard());
        retrieveFromClipboard.setRenderedIcon(Textures.GUI_PASTE_ICON_LOCATION);
        retrieveFromClipboard.setTooltipText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.button.loadFromClipboard", new Object[0]));
        this.func_230480_a_(retrieveFromClipboard);
        this.prettyCB = new WidgetCheckBox(0, this.guiTop + 102, -12566464, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.pretty", new Object[0]), b -> {
            this.shouldMerge = b.checked;
        });
        this.prettyCB.field_230690_l_ = this.guiLeft + (170 - this.prettyCB.func_230998_h_());
        this.prettyCB.setTooltipKey("pneumaticcraft.gui.pastebin.pretty.tooltip");
        this.func_230480_a_(this.prettyCB);
        if (this.parentScreen instanceof GuiProgrammer) {
            WidgetCheckBox mergeCB = new WidgetCheckBox(0, this.guiTop + 155, -12566464, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.merge", new Object[0]), b -> {
                this.shouldMerge = b.checked;
            });
            mergeCB.field_230690_l_ = this.guiLeft + (170 - mergeCB.func_230998_h_());
            mergeCB.setTooltipKey("pneumaticcraft.gui.pastebin.merge.tooltip");
            this.func_230480_a_(mergeCB);
        }
        this.addLabel((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.pastebinLink", new Object[0]), this.guiLeft + 10, this.guiTop + 120);
    }

    private void login() {
        PastebinHandler.login(this.usernameBox.func_146179_b(), this.passwordBox.func_146179_b());
        this.state = EnumState.LOGIN;
        this.statusMessage = PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.loggingIn", new Object[0]);
    }

    private void logout() {
        PastebinHandler.logout();
        this.state = EnumState.LOGOUT;
    }

    private void sendToPastebin() {
        PastebinHandler.put(new NBTToJsonConverter(this.pastingNBT).convert(this.prettyCB.checked));
        this.state = EnumState.PUTTING;
        this.statusMessage = PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.uploadingToPastebin", new Object[0]);
    }

    private void getFromPastebin() {
        PastebinHandler.get(this.pastebinBox.func_146179_b());
        this.state = EnumState.GETTING;
        this.statusMessage = PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.retrievingFromPastebin", new Object[0]);
    }

    private void putToClipboard() {
        this.field_230706_i_.field_195559_v.func_197960_a(new NBTToJsonConverter(this.pastingNBT).convert(this.prettyCB.checked));
        this.statusMessage = PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.clipboardSetToContents", new Object[0]);
    }

    private void getFromClipboard() {
        this.readFromString(this.field_230706_i_.field_195559_v.func_197965_a());
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.state == EnumState.LOGOUT) {
            this.state = EnumState.NONE;
            this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
        }
        if (this.state != EnumState.NONE && PastebinHandler.isDone()) {
            this.statusMessage = StringTextComponent.field_240750_d_;
            switch (this.state) {
                case GETTING: {
                    String pastebinText = PastebinHandler.getHandler().contents;
                    if (pastebinText != null) {
                        this.readFromString(pastebinText);
                        break;
                    }
                    this.statusMessage = PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.invalidPastebin", new Object[0]);
                    break;
                }
                case PUTTING: {
                    if (PastebinHandler.getException() != null) {
                        this.statusMessage = new StringTextComponent(PastebinHandler.getException().getMessage());
                        break;
                    }
                    String pastebinText = PastebinHandler.getHandler().getLink;
                    if (pastebinText == null) {
                        pastebinText = "<ERROR>";
                    }
                    if (pastebinText.contains("pastebin.com")) {
                        this.pastebinBox.func_146180_a(pastebinText);
                        this.setTempMessage((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.uploadedToPastebin", new Object[0]));
                        break;
                    }
                    this.statusMessage = new StringTextComponent(pastebinText);
                    break;
                }
                case LOGIN: {
                    if (!PastebinHandler.isLoggedIn()) {
                        this.statusMessage = PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.invalidLogin", new Object[0]);
                    }
                    this.func_231160_c_();
                }
            }
            this.state = EnumState.NONE;
        }
        if (this.messageTimer > 0 && --this.messageTimer <= 0) {
            this.lastMessage = StringTextComponent.field_240750_d_;
        }
    }

    private void setTempMessage(ITextComponent msg) {
        this.lastMessage = msg;
        this.messageTimer = 60;
    }

    private void readFromString(String string) {
        try {
            this.outputTag = new JsonToNBTConverter(string).convert();
            if (this.outputTag.func_74764_b("widgets")) {
                this.doLegacyConversion(this.outputTag);
            }
            this.setTempMessage((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.retrievedFromPastebin", new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setTempMessage((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.invalidFormattedPastebin", new Object[0]).func_240699_a_(TextFormatting.GOLD));
        }
    }

    private void doLegacyConversion(CompoundNBT nbt) {
        ListNBT l = nbt.func_150295_c("widgets", 10);
        int areaConversions = 0;
        for (int i = 0; i < l.size(); ++i) {
            CompoundNBT subTag = l.func_150305_b(i);
            String newName = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, subTag.func_74779_i("name"));
            subTag.func_74778_a("name", "pneumaticcraft:" + newName);
            if (!newName.equals("area")) continue;
            LegacyAreaWidgetConverter.EnumOldAreaType oldType = LegacyAreaWidgetConverter.EnumOldAreaType.values()[subTag.func_74762_e("type")];
            AreaType newType = LegacyAreaWidgetConverter.convertFromLegacyFormat(oldType, subTag.func_74762_e("typeInfo"));
            subTag.func_74778_a("type", newType.getName());
            newType.writeToNBT(subTag);
            ++areaConversions;
        }
        nbt.func_218657_a("pneumaticcraft:progWidgets", (INBT)l);
        nbt.func_82580_o("widgets");
        if (areaConversions > 0) {
            Log.info("Pastebin import: converted %d legacy area widgets", areaConversions);
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int x, int y, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, x, y, partialTicks);
        if (this.statusMessage != StringTextComponent.field_240750_d_) {
            GuiPastebin.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.statusMessage, (int)(this.guiLeft + 5), (int)(this.guiTop + 5), (int)-256);
        } else if (this.lastMessage != StringTextComponent.field_240750_d_) {
            GuiPastebin.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.lastMessage, (int)(this.guiLeft + 5), (int)(this.guiTop + 5), (int)-16711936);
        }
    }

    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public void func_231175_as__() {
        this.field_230706_i_.func_147108_a(this.parentScreen);
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.GUI_PASTEBIN;
    }

    public boolean func_231177_au__() {
        return false;
    }

    private static enum EnumState {
        NONE,
        GETTING,
        PUTTING,
        LOGIN,
        LOGOUT;

    }
}

