/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.inventory.ContainerInventorySearcher;
import me.desht.pneumaticcraft.common.item.ItemGPSAreaTool;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class GuiInventorySearcher
extends ContainerScreen<ContainerInventorySearcher> {
    private final ItemStackHandler inventory = new ItemStackHandler(1);
    private final Screen parentScreen;
    private Predicate<ItemStack> stackPredicate = itemStack -> true;
    private WidgetLabel label;
    private int clickedMouseButton;

    public GuiInventorySearcher(ContainerInventorySearcher container, PlayerInventory inv, ITextComponent title) {
        super((Container)container, inv, title);
        inv.field_70458_d.field_71070_bA = container;
        this.field_230711_n_ = true;
        this.field_147000_g = 176;
        this.parentScreen = Minecraft.func_71410_x().field_71462_r;
        container.init((IItemHandler)this.inventory);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.label = new WidgetLabel(this.field_147003_i + 105, this.field_147009_r + 28, StringTextComponent.field_240750_d_, -12566400);
        this.func_230480_a_(this.label);
    }

    public boolean func_231178_ax__() {
        return true;
    }

    public void func_231175_as__() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
        if (this.parentScreen != null) {
            ClientUtils.closeContainerGui(this.parentScreen);
        } else {
            super.func_231175_as__();
        }
    }

    public void setStackPredicate(Predicate<ItemStack> predicate) {
        this.stackPredicate = predicate;
    }

    @Nonnull
    public ItemStack getSearchStack() {
        return this.inventory.getStackInSlot(0);
    }

    public void setSearchStack(@Nonnull ItemStack stack) {
        if (!stack.func_190926_b() && this.stackPredicate.test(stack)) {
            this.inventory.setStackInSlot(0, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
        }
    }

    protected void func_184098_a(Slot slot, int slotId, int mouseButton, ClickType clickType) {
        if (slot != null) {
            if (slot.field_75222_d == 36) {
                this.clickedMouseButton = 0;
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                this.clickedMouseButton = mouseButton;
                this.setSearchStack(slot.func_75211_c());
            }
        }
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.inventory.getStackInSlot(0).func_77973_b() instanceof IPositionProvider) {
            this.label.func_238482_a_((ITextComponent)new StringTextComponent(PneumaticCraftUtils.posToString(this.getBlockPos())));
        } else {
            this.label.func_238482_a_(StringTextComponent.field_240750_d_);
        }
    }

    @Nonnull
    public BlockPos getBlockPos() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (stack.func_77973_b() instanceof IPositionProvider) {
            List<BlockPos> posList = ((IPositionProvider)stack.func_77973_b()).getRawStoredPositions(ClientUtils.getClientWorld(), stack);
            int posIdx = this.getPosIdx(stack);
            if (!posList.isEmpty()) {
                BlockPos pos = posList.get(Math.min(posIdx, posList.size() - 1));
                return pos == null ? BlockPos.field_177992_a : pos;
            }
        }
        return BlockPos.field_177992_a;
    }

    private int getPosIdx(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemGPSAreaTool) {
            switch (this.clickedMouseButton) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 0;
                }
            }
            return 1;
        }
        return this.clickedMouseButton;
    }

    protected void func_230450_a_(MatrixStack matrixStack, float par1, int par2, int par3) {
        this.func_230446_a_(matrixStack);
        this.field_230706_i_.func_110434_K().func_110577_a(Textures.GUI_INVENTORY_SEARCHER);
        int xStart = (this.field_230708_k_ - this.field_146999_f) / 2;
        int yStart = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrixStack, xStart, yStart, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.field_230712_o_.func_238422_b_(matrixStack, this.func_231171_q_().func_241878_f(), (float)this.field_230708_k_ / 2.0f, 5.0f, 0x404040);
        for (int i = 0; i < ((ContainerInventorySearcher)this.field_147002_h).field_75151_b.size() - 1; ++i) {
            Slot slot = (Slot)((ContainerInventorySearcher)this.field_147002_h).field_75151_b.get(i);
            if (this.stackPredicate.test(slot.func_75211_c())) continue;
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.func_238468_a_(matrixStack, slot.field_75223_e, slot.field_75221_f, slot.field_75223_e + 16, slot.field_75221_f + 16, -1071636448, -1071636448);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int par1, int par2, float par3) {
        super.func_230430_a_(matrixStack, par1, par2, par3);
        if (this.field_147006_u != null && this.stackPredicate.test(this.field_147006_u.func_75211_c())) {
            this.func_230459_a_(matrixStack, par1, par2);
        }
    }
}

