/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.recipe.AmadronRecipe;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAmadronOffer;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.gui.widget.WidgetVerticalScrollbar;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.inventory.ContainerAmadron;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAmadronOrderUpdate;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiAmadron
extends GuiPneumaticContainerBase<ContainerAmadron, TileEntityBase> {
    private static final int ROWS = 4;
    public static final int OFFERS_PER_PAGE = 8;
    private WidgetTextField searchBar;
    private WidgetVerticalScrollbar scrollbar;
    private WidgetLabel pageLabel;
    private int page = 0;
    private final List<WidgetAmadronOfferAdjustable> offerWidgets = new ArrayList<WidgetAmadronOfferAdjustable>();
    private boolean needsRefreshing;
    private boolean hadProblem = false;
    private WidgetButtonExtended orderButton;
    private WidgetButtonExtended addTradeButton;
    private WidgetAnimatedStat customTradesTab;
    private boolean needTooltipUpdate = true;
    private int problemTimer = 0;

    public GuiAmadron(ContainerAmadron container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, (ITextComponent)new StringTextComponent(""));
        this.field_146999_f = 176;
        this.field_147000_g = 202;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        TranslationTextComponent amadron = PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.title", new Object[0]);
        this.addLabel((ITextComponent)amadron, this.field_147003_i + this.field_146999_f / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)amadron) / 2, this.field_147009_r + 5, 0xFFFFFF).setDropShadow(true);
        this.addLabel((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.search", new Object[0]), this.field_147003_i + 76 - this.field_230712_o_.func_78256_a(I18n.func_135052_a((String)"pneumaticcraft.gui.search", (Object[])new Object[0])), this.field_147009_r + 41, 0xFFFFFF);
        this.addInfoTab((ITextComponent)PneumaticCraftUtils.xlate("gui.tooltip.item.pneumaticcraft.amadron_tablet", new Object[0]));
        this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.ghostSlotInteraction.title", new Object[0]), Textures.GUI_MOUSE_LOCATION, -16733441, true).setText(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.info.ghostSlotInteraction", new Object[0]));
        this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.amadron.disclaimer.title", new Object[0]), new ItemStack((IItemProvider)Items.field_151099_bA), -16776961, true).setText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.amadron.disclaimer", new Object[0]));
        this.customTradesTab = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.amadron.customTrades", new Object[0]), new ItemStack((IItemProvider)Items.field_151045_i), -3117056, false);
        this.customTradesTab.setMinimumExpandedDimensions(80, 50);
        this.field_230712_o_.getClass();
        this.searchBar = new WidgetTextField(this.field_230712_o_, this.field_147003_i + 79, this.field_147009_r + 40, 73, 9);
        this.searchBar.func_212954_a(s -> this.sendDelayed(8));
        this.func_230480_a_(this.searchBar);
        this.func_231035_a_((IGuiEventListener)this.searchBar);
        this.scrollbar = new WidgetVerticalScrollbar(this.field_147003_i + 156, this.field_147009_r + 54, 142).setStates(1).setListening(true);
        this.func_230480_a_(this.scrollbar);
        this.orderButton = new WidgetButtonExtended(this.field_147003_i + 52, this.field_147009_r + 16, 72, 20, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.button.order", new Object[0])).withTag("order");
        this.func_230480_a_(this.orderButton);
        this.updateOrderButtonTooltip();
        this.addTradeButton = new WidgetButtonExtended(16, 26, 20, 20).withTag("addPlayerTrade").setRenderStacks(new ItemStack((IItemProvider)Items.field_151166_bC)).setTooltipText((List<ITextComponent>)ImmutableList.of((Object)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.button.addTrade", new Object[0]), (Object)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.button.addTrade.tooltip", new Object[0])));
        this.customTradesTab.addSubWidget((Widget)this.addTradeButton);
        this.pageLabel = new WidgetLabel(this.field_147003_i + 158, this.field_147009_r + 49, (ITextComponent)new StringTextComponent(""));
        this.func_230480_a_(this.pageLabel);
        this.pageLabel.setScale(0.5f);
        this.pageLabel.setColor(-2039584);
        this.needsRefreshing = true;
    }

    public static void basketUpdated() {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiAmadron) {
            ((GuiAmadron)Minecraft.func_71410_x().field_71462_r).needTooltipUpdate = true;
        }
    }

    @Override
    protected void doDelayedAction() {
        this.needsRefreshing = true;
        this.scrollbar.setCurrentState(0);
    }

    public boolean func_231043_a_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        return this.scrollbar.func_231043_a_(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
    }

    @Override
    protected int getBackgroundTint() {
        return 429612;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_AMADRON;
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.needsRefreshing || this.page != this.scrollbar.getState()) {
            this.setPage(this.scrollbar.getState());
        }
        for (WidgetAmadronOfferAdjustable offerWidget : this.offerWidgets) {
            offerWidget.setAffordable(((ContainerAmadron)this.field_147002_h).affordableOffers[offerWidget.index]);
            offerWidget.setShoppingAmount(((ContainerAmadron)this.field_147002_h).getShoppingBasketUnits(offerWidget.getOffer().func_199560_c()));
        }
        if (!this.hadProblem && ((ContainerAmadron)this.field_147002_h).problemState != ContainerAmadron.EnumProblemState.NO_PROBLEMS) {
            this.problemTab.openStat();
        }
        this.hadProblem = ((ContainerAmadron)this.field_147002_h).problemState != ContainerAmadron.EnumProblemState.NO_PROBLEMS;
        this.addTradeButton.field_230693_o_ = ((ContainerAmadron)this.field_147002_h).currentPlayerOffers < ((ContainerAmadron)this.field_147002_h).maxPlayerOffers;
        TranslationTextComponent text = PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.button.addTrade.tooltip.offerCount", ((ContainerAmadron)this.field_147002_h).currentPlayerOffers, ((ContainerAmadron)this.field_147002_h).maxPlayerOffers == Integer.MAX_VALUE ? "\u221e" : Integer.valueOf(((ContainerAmadron)this.field_147002_h).maxPlayerOffers));
        this.customTradesTab.setText((ITextComponent)text);
        boolean bl = this.orderButton.field_230693_o_ = !((ContainerAmadron)this.field_147002_h).isBasketEmpty() && ((ContainerAmadron)this.field_147002_h).problemState == ContainerAmadron.EnumProblemState.NO_PROBLEMS;
        if (this.needTooltipUpdate) {
            this.updateOrderButtonTooltip();
            this.needTooltipUpdate = false;
        }
        if (this.problemTimer == 0 && ((ContainerAmadron)this.field_147002_h).problemState != ContainerAmadron.EnumProblemState.NO_PROBLEMS) {
            this.problemTimer = 70;
        } else if (this.problemTimer > 0 && --this.problemTimer <= 0) {
            ((ContainerAmadron)this.field_147002_h).problemState = ContainerAmadron.EnumProblemState.NO_PROBLEMS;
        }
    }

    private void updateOrderButtonTooltip() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.button.order.tooltip", new Object[0]));
        if (!((ContainerAmadron)this.field_147002_h).isBasketEmpty()) {
            builder.add((Object)StringTextComponent.field_240750_d_);
            builder.add((Object)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.basket", new Object[0]).func_240701_a_(new TextFormatting[]{TextFormatting.AQUA, TextFormatting.UNDERLINE}));
            for (AmadronRecipe offer : AmadronOfferManager.getInstance().getActiveOffers()) {
                int nOrders = ((ContainerAmadron)this.field_147002_h).getShoppingBasketUnits(offer.func_199560_c());
                if (nOrders <= 0) continue;
                String in = offer.getInput().getAmount() * nOrders + " x " + offer.getInput().getName();
                String out = offer.getOutput().getAmount() * nOrders + " x " + offer.getOutput().getName();
                builder.add((Object)new StringTextComponent("\u2022 " + TextFormatting.YELLOW + out));
                builder.add((Object)new StringTextComponent(TextFormatting.GOLD + "   for " + TextFormatting.YELLOW + in));
            }
        }
        this.orderButton.setTooltipText((List<ITextComponent>)builder.build());
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.field_230706_i_.field_71439_g.func_71053_j();
        }
        return this.searchBar.func_231046_a_(keyCode, scanCode, modifiers) || this.searchBar.func_212955_f() || super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public void setPage(int page) {
        this.page = page;
        this.updateVisibleOffers();
        int nPages = (((ContainerAmadron)this.field_147002_h).activeOffers.size() - 1) / 8 + 1;
        this.pageLabel.func_238482_a_((ITextComponent)new StringTextComponent(page + 1 + "/" + nPages));
    }

    private void updateVisibleOffers() {
        AmadronRecipe offer;
        int i;
        this.needsRefreshing = false;
        ArrayList<AmadronRecipe> visibleOffers = new ArrayList<AmadronRecipe>();
        int skippedOffers = 0;
        int applicableOffers = 0;
        for (i = 0; i < ((ContainerAmadron)this.field_147002_h).activeOffers.size(); ++i) {
            offer = ((ContainerAmadron)this.field_147002_h).activeOffers.get(i);
            if (!offer.passesQuery(this.searchBar.func_146179_b())) continue;
            ++applicableOffers;
            if (skippedOffers < this.page * 8) {
                ++skippedOffers;
                continue;
            }
            if (visibleOffers.size() >= 8) continue;
            visibleOffers.add(offer);
        }
        this.scrollbar.setStates(Math.max(1, (applicableOffers + 8 - 1) / 8 - 1));
        this.field_230710_m_.removeAll(this.offerWidgets);
        this.field_230705_e_.removeAll(this.offerWidgets);
        this.offerWidgets.clear();
        for (i = 0; i < visibleOffers.size(); ++i) {
            offer = (AmadronRecipe)visibleOffers.get(i);
            int idx = ((ContainerAmadron)this.field_147002_h).activeOffers.indexOf(offer);
            if (idx < 0) continue;
            WidgetAmadronOfferAdjustable widget = new WidgetAmadronOfferAdjustable(this.field_147003_i + 6 + 73 * (i % 2), this.field_147009_r + 55 + 35 * (i / 2), offer, idx);
            this.func_230480_a_(widget);
            this.offerWidgets.add(widget);
        }
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    @Override
    protected void addProblems(List<ITextComponent> curInfo) {
        super.addProblems(curInfo);
        if (((ContainerAmadron)this.field_147002_h).problemState != ContainerAmadron.EnumProblemState.NO_PROBLEMS) {
            curInfo.addAll(GuiUtils.xlateAndSplit(((ContainerAmadron)this.field_147002_h).problemState.getTranslationKey(), new Object[0]));
        }
    }

    @Override
    public void onGuiUpdate() {
        this.needTooltipUpdate = true;
    }

    static class WidgetAmadronOfferAdjustable
    extends WidgetAmadronOffer {
        private final int index;

        WidgetAmadronOfferAdjustable(int x, int y, AmadronRecipe offer, int index) {
            super(x, y, offer);
            this.index = index;
        }

        @Override
        public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
            if (super.func_231044_a_(mouseX, mouseY, mouseButton)) {
                return true;
            }
            if (this.func_230992_c_(mouseX, mouseY) && this.getOffer().isUsableByPlayer(ClientUtils.getClientPlayer())) {
                NetworkHandler.sendToServer(new PacketAmadronOrderUpdate(this.getOffer().func_199560_c(), mouseButton, Screen.func_231173_s_()));
                return true;
            }
            return false;
        }
    }
}

